/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.nameMapping.RfcGlobalNameMapping;
import com.sap.aii.proxy.generation.core.util.Util;
import com.sap.aii.util.xsd.api.XsdAnnotation;
import com.sap.aii.util.xsd.api.XsdDocumentation;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdFacet;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import java.util.List;

class Comments
implements ProxyCodingSegments {
    private static final String VALUE_SPACE = "Value space = ";
    private static final String XSDL = "Xsdl ";

    private Comments() {
    }

    static final String getComment(XsdAnnotation annotation) {
        if (annotation != null) {
            List docs = annotation.getDocumentations();
            int i = 0;
            while (i < docs.size()) {
                List doc = ((XsdDocumentation)docs.get(i)).getContent();
                if (doc.size() > 0) {
                    return (String)doc.get(0);
                }
                ++i;
            }
        }
        return new String();
    }

    static final String getComment(XsdElement element) {
        String comment = Comments.getComment(ProxyHelper.getXsdlTypeQName(element)) + Comments.getComment(element.getAnnotation()) + CodingSegments.NEW_LINE + Comments.getFacetComment(ProxyHelper.getRestriction(element));
        if (comment.trim().equals(CodingSegments.NEW_LINE)) {
            return "";
        }
        return comment.trim();
    }

    static final String getTableComment(XsdElement element) {
        StringBuffer comment = new StringBuffer("List:");
        comment.append(CodingSegments.NEW_LINE);
        comment.append("MinOccurs = ");
        comment.append(element.getMinOccurs());
        comment.append(";");
        comment.append(" ");
        comment.append("MaxOccurs = ");
        int max = element.getMaxOccurs();
        if (max == -1) {
            comment.append("unbounded");
        } else {
            comment.append(max);
        }
        return comment.toString();
    }

    static final String getComment(XsdSimpleType sType) {
        StringBuffer comment = new StringBuffer();
        XsdRestriction facets = sType.getRestriction();
        Comments.getFacetComment(facets);
        return comment.toString();
    }

    static final String getComment(XsdQName type) {
        if (type != null) {
            if (Util.isSchemaNamespace(type.getNamespaceUri())) {
                String local = type.getLocalName();
                if (local == null) {
                    return "";
                }
                return "Value space = Xsdl " + local;
            }
            if (RfcGlobalNameMapping.isRfcDate(type)) {
                return "Value space = Abap Date";
            }
            if (RfcGlobalNameMapping.isRfcTime(type)) {
                return "Value space = Abap Time";
            }
        }
        return "";
    }

    private static String getFacetComment(XsdRestriction restriction) {
        StringBuffer text = new StringBuffer();
        text.append(CodingSegments.NEW_LINE);
        boolean start = true;
        if (restriction != null) {
            text.append("Restrictions:");
            List facets = restriction.getFacets();
            int i = 0;
            while (i < facets.size()) {
                XsdFacet facet = (XsdFacet)facets.get(i);
                if (i != 0) {
                    text.append(", ");
                }
                text.append(ProxyHelper.getString(facet.getFacetName()));
                text.append(" = ");
                text.append(ProxyHelper.getString(facet.getFacetValue()));
                ++i;
            }
        }
        return text.toString();
    }

    private void test() {
        Object an = null;
        List docs = an.getDocumentations();
        Object doc = null;
        List cont = doc.getContent();
    }
}

