/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.ItemMetadata;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdTypeDef;

class AttributeMetadata
extends ItemMetadata
implements ProxyCodingSegments,
JavaTypes {
    private boolean isEnum;
    private String use;

    AttributeMetadata(XsdAttribute attribute, String javaName, String javaType, boolean isEnum) {
        super(attribute.getQName(), javaName, javaType, AttributeMetadata.getXsdType(attribute));
        this.isEnum = isEnum;
        this.init(attribute, attribute);
    }

    AttributeMetadata(XsdAttribute attribute, XsdAttribute referencedFrom, String javaName, String javaType, boolean isEnum) {
        super(attribute.getQName(), javaName, javaType, AttributeMetadata.getXsdType(attribute));
        this.isEnum = isEnum;
        this.init(attribute, referencedFrom);
    }

    private void init(XsdAttribute attribute, XsdAttribute referencedFrom) {
        this.setDefaultValue(attribute.getDefault());
        this.setFixedValue(attribute.getFixed());
        this.setForm(attribute.getForm());
        this.use = referencedFrom.getUse();
        this.setFacets(ProxyHelper.getRestriction(attribute));
    }

    StringBuffer getDescriptorLine(int index) {
        StringBuffer txt = new StringBuffer();
        txt.append("descriptorSetAttributeProperties(");
        txt.append("descriptor").append(", ");
        txt.append(index).append(", ");
        txt.append(ProxyHelper.getString(this.getLocalName())).append(", ");
        txt.append(ProxyHelper.getString(this.getDefaultValue())).append(", ");
        txt.append(ProxyHelper.getString(this.getFixedValue())).append(", ");
        txt.append(ProxyHelper.getString(this.getForm())).append(", ");
        txt.append(ProxyHelper.getString(this.getXsdType())).append(", ");
        txt.append(ProxyHelper.getString(this.getNamespace())).append(", ");
        txt.append(ProxyHelper.getString(this.use)).append(", ");
        txt.append(ProxyHelper.getString(this.getJavaName())).append(", ");
        txt.append(ProxyHelper.writeType(this.getJavaType())).append(", ");
        if (this.isEnum) {
            txt.append("null");
        } else {
            txt.append(ProxyHelper.getNewInstance(this.getJavaType()));
        }
        txt.append(", ");
        txt.append(ProxyHelper.getRestrictions(this.getFacets())).append(")");
        txt.append(CodingSegments.END_LINE);
        return txt;
    }

    boolean isTable() {
        return false;
    }

    String getGetType() {
        return ".getAttribute";
    }

    String getType() {
        return "Attribute";
    }

    boolean isNillable() {
        return this.use.equals("optional");
    }

    private static XsdQName getXsdType(XsdAttribute attribute) {
        XsdQName type = attribute.getGlobalTypeName();
        if (type != null) {
            return type;
        }
        XsdTypeDef def = attribute.getLocalTypeDef();
        if (def != null) {
            return def.getBaseTypeName();
        }
        return null;
    }

    boolean isRfc() {
        return false;
    }

    String getMetadataCast() {
        return "";
    }

    String getMetadataType() {
        return "com.sap.aii.proxy.framework.core.AttributeMetaData";
    }

    String getLineType() {
        return null;
    }
}

