/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.api;

import com.sap.aii.proxy.generation.api.GenerationType;
import com.sap.aii.proxy.generation.api.Info;
import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.api.ProxyGenerator;
import com.sap.aii.proxy.generation.core.JavaGenerator;

public class ProxyGeneratorFactory {
    private static final Info defaultInfo = new Info(new byte[0]);

    private ProxyGeneratorFactory() {
    }

    public static final ProxyGenerator getRfcGenerator(String packageName, boolean isJ2ee) throws ProxyGenerationException {
        return ProxyGeneratorFactory.getRfcGenerator(packageName, isJ2ee, defaultInfo);
    }

    public static final ProxyGenerator getRfcGenerator(String packageName, boolean isJ2ee, Info geninfo) throws ProxyGenerationException {
        if (isJ2ee) {
            return new JavaGenerator(geninfo.classMap, packageName, GenerationType.EJB_1_1);
        }
        return new JavaGenerator(geninfo.classMap, packageName, GenerationType.STANDALONE);
    }

    public static final ProxyGenerator getGenerator(boolean isJ2ee) {
        return ProxyGeneratorFactory.getGenerator(isJ2ee, defaultInfo);
    }

    public static final ProxyGenerator getGenerator(boolean isJ2ee, Info geninfo) {
        if (isJ2ee) {
            return ProxyGeneratorFactory.getGenerator(GenerationType.EJB_1_1, geninfo);
        }
        return ProxyGeneratorFactory.getGenerator(GenerationType.STANDALONE, geninfo);
    }

    public static final ProxyGenerator getGenerator(GenerationType type, Info geninfo) {
        if (type == null) {
            throw new NullPointerException();
        }
        return new JavaGenerator(geninfo.classMap, type);
    }
}

