/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.api;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class ProxyGenerationException
extends Exception {
    private Throwable rootCause;
    private String messageId = null;
    private String resourceBundleName = null;
    private String defaultMessage = null;
    private Object[] args = null;
    private Locale locale;

    protected ProxyGenerationException() {
    }

    public ProxyGenerationException(String resourceBundle, String messageID, Object[] args) {
        this(resourceBundle, messageID);
        this.args = args;
    }

    public ProxyGenerationException(String resourceBundle, String messageId) {
        this.messageId = messageId;
        this.resourceBundleName = resourceBundle;
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle defaultBundle = ResourceBundle.getBundle(this.resourceBundleName, this.getLocale());
                if (defaultBundle != null) {
                    this.defaultMessage = defaultBundle.getString(messageId);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public ProxyGenerationException(String resourceBundle, String messageId, Object[] args, Throwable rootCause) {
        this(resourceBundle, messageId, args);
        this.rootCause = rootCause;
    }

    public ProxyGenerationException(String resourceBundle, String messageId, Throwable rootCause) {
        this(resourceBundle, messageId);
        this.rootCause = rootCause;
    }

    public ProxyGenerationException(MessageId id, Object[] args) {
        this(id.getResourceBundleName(), id.getId(), args);
    }

    public ProxyGenerationException(MessageId id) {
        this(id.getResourceBundleName(), id.getId());
    }

    public ProxyGenerationException(MessageId id, Object[] args, Throwable rootCause) {
        this(id.getResourceBundleName(), id.getId(), args, rootCause);
    }

    public ProxyGenerationException(MessageId id, Throwable rootCause) {
        this(id.getResourceBundleName(), id.getId(), rootCause);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getMessage() {
        return this.getMessage(this.getLocale());
    }

    private String getMessage(Locale locale) {
        ResourceBundle resourceBoundle = ResourceBundle.getBundle(this.resourceBundleName, locale);
        try {
            String message = this.defaultMessage;
            if (resourceBoundle != null) {
                message = resourceBoundle.getString(this.messageId);
            }
            if (message != null) {
                Object[] args = this.getArgs();
                if (args != null) {
                    MessageFormat mf = new MessageFormat("");
                    mf.setLocale(locale);
                    mf.applyPattern(message);
                    return mf.format(args);
                }
                return message;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.messageId;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    private ResourceBundle getRB(Locale locale) {
        ResourceBundle resourceBoundle = null;
        if (this.resourceBundleName != null) {
            try {
                resourceBoundle = ResourceBundle.getBundle(this.resourceBundleName, locale);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return resourceBoundle;
    }

    protected Object[] getArgs() {
        return this.args;
    }

    public static abstract class MessageId {
        private final String id;

        protected MessageId(String id) {
            this.id = id;
        }

        final String getId() {
            return this.id;
        }

        protected abstract String getResourceBundleName();
    }
}

