/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.InflaterInputStream;

public final class Info {
    Mapping mapping = null;
    ClassMap classMap = new ClassMap();

    public Info(byte[] content) {
        this.mapping = new Mapping(content);
    }

    public Info(JarInputStream jar) throws IOException {
        this.classMap = new ClassMap(jar);
    }

    public Info() {
        this.mapping = new Mapping(new byte[0]);
    }

    public byte[] getContent() {
        return this.mapping.getContent();
    }

    public final class ClassMap {
        static final String JAVA = ".java";
        Map classes = new Hashtable();

        private ClassMap() {
        }

        private ClassMap(JarInputStream jar) throws IOException {
            JarEntry entry = jar.getNextJarEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(JAVA)) {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    int n = ((InflaterInputStream)jar).read();
                    while (n != -1) {
                        content.write(n);
                        n = ((InflaterInputStream)jar).read();
                    }
                    content.close();
                    byte[] bytes = content.toByteArray();
                    this.classes.put(this.getJavaName(name), new String(bytes));
                }
                entry = jar.getNextJarEntry();
            }
        }

        private String getJavaName(String name) {
            return name.replace('\\', '.').replace('/', '.').substring(0, name.length() - JAVA.length());
        }

        public String get(String javaName) {
            return (String)this.classes.get(javaName);
        }
    }

    public final class Mapping {
        byte[] content;

        private Mapping(byte[] content) {
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

