/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.veloant;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.ConfigReader;
import com.sap.tc.buildplugin.util.Descriptors;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    DirsAndFiles daf;
    FileCreator fCreator;
    String buildFileName;
    String method;
    List wsPPSources = new ArrayList();
    List wsPPClasses = new ArrayList();
    int br = 0;
    String errMsg = "";
    int currentStep;
    private IBuildInfo buildInfo;
    Descriptors descriptors = new Descriptors();
    List externalCompPP = new ArrayList();
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$veloant$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$veloant$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.veloant.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$veloant$CreateBuildFileAction));
    JlinUtils jlinUtils;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$veloant$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        this.setVelocityContext();
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    private void setVelocityContext() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> AntPropsDependJars = new ArrayList<String>();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        this.fCreator.setStrContext("dc_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_caption", this.daf.getDCCaption());
        this.fCreator.setStrContext("dc_type", this.daf.getDCType());
        this.fCreator.setStrContext("dc_subtype", this.daf.getDcSubtype());
        this.fCreator.setListContext("dc_properties", this.daf.getDCProperties());
        this.fCreator.setStrContext("dc_src_Dir", this.daf.getSrcDir());
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        List dependDirs = this.daf.getDependDirs();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                AntPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        AntPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        this.fCreator.setListContext("dc_depend_compileArchives", AntPropsDependJars);
        List packageDirs = this.daf.getPackageDirs();
        this.fCreator.setListContext("dc_packageDirs", packageDirs);
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
        this.fCreator.setListContext("dc_sourceDirs", this.daf.getSourceDirs());
        this.fCreator.setStrContext("dc_deploy_Dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deploy_File", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_variantDir", this.daf.getGenVariantDir());
        this.fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.jlinUtils.insertJlinContext(this.fCreator);
        String dcType = this.daf.getDCType();
        List compDep = this.daf.getDependencies();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                String name = dep.getComponent().getName();
                String vendor = dep.getComponent().getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                if (type == null) {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", ""));
                } else {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType()));
                }
                boolean isAtBuildTimeDep = dep.isAtBuildTime();
                if (!isAtBuildTimeDep || dc == null) continue;
                boolean isCurrentDepDCExternal = dc.isExternal();
                String currentDepDcType = dc.getComponentType().getType();
                boolean isCurrentDepDCJava = currentDepDcType.equalsIgnoreCase("Java");
                if (!isCurrentDepDCExternal || !isCurrentDepDCJava) continue;
                this.externalCompPP = this.collectExternalCompPP(dep);
            }
        }
        this.fCreator.setListContext("dc_jarSap_dep", allDep);
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        this.fCreator.setListContext("dc_depend_externalCompileDirs", this.externalCompPP);
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_ass_dep", assDep);
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
            String mfName = this.daf.getTempDir() + File.separator + "Manifest.mf";
            this.daf.createManifestFile(mfName);
            this.fCreator.setStrContext("bi_manifest_Name", mfName);
            Iterator it = ppMap.keySet().iterator();
            while (it.hasNext()) {
                PublicPart ppart = (PublicPart)ppMap.get(it.next());
                List entities = ppart.getEntities();
                if (entities == null) continue;
                int i = 0;
                while (i < entities.size()) {
                    Entity currentEntity = (Entity)entities.get(i);
                    String type = currentEntity.getType();
                    if (type.equalsIgnoreCase("Web Service Definition")) {
                        this.collectEntitiesWsdef(currentEntity);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setStrContext("ws_descriptor_file", "true");
        String wsDDFileName = this.daf.getRootDir() + "META-INF" + File.separator + "ws-deployment-descriptor.xml";
        File wsDDFile = new File(wsDDFileName);
        if (!wsDDFile.exists()) {
            this.loc.infoT("deployment descriptor does not exist - no ear will be generated");
            this.fCreator.setStrContext("ws_descriptor_file", "false");
        } else {
            String tempMetaInf = this.daf.getTempDir() + File.separator + "META-INF";
            File tempMetaInfDir = new File(tempMetaInf);
            if (!tempMetaInfDir.exists()) {
                tempMetaInfDir.mkdirs();
            }
            String appXmlFile = tempMetaInf + File.separator + "application.xml";
            String appJ2eeXmlFile = tempMetaInf + File.separator + "application-j2ee-engine.xml";
            String dcName = this.daf.getDcFile();
            String dcVendor = this.daf.getDCVendor();
            String sdaXmlFile = tempMetaInf + File.separator + "sda-dd.xml";
            this.fCreator.setStrContext("sda_descriptor_file", sdaXmlFile);
            try {
                this.descriptors.genApplicationXml(appXmlFile, dcName);
                this.descriptors.genApplicationJ2EEngineXml(appJ2eeXmlFile, dcName, dcVendor);
                this.descriptors.genSdaXml(sdaXmlFile);
            }
            catch (IOException io) {
                String msg = "error generating the descriptors";
                this.loc.traceThrowableT(500, msg, (Throwable)io);
                this.br = 2;
            }
        }
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        String cfgFileName = "cfg" + File.separator + "generate.properties";
        File cfgFile = new File(this.daf.getRootDir() + File.separator + cfgFileName);
        if (cfgFile.exists()) {
            this.loc.infoT("generation property file found, activate MDR handling");
            ConfigReader cr = new ConfigReader();
            cr.setFileName(this.daf.getRootDir() + File.separator + cfgFileName);
            String className = cr.getPropertyValue("classnameoftask");
            if (className.length() != 0) {
                this.fCreator.setStrContext("mdrgen_activate", "true");
                this.fCreator.setStrContext("mdrgen_classnameoftask", className);
            } else {
                this.loc.infoT("generate.properties: No value for 'classnameoftask' found");
            }
        } else {
            this.loc.infoT("no generation property file found, default handling");
        }
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    private void collectEntitiesWsdef(Entity entity) {
        String pack = entity.getPackageName();
        String name = entity.getName();
        String wsName = "";
        if (pack != null) {
            wsName = pack.replace('/', File.separatorChar) + File.separator + name + ".wsdef";
        } else {
            pack = "";
            wsName = name + ".wsdef";
        }
        this.wsPPSources.add(wsName);
        String packName = pack.replace('/', '.');
        String ppFileName = "wspp.properties";
        Properties ppProps = new Properties();
        File ppFile = new File(this.daf.getRootDir() + File.separator + "cfg" + File.separator + ppFileName);
        if (!ppFile.exists()) {
            this.loc.infoT("wspp.properties file doesn't exist - can not include the needed entities for Web Service Definition in pp");
        } else {
            try {
                FileInputStream in = new FileInputStream(ppFile);
                ppProps.load(in);
                in.close();
                Enumeration<?> keys = ppProps.propertyNames();
                while (keys.hasMoreElements()) {
                    String fileName;
                    String key = (String)keys.nextElement();
                    String value = ppProps.getProperty(key);
                    String keyStart = "";
                    keyStart = packName != "" ? packName + "." + name : name;
                    if (key.startsWith(keyStart + ".VI")) {
                        String vi = "";
                        if (value.substring(0, value.lastIndexOf(".")).indexOf(".") != -1) {
                            value = value.substring(0, value.lastIndexOf("."));
                            String packVI = value.substring(0, value.lastIndexOf("."));
                            fileName = value.substring(value.lastIndexOf(".") + 1, value.length());
                            vi = packVI.replace('.', File.separatorChar) + File.separator + fileName + ".videf";
                        } else {
                            vi = value;
                        }
                        this.wsPPSources.add(vi);
                        continue;
                    }
                    if (!key.startsWith(keyStart + ".JAVA_CLASS")) continue;
                    String clas = "";
                    if (value.substring(0, value.lastIndexOf(".")).indexOf(".") != -1) {
                        value = value.substring(0, value.lastIndexOf("."));
                        String packClass = value.substring(0, value.lastIndexOf("."));
                        fileName = value.substring(value.lastIndexOf(".") + 1, value.length());
                        clas = packClass.replace('.', File.separatorChar) + File.separator + fileName;
                    } else {
                        clas = value.substring(0, value.lastIndexOf("."));
                    }
                    this.wsPPClasses.add(clas);
                }
                this.fCreator.setListContext("dc_ws_pp_sources", this.wsPPSources);
                this.fCreator.setListContext("dc_ws_pp_classes", this.wsPPClasses);
            }
            catch (FileNotFoundException fnf) {
                String msg = "wspp.properties file doesn't exist - can not include the needed entities for Web Service Definition in pp";
                this.loc.traceThrowableT(500, msg, (Throwable)fnf);
                this.br = 2;
            }
            catch (IOException ioe) {
                String msg = "problem occurred while reading wspp.properties file";
                this.loc.traceThrowableT(500, msg, (Throwable)ioe);
            }
        }
    }

    protected static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String time = "";
        long test = minutes % 60L;
        if (hours > 0L) {
            time = hours < 10L ? "0" + Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "") : Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "");
        } else if (minutes > 0L) {
            time = "00:" + Long.toString(minutes % 60L);
        }
        return time;
    }

    private List collectExternalCompPP(Dependency dep) {
        DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
        DCReference dcRef = dep.getComponent();
        Map pps = dc.getPublicParts();
        Iterator iter = pps.values().iterator();
        boolean isAssPPAvailable = false;
        while (iter.hasNext()) {
            PublicPart currentPp = (PublicPart)iter.next();
            if (currentPp != null && currentPp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY)) {
                isAssPPAvailable = true;
                break;
            }
            PPReference ppRef = dep.getPublicPartDependency();
            if (pps == null) continue;
            if (ppRef != null && ppRef.getName() != null) {
                PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                if (pp != null && pp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY) || pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
                continue;
            }
            pps = dc.getPublicParts();
            Iterator ppiter = pps.values().iterator();
            while (ppiter.hasNext()) {
                PublicPart pp = (PublicPart)ppiter.next();
                ppRef = new PPReference(pp.getName(), dcRef);
                if (pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                ppRef = new PPReference(pp.getName(), dcRef);
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
            }
        }
        return this.externalCompPP;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

