/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.GenerationBase;
import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.configuration.method.IMethod;
import com.sap.ide.generationfwk.configuration.template.ITemplate;
import com.sap.ide.generationfwk.velocity.compiler.VelocityCompiler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VelocityCompilerMain
extends GenerationBase {
    private String configFilename = null;
    private List templates = new ArrayList();
    private boolean compileAllTemplates = false;
    private boolean writeUpdatedConfigFile = false;
    private VelocityCompiler compiler = new VelocityCompiler();

    private VelocityCompilerMain() {
        super(1, "WebDynproGenerationConfiguration.xml");
    }

    public final void printMessage(int category, String messageText) {
        switch (category) {
            case 1: {
                System.out.println("Info: " + messageText);
                break;
            }
            case 3: {
                System.out.println("Warning: " + messageText);
                break;
            }
            case 2: {
                System.out.println("Error: " + messageText);
                break;
            }
            default: {
                System.out.println(messageText);
            }
        }
    }

    private void usage(String errorMsg) {
        if (errorMsg != null) {
            System.err.println();
            System.err.println("**** error: " + errorMsg);
        }
        System.err.println();
        System.err.println("usage:");
        System.err.println(" VelocityCompilerMain [-help] [-package <package>] [-d <dir>] [-varinfo <file> | -varinfo_resource <name>] [-cfgfile <file> | -cfgresource <name>] [-writecfg] -all | (<template id> [<template id> ...])");
        System.err.println();
        System.err.println(" -help                      prints this message");
        System.err.println(" -package <package>         specifies a root package for the compiled template classes");
        System.err.println(" -d <dir>                   directory to generated the sources to");
        System.err.println(" -varinfo <file>            file that contains type information for variables");
        System.err.println(" -varinfo_resource <name>   resource name of file that contains type info for variables");
        System.err.println(" -cfgfile <file>            path of generation configuration file");
        System.err.println(" -cfgresource <name>        resource name of generation configuration");
        System.err.println(" -writecfg                  write updated config file with method entries for all converted templates");
        System.err.println(" -all                       compile all templates found in the configuration");
        System.err.println();
        System.err.println("samples:");
        System.err.println(" VelocityCompilerMain -d java -varinfo variables.properties -all");
        System.err.println();
        System.exit(errorMsg == null ? 0 : 1);
    }

    private String getFilenameFromResource(String resourceName) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        return url == null ? null : url.toExternalForm();
    }

    private void execute(String[] args) throws Exception {
        Iterator templateIt;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-help")) {
                this.usage(null);
            } else if (args[i].equalsIgnoreCase("-package")) {
                if (i + 1 < args.length) {
                    String rootPackage;
                    if ((rootPackage = args[++i]).endsWith(".")) {
                        rootPackage = rootPackage.substring(0, rootPackage.length() - 1);
                    }
                    this.compiler.setRootPackage(rootPackage);
                } else {
                    this.usage("missing path argument for option -package");
                }
            } else if (args[i].equalsIgnoreCase("-d")) {
                if (i + 1 < args.length) {
                    File destination;
                    if ((destination = new File(args[++i])).exists() && !destination.isDirectory()) {
                        this.usage("destination exists, but is not a directory");
                    }
                    this.compiler.setDestination(destination);
                } else {
                    this.usage("missing path argument for option -d");
                }
            } else if (args[i].equalsIgnoreCase("-varinfo")) {
                if (i + 1 < args.length) {
                    File varInfoFile;
                    if (!(varInfoFile = new File(args[++i])).exists()) {
                        this.usage("var info file doesn't exist");
                    }
                    this.compiler.setVarInfoFile(varInfoFile);
                } else {
                    this.usage("missing file argument for option -varinfo");
                }
            } else if (args[i].equalsIgnoreCase("-varinfo_resource")) {
                if (i + 1 < args.length) {
                    String varInfoResource = args[++i];
                    this.compiler.setVarInfoResource(varInfoResource);
                } else {
                    this.usage("missing file argument for option -varinfo_resource");
                }
            } else if (args[i].equalsIgnoreCase("-cfgfile")) {
                if (i + 1 < args.length) {
                    File configFile;
                    if (!(configFile = new File(args[++i])).exists()) {
                        this.usage("config file doesn't exist");
                    }
                    this.configFilename = configFile.getPath();
                } else {
                    this.usage("missing file argument for option -cfgfile");
                }
            } else if (args[i].equalsIgnoreCase("-cfgresource")) {
                if (i + 1 < args.length) {
                    this.configFilename = this.getFilenameFromResource(args[++i]);
                    if (this.configFilename == null) {
                        this.usage("config resource doesn't exist");
                    }
                } else {
                    this.usage("missing file argument for option -cfgresource");
                }
            } else if (args[i].equalsIgnoreCase("-writecfg")) {
                this.writeUpdatedConfigFile = true;
            } else if (args[i].equals("-all")) {
                if (!this.templates.isEmpty()) {
                    this.usage("use '-all' xor <file>, not both");
                }
                this.compileAllTemplates = true;
            } else if (args[i].startsWith("-")) {
                this.usage("unsupported option " + args[i]);
            } else {
                if (this.compileAllTemplates) {
                    this.usage("use '-all' xor <file>, not both");
                }
                this.templates.add(args[i]);
            }
            ++i;
        }
        if (this.templates.size() == 0 && !this.compileAllTemplates) {
            this.usage("nothing to do: no templates specified");
        }
        if (this.configFilename != null) {
            this.getGenerationConfiguration().setConfigurationFile(this.configFilename);
        }
        this.getGenerationConfiguration().refresh();
        if (this.compileAllTemplates) {
            templateIt = ((AbstractList)this.getGenerationConfiguration().getGenerationUnits()).iterator();
        } else {
            ArrayList<IGenerationUnit> templateInfos = new ArrayList<IGenerationUnit>();
            Iterator it = this.templates.iterator();
            while (it.hasNext()) {
                String templateId = (String)it.next();
                IGenerationUnit template = this.getGenerationConfiguration().getGenerationUnit(templateId);
                if (template != null) {
                    templateInfos.add(template);
                    continue;
                }
                System.err.println("**** error: didn't find template with id '" + templateId + "'");
            }
            templateIt = templateInfos.iterator();
        }
        HashMap<String, String> entries = new HashMap<String, String>();
        while (templateIt.hasNext()) {
            IGenerationUnit gu = (IGenerationUnit)templateIt.next();
            if (!(gu instanceof ITemplate)) continue;
            String entry = this.compiler.compile((ITemplate)gu);
            entries.put(gu.getId(), entry);
        }
        if (this.writeUpdatedConfigFile && !entries.isEmpty()) {
            this.writeConfigurationFile(entries);
        }
    }

    private void writeConfigurationFile(Map entries) throws IOException {
        File cfgFile = new File(this.compiler.getDestination(), "WebDynproGenerationConfiguration.xml");
        System.out.println("write updated configuration to '" + cfgFile.getPath() + "'");
        PrintWriter out = new PrintWriter(new FileWriter(cfgFile));
        this.writeConfiguration(out, entries);
        out.flush();
        out.close();
    }

    private void writeConfiguration(PrintWriter out, Map entries) {
        IGenerationUnit gu;
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE generationConfiguration SYSTEM \".\\GenerationConfiguration.dtd\">");
        out.println("<generationConfiguration id=\"" + this.getGenerationConfiguration().getId() + "\">");
        out.println("  <templateConfiguration>");
        out.println("    <templates>");
        Iterator templateIt = ((AbstractList)this.getGenerationConfiguration().getGenerationUnits()).iterator();
        while (templateIt.hasNext()) {
            gu = (IGenerationUnit)templateIt.next();
            if (entries.containsKey(gu.getId()) || !(gu instanceof ITemplate)) continue;
            ITemplate template = (ITemplate)gu;
            out.println("      <template id=\"" + template.getId() + "\" templateHelperClass=\"" + template.getTemplateHelperClassName() + "\" source=\"" + template.getSourceType() + "\" templateEncoding=\"" + template.getTemplateEncoding() + "\" outputEncoding=\"" + template.getOutputEncoding() + "\">" + template.getFileName() + "</template>");
        }
        out.println("    </templates>");
        out.println("  </templateConfiguration>");
        out.println("  <methodConfiguration>");
        out.println("    <methods>");
        templateIt = ((AbstractList)this.getGenerationConfiguration().getGenerationUnits()).iterator();
        while (templateIt.hasNext()) {
            gu = (IGenerationUnit)templateIt.next();
            if (entries.containsKey(gu.getId())) {
                out.println((String)entries.get(gu.getId()));
                continue;
            }
            if (!(gu instanceof IMethod)) continue;
            IMethod method = (IMethod)gu;
            out.println("      <method id=\"" + method.getId() + "\" generationClass=\"" + method.getMethodClassName() + "\" static=\"" + method.isStatic() + "\" outputEncoding=\"" + method.getOutputEncoding() + "\">" + method.getMethodName() + "</method>");
        }
        out.println("    </methods>");
        out.println("  </methodConfiguration>");
        out.println("</generationConfiguration>");
    }

    public static void main(String[] args) {
        VelocityCompilerMain compiler = new VelocityCompilerMain();
        try {
            compiler.execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

