/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.configuration.template.ITemplate;
import com.sap.ide.generationfwk.velocity.compiler.AbstractVisitor;
import com.sap.ide.generationfwk.velocity.compiler.CompilationVisitor;
import com.sap.ide.generationfwk.velocity.compiler.Context;
import com.sap.ide.generationfwk.velocity.compiler.IndentationPrintWriter;
import com.sap.ide.generationfwk.velocity.compiler.LiteralDef;
import com.sap.ide.generationfwk.velocity.compiler.MacroCollector;
import com.sap.ide.generationfwk.velocity.compiler.StringUtil;
import com.sap.ide.generationfwk.velocity.compiler.VTLVariableInfo;
import com.sap.ide.generationfwk.velocity.compiler.VariableCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.ASTComment;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTprocess;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class VelocityCompiler {
    public static final boolean USE_CHECK_FOR_BOOLEAN_CONDITIONS = false;
    public static final boolean GENERATE_CODE_COVERAGE_TESTS = false;
    public static final String DEFAULT_TYPE_FOR_UNDECLARED_VARS = "java.lang.String";
    public static final String VAR_NAME_PREFIX = "_";
    public static final String MACRO_NAME_PREFIX = "vm_";
    public static final String LITERAL_EVAL_METHOD_PREFIX = "l";
    public static final String PRINT_PREFIX = "print(";
    public static final String PRINT_SUFFIX = ")";
    public static final String PRINTLN_PREFIX = "print(";
    public static final String PRINTLN_SUFFIX = ");nl()";
    public static final String NEWLINE = "nl()";
    public static final boolean TRY_TO_MINIMIZE_NEWLINES = true;
    private File destination = new File(".");
    private File varInfoFile = null;
    private Properties varInfos = new Properties();
    private String rootPackage = "";
    private RuntimeInstance ri = new RuntimeInstance();
    private final MacroCollector macroCollector;
    private final VariableCollector varCollector;
    private CompilationVisitor cv;
    private IndentationPrintWriter out;
    private List branches = new ArrayList();
    private List literals = new ArrayList();
    private Map macros = new HashMap();
    private String templateName;

    public static final void check(boolean cond, String descr) {
        if (!cond) {
            throw new RuntimeException("assertion failed: " + descr);
        }
    }

    public VelocityCompiler() {
        this.macroCollector = new MacroCollector(this);
        this.varCollector = new VariableCollector(this);
        this.cv = new CompilationVisitor(this);
    }

    private void reset() {
        this.branches.clear();
        this.literals.clear();
        this.macros.clear();
        this.templateName = null;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setVarInfoResource(String resource) {
        try {
            if (resource != null) {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(resource);
                this.varInfos.load(in);
            }
        }
        catch (Exception e) {
            System.err.println("failed to load varinfo resource '" + resource + "'");
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setVarInfoFile(File varInfoFile) {
        this.varInfoFile = varInfoFile;
        try {
            if (varInfoFile != null) {
                this.varInfos.load(new FileInputStream(varInfoFile));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setRootPackage(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    public SimpleNode parse(String templateName) {
        try {
            Template velocityTemplate = this.ri.getTemplate(templateName);
            SimpleNode root = (SimpleNode)velocityTemplate.getData();
            return root;
        }
        catch (Exception e) {
            System.err.println("error while parsing template '" + templateName + "':");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public SimpleNode parse(String text, String templateName) {
        try {
            StringReader in = new StringReader(text);
            return this.ri.parse((Reader)in, templateName);
        }
        catch (ParseException e) {
            System.err.println("error while parsing template string '" + templateName + "':");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public String compile(ITemplate template) throws Exception {
        this.reset();
        System.out.println(template.getId() + ":");
        System.out.println("  " + template.getTemplateHelperClassName());
        System.out.println("  " + template.getPath());
        this.templateName = template.getFileName();
        if (this.templateName.lastIndexOf(46) >= 0) {
            this.templateName = this.templateName.substring(0, this.templateName.lastIndexOf(46));
        }
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "file, class");
        properties.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        properties.setProperty("file.resource.loader.path", template.getFilePath());
        properties.setProperty("file.resource.loader.cache", "true");
        properties.setProperty("file.resource.loader.modificationCheckInterval", "0");
        properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        properties.setProperty("velocimacro.context.localscope", "true");
        properties.setProperty("directive.foreach.counter.initial.value", "0");
        properties.setProperty("ISO-8859-1", "UTF-8");
        properties.setProperty("input.encoding", template.getTemplateEncoding());
        properties.setProperty("output.encoding", template.getOutputEncoding());
        this.ri.init(properties);
        String qualifiedTemplateName = StringUtil.isEmpty(this.rootPackage) ? this.templateName : this.rootPackage + "." + this.templateName;
        File outFile = new File(this.destination, qualifiedTemplateName.replace('.', '/') + ".java");
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new RuntimeException("failed to create dir " + outFile.getParent());
        }
        this.out = new IndentationPrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        SimpleNode root = this.parse(template.getFileName());
        this.generateTemplate(this.rootPackage, (ASTprocess)root, template.getTemplateHelperClassName());
        this.out.close();
        return "<method id=\"" + template.getId() + "\"" + " generationClass=\"" + qualifiedTemplateName + "\"" + " static=\"false\"" + " outputEncoding=\"" + template.getOutputEncoding() + "\"" + ">" + "generate" + "</method>";
    }

    private void generateTemplate(String packageName, ASTprocess rootNode, String templateHelperClassName) {
        VTLVariableInfo var;
        this.macros = (Map)this.macroCollector.visit(rootNode, new HashMap());
        Context context = new Context(this, "", this.varInfos);
        if (!StringUtil.isEmpty(packageName)) {
            this.out.println("package " + packageName + ";");
            this.out.println();
        }
        this.out.println("import com.sap.ide.generationfwk.velocity.runtime.*;");
        this.out.println("import java.io.IOException;");
        this.out.println("import java.util.Iterator;");
        this.out.println("import java.util.Map;");
        this.out.println();
        ASTComment docComment = this.findDocComment((SimpleNode)rootNode);
        if (docComment != null) {
            this.dumpComment(docComment.literal());
        }
        this.out.println("public class " + this.templateName + " extends CompiledTemplateBase {");
        this.out.indent();
        this.out.println();
        this.out.println("public " + this.templateName + "() {");
        this.out.indent();
        this.out.println("super();");
        this.out.unindent();
        this.out.println("}");
        this.out.println();
        if (!StringUtil.isEmpty(templateHelperClassName)) {
            this.out.println("protected Object doCreateTemplateHelper() {");
            this.out.indent();
            this.out.println("return new " + templateHelperClassName + "();");
            this.out.unindent();
            this.out.println("}");
        }
        this.out.println("protected void doGenerate(Map rootContext) throws IOException {");
        this.out.indent();
        this.varCollector.visit(rootNode, (Object)context);
        Iterator<Object> it = context.iterateVariables();
        while (it.hasNext()) {
            var = (VTLVariableInfo)it.next();
            if (this.isBuiltIn(var)) continue;
            this.out.print(var.getType() + " " + this.makeVarFromIdentifier(var.getName()));
            if (var.getType().indexOf(46) >= 0) {
                this.out.print(" = null");
            }
            this.out.println(";");
        }
        this.out.println();
        this.out.println("// extract template parameters from context");
        it = context.iterateVariables();
        while (it.hasNext()) {
            var = (VTLVariableInfo)it.next();
            if (!var.isParameter()) continue;
            this.out.print(this.makeVarFromIdentifier(var.getName()));
            this.out.println(" = (" + var.getType() + ") rootContext.get(\"" + var.getName() + "\");");
        }
        this.out.println();
        this.addBranch("main");
        this.cv.generate((SimpleNode)rootNode, this.out, context);
        this.out.ensureNewLine();
        this.out.unindent();
        this.out.println("}");
        this.out.println();
        it = this.macros.keySet().iterator();
        while (it.hasNext()) {
            String macroName = (String)it.next();
            ASTDirective macro = (ASTDirective)this.macros.get(macroName);
            SimpleNode reparsedMacro = this.parse(macro.literal(), macroName);
            this.generateMacro((ASTDirective)reparsedMacro.jjtGetChild(0), macro);
        }
        if (!this.literals.isEmpty()) {
            this.out.println("private static class Literals extends CompiledTemplateBase.Literals {");
            this.out.indent();
            this.out.println();
            it = this.literals.iterator();
            while (it.hasNext()) {
                this.generateLiteralEvaluationFunction((LiteralDef)it.next());
            }
            this.out.unindent();
            this.out.println("}");
            this.out.println();
            this.out.println("private Literals literals = new Literals();");
            this.out.println();
        }
        this.out.unindent();
        this.out.println("}");
        this.out.println();
    }

    private void generateMacro(ASTDirective rootNode, ASTDirective originalNode) {
        String macroName = rootNode.jjtGetChild(0).literal();
        Context context = new Context(this, macroName, this.varInfos);
        ASTComment docComment = this.findDocComment((SimpleNode)originalNode);
        if (docComment != null) {
            this.dumpComment(docComment.literal());
        }
        this.out.print("void vm_" + macroName + "(");
        int i = 1;
        while (i < rootNode.jjtGetNumChildren() - 1) {
            String paramName = AbstractVisitor.getContextKeyFromReference((ASTReference)rootNode.jjtGetChild(i));
            context.addParameter(paramName);
            if (i > 1) {
                this.out.print(", ");
            }
            this.out.print(context.getType(paramName) + " " + this.makeVarFromIdentifier(paramName));
            ++i;
        }
        this.out.println(") throws IOException {");
        this.out.indent();
        this.varCollector.visit((ASTBlock)rootNode.jjtGetChild(rootNode.jjtGetNumChildren() - 1), (Object)context);
        Iterator it = context.iterateVariables();
        while (it.hasNext()) {
            VTLVariableInfo var = (VTLVariableInfo)it.next();
            if (this.isBuiltIn(var) || !var.isVariable()) continue;
            this.out.print(var.getType() + " " + this.makeVarFromIdentifier(var.getName()));
            if (var.getType().indexOf(46) >= 0) {
                this.out.print(" = null");
            }
            this.out.println(";");
        }
        this.out.println();
        this.addBranch(MACRO_NAME_PREFIX + macroName);
        SimpleNode macroBody = (SimpleNode)rootNode.jjtGetChild(rootNode.jjtGetNumChildren() - 1);
        this.cv.generate(macroBody, this.out, context);
        this.out.ensureNewLine();
        this.out.unindent();
        this.out.println("}");
        this.out.println();
    }

    private void generateLiteralEvaluationFunction(LiteralDef literalDef) {
        String methodName = this.registerLiteralDef(literalDef);
        this.out.print("private String " + methodName + "(");
        int j = 0;
        while (j < literalDef.getParameterCount()) {
            if (j > 0) {
                this.out.print(", ");
            }
            this.out.print(literalDef.getParameterInfo(j).getType() + " " + this.makeVarFromIdentifier(literalDef.getParameterInfo(j).getName()));
            ++j;
        }
        this.out.println(") {");
        this.out.indent();
        this.out.println("// \"" + literalDef.getLiteral() + "\"");
        this.out.println("clear();");
        SimpleNode literalNode = this.parse(literalDef.getLiteral(), methodName);
        Context tmpCtx = new Context(this, methodName, this.varInfos);
        int j2 = 0;
        while (j2 < literalDef.getParameterCount()) {
            tmpCtx.addVar(literalDef.getParameterInfo(j2));
            ++j2;
        }
        this.cv.generate(literalNode, this.out, tmpCtx);
        this.out.ensureNewLine();
        this.out.println("return toString();");
        this.out.unindent();
        this.out.println("}");
        this.out.println();
    }

    String makeVarFromIdentifier(String identifier) {
        return VAR_NAME_PREFIX + identifier;
    }

    public void dumpChildren(SimpleNode node) {
        this.out.println("// " + node.toString() + " has " + node.jjtGetNumChildren() + " children");
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            this.out.println("//  [" + i + "]" + node.jjtGetChild(i) + "<" + node.jjtGetChild(i).literal() + ">");
            ++i;
        }
        this.out.println("//");
    }

    void dumpComment(String comment) {
        String[] lines = StringUtil.splitLines(comment);
        if (lines.length > 0) {
            int p = lines[0].indexOf("#*");
            if (p >= 0) {
                lines[0] = lines[0].substring(0, p) + "/*" + lines[0].substring(p + 2);
            }
            if ((p = lines[lines.length - 1].indexOf("*#")) >= 0) {
                lines[lines.length - 1] = lines[lines.length - 1].substring(0, p) + "*/" + lines[lines.length - 1].substring(p + 2);
            }
        }
        int i = 0;
        while (i < lines.length) {
            this.out.println(lines[i]);
            ++i;
        }
    }

    void addBranch(String namePrefix) {
    }

    ASTComment findDocComment(SimpleNode rootNode) {
        String comment;
        if (rootNode.jjtGetParent() == null) {
            String comment2;
            int i = 0;
            while (i < rootNode.jjtGetNumChildren()) {
                if (!(rootNode.jjtGetChild(i) instanceof ASTComment) || !(comment2 = rootNode.jjtGetChild(i).literal()).startsWith("##") || !StringUtil.isEmpty(comment2.substring("##".length()).trim())) break;
                ++i;
            }
            if (i >= rootNode.jjtGetNumChildren()) {
                return null;
            }
            if (!(rootNode.jjtGetChild(i) instanceof ASTComment)) {
                return null;
            }
            comment2 = rootNode.jjtGetChild(i).literal();
            if (!comment2.startsWith("#**")) {
                return null;
            }
            return (ASTComment)rootNode.jjtGetChild(i);
        }
        SimpleNode node = (SimpleNode)rootNode.jjtGetParent();
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (node.jjtGetChild(i) == rootNode) break;
            ++i;
        }
        while (--i >= 0) {
            if (!(node.jjtGetChild(i) instanceof ASTComment) || !(comment = node.jjtGetChild(i).literal()).startsWith("##") || !StringUtil.isEmpty(comment.substring("##".length()).trim())) break;
        }
        if (i < 0) {
            return null;
        }
        if (!(node.jjtGetChild(i) instanceof ASTComment)) {
            return null;
        }
        comment = node.jjtGetChild(i).literal();
        if (!comment.startsWith("#**")) {
            return null;
        }
        return (ASTComment)node.jjtGetChild(i);
    }

    public String registerLiteralDef(LiteralDef def) {
        if (!this.literals.contains(def)) {
            this.literals.add(def);
        }
        int index = this.literals.indexOf(def);
        return LITERAL_EVAL_METHOD_PREFIX + index;
    }

    public boolean isMacroName(String id) {
        return this.macros.containsKey(id);
    }

    private boolean isBuiltIn(VTLVariableInfo var) {
        return "velocityCount".equals(var.getName());
    }

    public String getTypeInfo(String contextName, String varName) {
        String varKey;
        String type = null;
        if (!StringUtil.isEmpty(contextName) && ((Hashtable)this.varInfos).containsKey(varKey = "varinfo." + this.templateName + "." + contextName + "." + varName)) {
            type = this.varInfos.getProperty(varKey);
        }
        if (type == null && ((Hashtable)this.varInfos).containsKey(varKey = "varinfo." + this.templateName + "." + varName)) {
            type = this.varInfos.getProperty(varKey);
        }
        if (type == null && ((Hashtable)this.varInfos).containsKey(varKey = "varinfo." + varName)) {
            type = this.varInfos.getProperty(varKey);
        }
        if (type == null) {
            type = DEFAULT_TYPE_FOR_UNDECLARED_VARS;
        }
        if (type == null) {
            throw new RuntimeException("can't determine type for var " + varName);
        }
        return type;
    }
}

