/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.velocity.compiler.AbstractVisitor;
import com.sap.ide.generationfwk.velocity.compiler.Context;
import com.sap.ide.generationfwk.velocity.compiler.StringUtil;
import com.sap.ide.generationfwk.velocity.compiler.VelocityCompiler;
import org.apache.velocity.runtime.parser.node.ASTAssignment;
import org.apache.velocity.runtime.parser.node.ASTComment;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.SimpleNode;

class VariableCollector
extends AbstractVisitor {
    VariableCollector(VelocityCompiler vc) {
        super(vc, true);
    }

    public Object visit(ASTComment node, Object data) {
        Context context = (Context)data;
        String comment = node.literal();
        if (comment.startsWith("##")) {
            this.analyzeCommentLine(comment.substring(2), context);
        } else {
            String[] lines = StringUtil.splitLines(comment);
            int i = 0;
            while (i < lines.length) {
                this.analyzeCommentLine(lines[i], context);
                ++i;
            }
        }
        return this.defaultVisit((SimpleNode)node, data);
    }

    private void declareVariables(Context context, String varNameList, String types) {
        String[] varNames = StringUtil.divide(varNameList, ',');
        int i = 0;
        while (i < varNames.length) {
            context.addVar(varNames[i], types);
            ++i;
        }
    }

    private boolean startsWithWord(String str, String word, int p) {
        return str.startsWith(word, p) && (p + word.length() == str.length() || Character.isWhitespace(str.charAt(p + word.length())));
    }

    private void analyzeCommentLine(String line, Context context) {
        int len = line.length();
        int p = 0;
        int start = 0;
        while ((p = line.indexOf(35, p)) >= 0) {
            if (this.startsWithWord(line, "#uses", p)) {
                p += "#uses".length();
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                start = p;
                while (p < len && !Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                String typeImport = line.substring(start, p).trim();
                context.addTypeImport(typeImport);
                continue;
            }
            if (this.startsWithWord(line, "#param", p)) {
                p += "#param".length();
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                start = p;
                while (p < len && !Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                String name = line.substring(start, p);
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                start = p;
                while (p < len && !Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                String type = line.substring(start, p);
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                context.addParameter(name, type);
                continue;
            }
            if (this.startsWithWord(line, "#varinfo", p)) {
                p += "#varinfo".length();
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                start = p;
                while (p < len && !Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                String varnames = line.substring(start, p);
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                start = p;
                while (p < len && !Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                String types = line.substring(start, p);
                while (p < len && Character.isWhitespace(line.charAt(p))) {
                    ++p;
                }
                this.declareVariables(context, varnames, types);
                continue;
            }
            ++p;
        }
    }

    public Object visit(ASTAssignment node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetChild(0).jjtGetNumChildren() == 0) {
            String varName = AbstractVisitor.getContextKeyFromReference((ASTReference)node.jjtGetChild(0));
            context.addVar(varName);
        }
        return this.defaultVisit((SimpleNode)node, data);
    }

    public Object visitMacroDirective(ASTDirective node, Object data) {
        return data;
    }

    public Object visitForEachDirective(ASTDirective node, Object data) {
        Context context = (Context)data;
        String varName = AbstractVisitor.getContextKeyFromReference((ASTReference)node.jjtGetChild(0));
        context.addVar(varName);
        return super.visitForEachDirective(node, data);
    }
}

