/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;

class VTLVariableInfo
implements Cloneable {
    public static final int TYPE_PARAMETER = 0;
    public static final int TYPE_VARIABLE = 1;
    private int nameType;
    private String varName;
    private String[] altTypes;
    private String hint;

    VTLVariableInfo(String varName, String[] typeInfo, int nameType) {
        this.nameType = nameType;
        this.varName = varName;
        this.altTypes = typeInfo;
    }

    public Object clone() {
        try {
            VTLVariableInfo other = (VTLVariableInfo)super.clone();
            other.altTypes = (String[])this.altTypes.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof VTLVariableInfo)) {
            return false;
        }
        return this.equals((VTLVariableInfo)other);
    }

    public boolean equals(VTLVariableInfo other) {
        if (!this.varName.equals(other.getName())) {
            return false;
        }
        if (!Arrays.equals(this.altTypes, other.altTypes)) {
            return false;
        }
        if (this.hint == null && other.hint != null || this.hint != null && other.hint == null) {
            return false;
        }
        if (this.hint == other.hint) {
            return true;
        }
        return this.hint.equals(other.hint);
    }

    public int hashCode() {
        int hashCode = this.varName.hashCode();
        int i = 0;
        while (i < this.altTypes.length) {
            hashCode ^= this.altTypes[i].hashCode();
            ++i;
        }
        if (this.hint != null) {
            hashCode ^= this.hint.hashCode();
        }
        return hashCode;
    }

    public boolean isParameter() {
        return this.nameType == 0;
    }

    public boolean isVariable() {
        return this.nameType == 1;
    }

    public String getName() {
        return this.varName;
    }

    public String getType() {
        return this.altTypes[0];
    }

    public String[] getTypeInfos() {
        return this.altTypes;
    }

    public String getHint() {
        return this.hint;
    }

    void setHint(String typeHint) {
        this.hint = typeHint;
    }

    public String guessType(String methodName) {
        if (this.altTypes.length <= 1) {
            return null;
        }
        try {
            HashSet<String> matches = new HashSet<String>();
            int i = 0;
            while (i < this.altTypes.length) {
                String altType = this.altTypes[i];
                Class<?> clazz = Class.forName(altType);
                Method[] methods = clazz.getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    if (Modifier.isPublic(methods[j].getModifiers()) && methodName.equals(methods[j].getName())) {
                        matches.add(altType);
                    }
                    ++j;
                }
                ++i;
            }
            if (matches.size() == 1) {
                return (String)matches.iterator().next();
            }
            if (matches.size() == 0) {
                return null;
            }
            throw new RuntimeException("ambiguous call to " + methodName + ": declared in " + matches);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

