/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import java.util.ArrayList;

public abstract class StringUtil {
    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String capitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String decapitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String escapeString(String text) {
        if (StringUtil.isEmpty(text)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < text.length()) {
            char character = text.charAt(i);
            String escapedCharacter = StringUtil.escapeChar(character);
            if (escapedCharacter != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(2 * text.length());
                    int j = 0;
                    while (j < i) {
                        buffer.append(text.charAt(j));
                        ++j;
                    }
                }
                buffer.append(escapedCharacter);
            } else if (buffer != null) {
                buffer.append(character);
            }
            ++i;
        }
        return buffer == null ? text : buffer.toString();
    }

    public static String escapeChar(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    public static String[] divide(String text, char separator) {
        if (StringUtil.isEmpty(text)) {
            return new String[0];
        }
        int separators = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == separator) {
                ++separators;
            }
            ++i;
        }
        String[] array = new String[separators + 1];
        int offset = 0;
        int i2 = 0;
        while (i2 < separators) {
            int index = text.indexOf(separator, offset);
            array[i2] = text.substring(offset, index).trim();
            offset = index + 1;
            ++i2;
        }
        array[separators] = text.substring(offset).trim();
        return array;
    }

    public static String[] splitLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        int l = text.length();
        int start = 0;
        int end = 0;
        while (end < l) {
            if (text.charAt(end) == '\r') {
                lines.add(text.substring(start, end));
                if (++end >= l || text.charAt(end) == '\n') {
                    // empty if block
                }
                start = ++end;
                continue;
            }
            if (text.charAt(end) == '\n') {
                lines.add(text.substring(start, end));
                if (++end >= l || text.charAt(end) == '\r') {
                    // empty if block
                }
                start = ++end;
                continue;
            }
            ++end;
        }
        if (start < l) {
            lines.add(text.substring(start, l));
        } else {
            lines.add("");
        }
        return lines.toArray(new String[0]);
    }

    public static boolean hasPackageName(String fullClassName) {
        return fullClassName.lastIndexOf(46) >= 0;
    }

    public static String getPackageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? "" : fullClassName.substring(0, index);
    }

    public static String getUnqualifiedClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? fullClassName : fullClassName.substring(index + 1);
    }

    public static String getQualifiedClassName(String packageName, String unqualifiedClassName) {
        if (packageName == null || "".equals(packageName)) {
            return unqualifiedClassName;
        }
        return packageName + "." + unqualifiedClassName;
    }
}

