/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.velocity.compiler.Context;
import com.sap.ide.generationfwk.velocity.compiler.VTLVariableInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class LiteralDef {
    private String literal;
    private VTLVariableInfo[] parameterInfos;

    private LiteralDef(String literal, List vtlVariables) {
        this.literal = literal;
        this.parameterInfos = vtlVariables.toArray(new VTLVariableInfo[vtlVariables.size()]);
    }

    public String getLiteral() {
        return this.literal;
    }

    public int getParameterCount() {
        return this.parameterInfos.length;
    }

    public VTLVariableInfo getParameterInfo(int i) {
        return this.parameterInfos[i];
    }

    public int hashCode() {
        int hashCode = this.literal.hashCode();
        int i = 0;
        while (i < this.parameterInfos.length) {
            hashCode ^= this.parameterInfos[i].getName().hashCode();
            hashCode ^= this.parameterInfos[i].getType().hashCode();
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof LiteralDef) {
            return this.equals((LiteralDef)o);
        }
        return false;
    }

    public boolean equals(LiteralDef other) {
        if (!this.literal.equals(other.literal)) {
            return false;
        }
        return Arrays.equals(this.parameterInfos, other.parameterInfos);
    }

    private static Set getReferencesFromLiteral(String literal) {
        HashSet<String> refs = new HashSet<String>();
        int p = 0;
        int pos = 0;
        while ((pos = literal.indexOf(36, p)) >= 0) {
            p = ++pos;
            if (pos < literal.length() && literal.charAt(pos) == '{') {
                p = ++pos;
            }
            while (pos < literal.length() && Character.isJavaIdentifierPart(literal.charAt(pos))) {
                ++pos;
            }
            if (p < pos) {
                refs.add(literal.substring(p, pos));
            }
            p = pos;
        }
        return refs;
    }

    static LiteralDef createFromLiteral(String literal, Context context) {
        Set refNames = LiteralDef.getReferencesFromLiteral(literal);
        if (!refNames.isEmpty()) {
            ArrayList<Object> vtlVariables = new ArrayList<Object>();
            Iterator it = refNames.iterator();
            while (it.hasNext()) {
                String variableName = (String)it.next();
                VTLVariableInfo variable = context.getVarInfo(variableName);
                if (variable == null) {
                    throw new RuntimeException("variable " + variableName + " not found in context");
                }
                vtlVariables.add(variable.clone());
            }
            return new LiteralDef(literal, vtlVariables);
        }
        return null;
    }
}

