/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import java.io.IOException;
import java.io.Writer;

public class IndentationPrintWriter {
    private static String lineSeparator = System.getProperty("line.separator");
    private Writer out;
    private int indent = 0;
    private boolean startOfLine = true;

    public void indent() {
        this.indent += 2;
    }

    public void unindent() {
        this.indent -= 2;
    }

    private void checkStartOfLine() {
        try {
            if (this.startOfLine) {
                int i = 0;
                while (i < this.indent) {
                    this.out.write(32);
                    ++i;
                }
            }
            this.startOfLine = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public IndentationPrintWriter(Writer out) {
        this.out = out;
    }

    public void print(String str) {
        try {
            this.checkStartOfLine();
            this.out.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void println() {
        try {
            this.out.write(lineSeparator);
            this.startOfLine = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void ensureNewLine() {
        if (!this.startOfLine) {
            this.println();
        }
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(Object o) {
        this.print(String.valueOf(o));
    }

    public void println(String str) {
        this.print(str);
        this.println();
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

