/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.velocity.compiler.StringUtil;
import com.sap.ide.generationfwk.velocity.compiler.VTLVariableInfo;
import com.sap.ide.generationfwk.velocity.compiler.VelocityCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

class Context {
    private VelocityCompiler vc;
    private String contextName;
    private int forEachDepth = 0;
    private Map concreteTypeImports = new HashMap();
    private List genericTypeImports = new ArrayList();
    private Map vars = new HashMap();
    private Stack hintsStack = new Stack();
    private Map overriddenHints = new HashMap();
    private boolean lhs = false;
    private boolean lastAccessor = false;

    public Context(VelocityCompiler vc, String name, Properties typeInfos) {
        this.vc = vc;
        this.contextName = name;
        if (typeInfos != null) {
            Iterator it = ((Hashtable)typeInfos).keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith("uses.")) continue;
                this.addTypeImport(key.substring("uses.".length()));
            }
        }
        this.addVar("velocityCount", "int");
    }

    public String getContextName() {
        return this.contextName;
    }

    public String toString() {
        return "Context {" + this.vars.keySet() + "}";
    }

    public int getForEachDepth() {
        return this.forEachDepth;
    }

    public void incForEachDepth() {
        ++this.forEachDepth;
    }

    public void decForEachDepth() {
        --this.forEachDepth;
    }

    public void addTypeImport(String typeName) {
        if (typeName.endsWith(".*")) {
            this.genericTypeImports.add(StringUtil.getPackageName(typeName));
        } else {
            this.concreteTypeImports.put(StringUtil.getUnqualifiedClassName(typeName), typeName);
        }
    }

    private boolean existsClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String resolveType(String typeName) {
        String testName;
        if (StringUtil.hasPackageName(typeName)) {
            return typeName;
        }
        if (typeName.endsWith("[]")) {
            return this.resolveType(typeName.substring(0, typeName.length() - 2)) + "[]";
        }
        if (this.concreteTypeImports.containsKey(typeName)) {
            return (String)this.concreteTypeImports.get(typeName);
        }
        int i = 0;
        while (i < this.genericTypeImports.size()) {
            testName = StringUtil.getQualifiedClassName((String)this.genericTypeImports.get(i), typeName);
            if (this.existsClass(testName)) {
                return testName;
            }
            ++i;
        }
        testName = StringUtil.getQualifiedClassName("java.lang", typeName);
        if (this.existsClass(testName)) {
            return testName;
        }
        return typeName;
    }

    public void addVar(VTLVariableInfo info) {
        if (!this.vars.containsKey(info.getName())) {
            this.vars.put(info.getName(), info);
        }
    }

    public void addParameter(String name, String typeInfo) {
        if (!this.vars.containsKey(name)) {
            String[] types = StringUtil.divide(typeInfo, ',');
            int i = 0;
            while (i < types.length) {
                types[i] = this.resolveType(types[i]);
                ++i;
            }
            this.vars.put(name, new VTLVariableInfo(name, types, 0));
        }
    }

    public void addVar(String name, String[] typeInfos) {
        if (!this.vars.containsKey(name)) {
            this.vars.put(name, new VTLVariableInfo(name, typeInfos, 1));
        }
    }

    public void addVar(String name, String typeInfo) {
        if (!this.vars.containsKey(name)) {
            String[] types = StringUtil.divide(typeInfo, ',');
            int i = 0;
            while (i < types.length) {
                types[i] = this.resolveType(types[i]);
                ++i;
            }
            this.addVar(name, types);
        }
    }

    public void addParameter(String varName) {
        this.addParameter(varName, this.vc.getTypeInfo(this.contextName, varName));
    }

    public void addVar(String varName) {
        this.addVar(varName, this.vc.getTypeInfo(this.contextName, varName));
    }

    public Iterator iterateVariables() {
        return this.vars.values().iterator();
    }

    public boolean containsVar(String variableName) {
        return this.vars.containsKey(variableName);
    }

    public VTLVariableInfo getVarInfo(String variableName) {
        return (VTLVariableInfo)this.vars.get(variableName);
    }

    public void removeVar(String variableName) {
        this.vars.remove(variableName);
    }

    public String getType(String varName) {
        if (this.vars.containsKey(varName)) {
            return ((VTLVariableInfo)this.vars.get(varName)).getType();
        }
        if ("java.lang.String" != null) {
            return "java.lang.String";
        }
        throw new RuntimeException("can't determine type for var " + varName);
    }

    public String guessCastedType(String varName, String methodName) {
        if (this.vars.containsKey(varName)) {
            return ((VTLVariableInfo)this.vars.get(varName)).guessType(methodName);
        }
        return null;
    }

    public void beginHintScope() {
        this.hintsStack.push(this.overriddenHints);
        this.overriddenHints = new HashMap();
    }

    public void endHintScope() {
        Iterator it = this.overriddenHints.keySet().iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            VTLVariableInfo info = this.getVarInfo(varName);
            info.setHint((String)this.overriddenHints.get(varName));
        }
        this.overriddenHints = (Map)this.hintsStack.pop();
    }

    public String getHint(String varName) {
        VTLVariableInfo info = this.getVarInfo(varName);
        if (info != null) {
            return info.getHint();
        }
        return null;
    }

    public void addHint(String varName, String type) {
        String qualifiedType = this.resolveType(type);
        VTLVariableInfo info = this.getVarInfo(varName);
        if (!this.overriddenHints.containsKey(varName)) {
            this.overriddenHints.put(varName, info.getHint());
        }
        info.setHint(qualifiedType);
    }

    public void setLHS(boolean lhs) {
        this.lhs = lhs;
    }

    public boolean isLHS() {
        return this.lhs;
    }

    public void setLastAccessor(boolean lastAccessor) {
        this.lastAccessor = lastAccessor;
    }

    public boolean isLastAccessor() {
        return this.lastAccessor;
    }
}

