/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.velocity.compiler;

import com.sap.ide.generationfwk.velocity.compiler.AbstractVisitor;
import com.sap.ide.generationfwk.velocity.compiler.Context;
import com.sap.ide.generationfwk.velocity.compiler.IndentationPrintWriter;
import com.sap.ide.generationfwk.velocity.compiler.LiteralDef;
import com.sap.ide.generationfwk.velocity.compiler.StringUtil;
import com.sap.ide.generationfwk.velocity.compiler.VelocityCompiler;
import org.apache.velocity.runtime.parser.node.ASTAddNode;
import org.apache.velocity.runtime.parser.node.ASTAndNode;
import org.apache.velocity.runtime.parser.node.ASTAssignment;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.ASTComment;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTDivNode;
import org.apache.velocity.runtime.parser.node.ASTEQNode;
import org.apache.velocity.runtime.parser.node.ASTElseIfStatement;
import org.apache.velocity.runtime.parser.node.ASTElseStatement;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTFalse;
import org.apache.velocity.runtime.parser.node.ASTGENode;
import org.apache.velocity.runtime.parser.node.ASTGTNode;
import org.apache.velocity.runtime.parser.node.ASTIdentifier;
import org.apache.velocity.runtime.parser.node.ASTIfStatement;
import org.apache.velocity.runtime.parser.node.ASTLENode;
import org.apache.velocity.runtime.parser.node.ASTLTNode;
import org.apache.velocity.runtime.parser.node.ASTMethod;
import org.apache.velocity.runtime.parser.node.ASTModNode;
import org.apache.velocity.runtime.parser.node.ASTMulNode;
import org.apache.velocity.runtime.parser.node.ASTNENode;
import org.apache.velocity.runtime.parser.node.ASTNotNode;
import org.apache.velocity.runtime.parser.node.ASTNumberLiteral;
import org.apache.velocity.runtime.parser.node.ASTObjectArray;
import org.apache.velocity.runtime.parser.node.ASTOrNode;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.ASTSubtractNode;
import org.apache.velocity.runtime.parser.node.ASTText;
import org.apache.velocity.runtime.parser.node.ASTTrue;
import org.apache.velocity.runtime.parser.node.ASTprocess;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

class CompilationVisitor
extends AbstractVisitor {
    private IndentationPrintWriter out;

    private static final void check(boolean cond, String descr) {
        if (!cond) {
            throw new RuntimeException("assertion failed: " + descr);
        }
    }

    public CompilationVisitor(VelocityCompiler vc) {
        super(vc, true);
    }

    public void generate(SimpleNode rootNode, IndentationPrintWriter out, Object data) {
        this.out = out;
        this.visitBlock(rootNode, data);
        this.out = null;
    }

    private boolean isQuietReference(ASTReference node) {
        return node.getFirstToken().image.startsWith("$!");
    }

    public Object visitBlock(SimpleNode node, Object data) {
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            if (child instanceof ASTReference) {
                if (this.isQuietReference((ASTReference)child)) {
                    this.out.print("try {");
                }
                this.out.print("print(");
                child.jjtAccept((ParserVisitor)this, data);
                this.out.print(");");
                if (this.isQuietReference((ASTReference)child)) {
                    this.out.print("}");
                    this.out.print(" catch (IOException e) { throw e; }");
                    this.out.println(" catch (Exception e) { // ignore silently $JL-EXC$");
                    this.out.println("}");
                }
            } else {
                child.jjtAccept((ParserVisitor)this, data);
            }
            ++i;
        }
        return data;
    }

    public Object visit(ASTprocess node, Object data) {
        return this.visitBlock((SimpleNode)node, data);
    }

    public Object visit(ASTComment node, Object data) {
        String comment = node.literal();
        if (comment.startsWith("##")) {
            int to;
            int from;
            if (comment.indexOf("#hint(") >= 0 && (from = comment.indexOf("#hint(")) < (to = comment.indexOf(")", from))) {
                String[] hint = StringUtil.divide(comment.substring(from + 7, to), ':');
                ((Context)data).addHint(hint[0], hint[1]);
            }
            while (Character.isWhitespace(comment.charAt(comment.length() - 1))) {
                comment = comment.substring(0, comment.length() - 1);
            }
            this.out.println("//" + comment.substring(2));
        } else if (!comment.startsWith("#**")) {
            this.vc.dumpComment(comment);
        }
        return data;
    }

    public Object visit(ASTNumberLiteral node, Object data) {
        this.out.print(StringUtil.escapeString(node.literal()));
        return data;
    }

    public Object visit(ASTStringLiteral node, Object data) {
        String literal = node.literal();
        LiteralDef def = LiteralDef.createFromLiteral(literal = literal.substring(1, literal.length() - 1), (Context)data);
        if (def != null) {
            String methodName = this.vc.registerLiteralDef(def);
            this.out.print("literals." + methodName + "(");
            int i = 0;
            while (i < def.getParameterCount()) {
                if (i > 0) {
                    this.out.print(",");
                }
                this.out.print(this.vc.makeVarFromIdentifier(def.getParameterInfo(i).getName()));
                ++i;
            }
            this.out.print(")");
        } else {
            this.out.print("\"" + StringUtil.escapeString(literal) + "\"");
        }
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        Context context = (Context)data;
        if (context.isLHS() && context.isLastAccessor()) {
            this.out.print("set" + StringUtil.capitalize(node.literal()) + "(");
        } else {
            this.out.print("get" + StringUtil.capitalize(node.literal()) + "()");
        }
        return data;
    }

    public Object visit(ASTBlock node, Object data) {
        Context context = (Context)data;
        context.beginHintScope();
        data = this.visitBlock((SimpleNode)node, data);
        context.endHintScope();
        return data;
    }

    public Object visit(ASTObjectArray node, Object data) {
        String arrayExpr = node.literal();
        arrayExpr = arrayExpr.substring(1, arrayExpr.length() - 1);
        this.out.print("new Object[] { " + arrayExpr + " }");
        return data;
    }

    public Object visit(ASTMethod node, Object data) {
        String name = node.jjtGetChild(0).literal();
        this.out.print(name + "(");
        int i = 1;
        while (i < node.jjtGetNumChildren()) {
            if (i > 1) {
                this.out.print(", ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        this.out.print(")");
        return data;
    }

    public Object visit(ASTReference node, Object data) {
        Context context = (Context)data;
        String identifier = node.getFirstToken().image;
        if (identifier.equals("${") || identifier.equals("$!{")) {
            identifier = node.getFirstToken().next.image;
        } else if (identifier.startsWith("$!")) {
            identifier = identifier.substring(2);
        } else if (identifier.startsWith("$")) {
            identifier = identifier.substring(1);
        }
        String castToType = null;
        if (node.jjtGetNumChildren() >= 1) {
            String methodToCall = null;
            if (node.jjtGetChild(0) instanceof ASTIdentifier) {
                ASTIdentifier identNode = (ASTIdentifier)node.jjtGetChild(0);
                methodToCall = "get" + StringUtil.capitalize(identNode.literal());
            } else if (node.jjtGetChild(0) instanceof ASTMethod) {
                ASTMethod methodNode = (ASTMethod)node.jjtGetChild(0);
                methodToCall = methodNode.jjtGetChild(0).literal();
            }
            if (methodToCall != null) {
                castToType = context.guessCastedType(identifier, methodToCall);
            }
        }
        if (castToType == null) {
            castToType = context.getHint(identifier);
        }
        if (castToType != null) {
            this.out.print("((" + castToType + ") ");
        }
        this.out.print(this.vc.makeVarFromIdentifier(identifier));
        if (castToType != null) {
            this.out.print(")");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren() - 1) {
            this.out.print(".");
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (node.jjtGetNumChildren() > 0) {
            int i2 = node.jjtGetNumChildren() - 1;
            this.out.print(".");
            context.setLastAccessor(true);
            node.jjtGetChild(i2).jjtAccept((ParserVisitor)this, data);
            context.setLastAccessor(false);
        }
        return data;
    }

    private boolean needsParenthesis(SimpleNode node) {
        String nodeLiteral = node.literal().trim();
        boolean result = nodeLiteral.startsWith("(") && nodeLiteral.endsWith(")");
        return result;
    }

    public Object visit(ASTTrue node, Object data) {
        this.out.print("true");
        return data;
    }

    public Object visit(ASTFalse node, Object data) {
        this.out.print("false");
        return data;
    }

    public Object visit(ASTText node, Object data) {
        String[] lines = StringUtil.splitLines(node.literal());
        int i = 0;
        while (i < lines.length - 1) {
            if (StringUtil.isEmpty(lines[i])) {
                this.out.println("nl();");
            } else {
                this.out.println("print(\"" + StringUtil.escapeString(lines[i]) + "\"" + ");nl()" + ";");
            }
            ++i;
        }
        if (!StringUtil.isEmpty(lines[lines.length - 1])) {
            this.out.print("print(\"" + StringUtil.escapeString(lines[lines.length - 1]) + "\"" + ")" + ";");
        }
        node.childrenAccept((ParserVisitor)this, data);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        Context context = (Context)data;
        this.out.print("if (");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.println(") {");
        this.out.indent();
        this.vc.addBranch("if");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.ensureNewLine();
        this.out.unindent();
        this.out.println("}");
        int i = 2;
        while (i < node.jjtGetNumChildren()) {
            if (node.jjtGetChild(i) instanceof ASTElseIfStatement) {
                this.out.print("else if (");
                node.jjtGetChild(i).jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
                this.out.println(") {");
                this.out.indent();
                this.vc.addBranch("elseif");
                node.jjtGetChild(i).jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
                this.out.ensureNewLine();
                this.out.unindent();
                this.out.println("}");
            } else if (node.jjtGetChild(i) instanceof ASTElseStatement) {
                this.out.println("else { ");
                this.out.indent();
                this.vc.addBranch("else");
                node.jjtGetChild(i).jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
                this.out.ensureNewLine();
                this.out.unindent();
                this.out.println("}");
            }
            ++i;
        }
        return data;
    }

    public Object visit(ASTElseStatement node, Object data) {
        CompilationVisitor.check(false, "node of type ElseStatement should not be reached");
        return this.defaultVisit((SimpleNode)node, data);
    }

    public Object visit(ASTElseIfStatement node, Object data) {
        CompilationVisitor.check(false, "node of type ElseIfStatement should not be reached");
        return this.defaultVisit((SimpleNode)node, data);
    }

    public Object visit(ASTAssignment node, Object data) {
        Context context = (Context)data;
        String varName = AbstractVisitor.getContextKeyFromReference((ASTReference)node.jjtGetChild(0));
        if (node.jjtGetChild(0).jjtGetNumChildren() == 0) {
            CompilationVisitor.check(context.containsVar(varName), "variable '" + varName + "' must have been declared before an assignment");
        }
        context.setLHS(true);
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, (Object)context);
        if (node.jjtGetChild(0).jjtGetNumChildren() == 0) {
            this.out.print(" = (" + context.getType(varName) + ") ");
        }
        context.setLHS(false);
        if (node.jjtGetChild(0).literal().equals(node.jjtGetChild(1).literal())) {
            this.out.print("rootContext.get(\"" + varName + "\")");
        } else {
            node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        }
        if (node.jjtGetChild(0).jjtGetNumChildren() > 0) {
            this.out.print(")");
        }
        this.out.println(";");
        return data;
    }

    public Object visit(ASTExpression node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        Object result = super.visit(node, data);
        if (np) {
            this.out.print(")");
        }
        return result;
    }

    public Object visit(ASTOrNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" || ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTAndNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" && ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTEQNode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "EQ node must have exactly 2 args");
        this.out.print("isEQ(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTNENode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "NE node must have exactly 2 args");
        this.out.print("isNE(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTLTNode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "LT node must have exactly 2 args");
        this.out.print("isLT(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTGTNode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "GT node must have exactly 2 args");
        this.out.print("isGT(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTLENode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "LE node must have exactly 2 args");
        this.out.print("isLE(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTGENode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 2, "GE node must have exactly 2 args");
        this.out.print("isGE(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(", ");
        node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visit(ASTAddNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" + ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTSubtractNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" - ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTMulNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" * ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTDivNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" / ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTModNode node, Object data) {
        boolean np = this.needsParenthesis((SimpleNode)node);
        if (np) {
            this.out.print("(");
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            if (i > 0) {
                this.out.print(" % ");
            }
            node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            ++i;
        }
        if (np) {
            this.out.print(")");
        }
        return data;
    }

    public Object visit(ASTNotNode node, Object data) {
        CompilationVisitor.check(node.jjtGetNumChildren() == 1, "A 'Not' node must have exactly 1 arg");
        this.out.print("isNot(");
        node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
        this.out.print(")");
        return data;
    }

    public Object visitMacroDirective(ASTDirective node, Object data) {
        this.out.println();
        this.out.println("/* ---- original location of macro declaration '" + node.jjtGetChild(0).literal() + "' ---- */");
        this.out.println();
        return data;
    }

    public Object visitForEachDirective(ASTDirective node, Object data) {
        Context context = (Context)data;
        String varName = AbstractVisitor.getContextKeyFromReference((ASTReference)node.jjtGetChild(0));
        String itName = "it" + context.getForEachDepth();
        this.out.print("for (Iterator " + itName + "=iterate(");
        node.jjtGetChild(2).jjtAccept((ParserVisitor)this, data);
        this.out.println("); " + itName + ".hasNext(); ) {");
        context.incForEachDepth();
        this.out.indent();
        this.vc.addBranch("foreach");
        CompilationVisitor.check(context.containsVar(varName), "variable must have been declared before foreach");
        this.out.println(this.vc.makeVarFromIdentifier(varName) + " = (" + context.getType(varName) + ") " + itName + ".next();");
        node.jjtGetChild(3).jjtAccept((ParserVisitor)this, data);
        context.decForEachDepth();
        this.out.ensureNewLine();
        this.out.unindent();
        this.out.println("}");
        return data;
    }

    public Object visitIncludeDirective(ASTDirective node, Object data) {
        return this.defaultVisit((SimpleNode)node, data);
    }

    protected Object doBeforeIncludedTemplate(String templateName, SimpleNode node, Object data) {
        this.out.println();
        this.out.println("/* ----------------------------------------------------------------------------- *");
        this.out.println(" * #parse(" + templateName + ") begin");
        this.out.println(" * ----------------------------------------------------------------------------- */");
        this.out.println();
        return super.doBeforeIncludedTemplate(templateName, node, data);
    }

    protected Object doAfterIncludedTemplate(String templateName, SimpleNode node, Object data) {
        this.out.println("/* ----------------------------------------------------------------------------- *");
        this.out.println(" * #parse(" + templateName + ") end");
        this.out.println(" * ----------------------------------------------------------------------------- */");
        return super.doAfterIncludedTemplate(templateName, node, data);
    }

    public Object visitOtherDirective(ASTDirective node, Object data) {
        if (this.vc.isMacroName(node.getFirstToken().image.substring(1))) {
            String macroName = node.getFirstToken().image.substring(1);
            this.out.print("vm_" + macroName + "(");
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                if (i > 0) {
                    this.out.print(", ");
                }
                node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
                ++i;
            }
            this.out.println(");");
            return data;
        }
        System.err.println("**** warning: unrecognized directive <" + node.getFirstToken().image + "> (copied 1:1)");
        this.out.println("// @todo unrecognized directive <" + node.getFirstToken().image + ">");
        this.out.println("print(\"" + StringUtil.escapeString(node.literal()) + "\"" + ")" + ";");
        return data;
    }
}

