/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;

class VisualAnnotationModel
extends AnnotationModel
implements IAnnotationModelListener {
    private IAnnotationModel fModel;

    public VisualAnnotationModel(IAnnotationModel modelAnnotationModel) {
        this.fModel = modelAnnotationModel;
    }

    public IAnnotationModel getModelAnnotationModel() {
        return this.fModel;
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (this.fModel != null && this.fAnnotationModelListeners.isEmpty()) {
            this.fModel.addAnnotationModelListener(this);
        }
        super.addAnnotationModelListener(listener);
    }

    public void connect(IDocument document) {
        super.connect(document);
        if (this.fModel != null) {
            this.fModel.connect(document);
        }
    }

    public void disconnect(IDocument document) {
        super.disconnect(document);
        if (this.fModel != null) {
            this.fModel.disconnect(document);
        }
    }

    public Iterator getAnnotationIterator() {
        if (this.fModel == null) {
            return super.getAnnotationIterator();
        }
        ArrayList a = new ArrayList(20);
        Iterator e = this.fModel.getAnnotationIterator();
        while (e.hasNext()) {
            a.add(e.next());
        }
        e = super.getAnnotationIterator();
        while (e.hasNext()) {
            a.add(e.next());
        }
        return ((AbstractList)a).iterator();
    }

    public Position getPosition(Annotation annotation) {
        Position p = (Position)this.fAnnotations.get(annotation);
        if (p != null) {
            return p;
        }
        if (this.fModel != null) {
            return this.fModel.getPosition(annotation);
        }
        return null;
    }

    public void modelChanged(IAnnotationModel model) {
        if (model == this.fModel) {
            int size = this.fAnnotationModelListeners.size();
            int i = 0;
            while (i < size) {
                IAnnotationModelListener l = (IAnnotationModelListener)this.fAnnotationModelListeners.get(i);
                l.modelChanged(this);
                ++i;
            }
        }
    }

    public void modifyAnnotation(Annotation annotation, Position position) {
        this.modifyAnnotation(annotation, position, true);
    }

    private void modifyAnnotation(Annotation annotation, Position position, boolean fireModelChanged) {
        if (position == null) {
            this.removeAnnotation(annotation, fireModelChanged);
        } else {
            Position p = (Position)this.fAnnotations.get(annotation);
            if (p != null) {
                p.setOffset(position.getOffset());
                p.setLength(position.getLength());
                if (fireModelChanged) {
                    this.fireModelChanged();
                }
            } else {
                this.addAnnotation(annotation, position, fireModelChanged);
            }
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        super.removeAnnotationModelListener(listener);
        if (this.fModel != null && this.fAnnotationModelListeners.isEmpty()) {
            this.fModel.removeAnnotationModelListener(this);
        }
    }
}

