/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.ProjectionDocument;
import org.eclipse.jface.text.ProjectionDocumentManager;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.ProjectionAnnotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ProjectionSourceViewer
extends SourceViewer
implements ISourceViewer,
ITextViewerExtension3 {
    private IAnnotationModel fProjectionAnnotationModel;

    public ProjectionSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int visibleRegionOffset, int visibleRegionLength) {
        if (this.getDocument() != null && this.fProjectionAnnotationModel != null) {
            this.fProjectionAnnotationModel.disconnect(this.getDocument());
        }
        super.setDocument(document, annotationModel, visibleRegionOffset, visibleRegionLength);
        if (this.getDocument() != null && this.fProjectionAnnotationModel != null) {
            this.fProjectionAnnotationModel.connect(this.getDocument());
        }
    }

    protected void handleDispose() {
        if (this.getDocument() != null && this.fProjectionAnnotationModel != null) {
            this.fProjectionAnnotationModel.disconnect(this.getDocument());
            this.fProjectionAnnotationModel = null;
        }
        super.handleDispose();
    }

    public IAnnotationModel getProjectionAnnotationModel() {
        return this.fProjectionAnnotationModel;
    }

    public void setProjectionAnnotationModel(IAnnotationModel projectionAnnotationModel) {
        this.fProjectionAnnotationModel = projectionAnnotationModel;
    }

    protected ISlaveDocumentManager createSlaveDocumentManager() {
        return new ProjectionDocumentManager();
    }

    protected boolean updateVisibleDocument(IDocument visibleDocument, int visibleRegionOffset, int visibleRegionLength) throws BadLocationException {
        if (visibleDocument instanceof ProjectionDocument) {
            ProjectionDocument document = (ProjectionDocument)visibleDocument;
            document.addFragment(visibleRegionOffset, visibleRegionLength);
        }
        return true;
    }

    public void collapse(int offset, int length) {
        block12: {
            IDocument previous = this.getVisibleDocument();
            IDocument slave = this.createSlaveDocument(previous);
            if (!(slave instanceof ProjectionDocument)) break block12;
            StyledText textWidget = this.getTextWidget();
            try {
                if (textWidget != null) {
                    textWidget.setRedraw(false);
                }
                int topIndex = this.getTopIndex();
                Point selection = this.getSelectedRange();
                int selectionEnd = selection.x + selection.y;
                if (offset < selectionEnd && selectionEnd <= offset + length) {
                    int lineEnd = offset;
                    try {
                        IDocument document = this.getDocument();
                        int line = document.getLineOfOffset(offset);
                        IRegion lineInfo = document.getLineInformation(Math.max(line - 1, 0));
                        lineEnd = lineInfo.getOffset() + lineInfo.getLength();
                    }
                    catch (BadLocationException badLocationException) {}
                    if (offset <= selection.x && selection.x < offset + length) {
                        selection.x = lineEnd;
                        selection.y = 0;
                    } else {
                        selection.y = Math.max(lineEnd - selection.x, 0);
                    }
                } else if (offset <= selection.x && selection.x < offset + length) {
                    int delta = offset + length - selection.x;
                    selection.x = offset + length;
                    selection.y -= delta;
                }
                ((ProjectionDocument)slave).hide(offset, length);
                this.setVisibleDocument(slave);
                this.setSelectedRange(selection.x, selection.y);
                this.setTopIndex(topIndex);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (textWidget != null) {
                    textWidget.setRedraw(true);
                }
                throw throwable;
            }
            Object var13_16 = null;
            if (textWidget != null) {
                textWidget.setRedraw(true);
            }
        }
    }

    public void expand(int offset, int length) {
        block5: {
            if (!(this.getVisibleDocument() instanceof ProjectionDocument)) break block5;
            ProjectionDocument document = (ProjectionDocument)this.getVisibleDocument();
            StyledText textWidget = this.getTextWidget();
            try {
                if (textWidget != null) {
                    textWidget.setRedraw(false);
                }
                Point selection = this.getSelectedRange();
                int topIndex = this.getTopIndex();
                document.show(offset, length);
                this.setVisibleDocument((IDocument)document);
                this.setSelectedRange(selection.x, selection.y);
                this.setTopIndex(topIndex);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (textWidget != null) {
                    textWidget.setRedraw(true);
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (textWidget != null) {
                textWidget.setRedraw(true);
            }
        }
    }

    public IRegion getVisibleRegion() {
        return null;
    }

    protected int getVisibleRegionOffset() {
        return -1;
    }

    protected IRegion internalGetVisibleRegion() {
        return null;
    }

    public boolean overlapsWithVisibleRegion(int offset, int length) {
        return false;
    }

    public IDocument getVisibleDocument() {
        return super.getVisibleDocument();
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        IRegion modelRange = this.event2ModelRange(e);
        Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            ProjectionAnnotation annotation = (ProjectionAnnotation)iterator.next();
            if (!annotation.isFolded() || !(position = this.fProjectionAnnotationModel.getPosition(annotation)).overlapsWith(modelRange.getOffset(), modelRange.getLength())) continue;
            e.doit = false;
            annotation.run(this);
        }
    }
}

