/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OverviewRuler
implements IOverviewRuler {
    private static final int INSET = 2;
    private static final int ANNOTATION_HEIGHT = 4;
    private static boolean ANNOTATION_HEIGHT_SCALABLE = false;
    private IAnnotationModel fModel;
    private ITextViewer fTextViewer;
    private Canvas fCanvas;
    private Canvas fHeader;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private int fScrollPos;
    private int fLastMouseButtonActivityLine = -1;
    private int fAnnotationHeight = -1;
    private IAnnotationAccess fAnnotationAccess;
    private HeaderPainter fHeaderPainter;
    private Set fAnnotationTypes = new HashSet();
    private Set fHeaderAnnotationTypes = new HashSet();
    private Map fAnnotationTypes2Layers = new HashMap();
    private Map fAnnotationTypes2Colors = new HashMap();
    private ISharedTextColors fSharedTextColors;

    public OverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors) {
        this.fAnnotationAccess = annotationAccess;
        this.fWidth = width;
        this.fSharedTextColors = sharedColors;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setModel(IAnnotationModel model) {
        if (model != this.fModel || model != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener(this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener(this.fInternalListener);
            }
            this.update();
        }
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fHitDetectionCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.fCanvas = new Canvas(parent, 262144);
        this.fHeader = new Canvas(parent, 0);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (OverviewRuler.this.fTextViewer != null) {
                    OverviewRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                OverviewRuler.this.handleDispose();
                OverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                OverviewRuler.this.handleMouseDown(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                OverviewRuler.this.handleMouseMove(event);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextListener(this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        if (this.fHitDetectionCursor != null) {
            this.fHitDetectionCursor.dispose();
            this.fHitDetectionCursor = null;
        }
        this.fAnnotationTypes.clear();
        this.fHeaderAnnotationTypes.clear();
        this.fAnnotationTypes2Layers.clear();
        this.fAnnotationTypes2Colors.clear();
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fTextViewer instanceof ITextViewerExtension3) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        Object var4_6 = null;
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private void doPaint(GC gc) {
        if (this.fTextViewer == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 4;
        IDocument document = this.fTextViewer.getDocument();
        IRegion visible = this.fTextViewer.getVisibleRegion();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getLineCount();
        this.fScrollPos = textWidget.getTopPixel();
        Point size = this.fCanvas.getSize();
        int writable = maxLines * textWidget.getLineHeight();
        if (size.y > writable) {
            size.y = writable;
        }
        ArrayList indices = new ArrayList(this.fAnnotationTypes2Layers.keySet());
        Collections.sort(indices);
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            Object layer = iterator.next();
            Object annotationType = this.fAnnotationTypes2Layers.get(layer);
            if (this.skip(annotationType)) continue;
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            boolean[] temporary = blArray;
            int t = 0;
            while (t < temporary.length) {
                FilterIterator e = new FilterIterator(annotationType, temporary[t]);
                Color fill = this.getFillColor(annotationType, temporary[t]);
                Color stroke = this.getStrokeColor(annotationType, temporary[t]);
                int i = 0;
                while (e.hasNext()) {
                    Annotation a = (Annotation)e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p != null && p.overlapsWith(visible.getOffset(), visible.getLength())) {
                        int annotationOffset = Math.max(p.getOffset(), visible.getOffset());
                        int annotationEnd = Math.min(p.getOffset() + p.getLength(), visible.getOffset() + visible.getLength());
                        int annotationLength = annotationEnd - annotationOffset;
                        try {
                            int numbersOfLines;
                            if (ANNOTATION_HEIGHT_SCALABLE && (hh = (numbersOfLines = document.getNumberOfLines(annotationOffset, annotationLength)) * size.y / maxLines) < 4) {
                                hh = 4;
                            }
                            this.fAnnotationHeight = hh;
                            int startLine = textWidget.getLineAtOffset(annotationOffset - visible.getOffset());
                            int yy = Math.min(startLine * size.y / maxLines, size.y - hh);
                            if (fill != null) {
                                gc.setBackground(fill);
                                gc.fillRectangle(2, yy, size.x - 4, hh);
                            }
                            if (stroke != null) {
                                gc.setForeground(stroke);
                                r.x = 2;
                                r.y = yy;
                                r.width = size.x - 4 - 1;
                                r.height = hh;
                                gc.setLineWidth(1);
                                gc.drawRectangle(r);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    ++i;
                }
                ++t;
            }
        }
    }

    private void doPaint1(GC gc) {
        if (this.fTextViewer == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 4;
        ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fTextViewer);
        IDocument document = this.fTextViewer.getDocument();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        this.fScrollPos = textWidget.getTopPixel();
        int maxLines = textWidget.getLineCount();
        Point size = this.fCanvas.getSize();
        int writable = maxLines * textWidget.getLineHeight();
        if (size.y > writable) {
            size.y = writable;
        }
        ArrayList indices = new ArrayList(this.fAnnotationTypes2Layers.keySet());
        Collections.sort(indices);
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            Object layer = iterator.next();
            Object annotationType = this.fAnnotationTypes2Layers.get(layer);
            if (this.skip(annotationType)) continue;
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            boolean[] temporary = blArray;
            int t = 0;
            while (t < temporary.length) {
                FilterIterator e = new FilterIterator(annotationType, temporary[t]);
                Color fill = this.getFillColor(annotationType, temporary[t]);
                Color stroke = this.getStrokeColor(annotationType, temporary[t]);
                int i = 0;
                while (e.hasNext()) {
                    IRegion widgetRegion;
                    Annotation a = (Annotation)e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p != null && (widgetRegion = extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()))) != null) {
                        try {
                            int numbersOfLines;
                            if (ANNOTATION_HEIGHT_SCALABLE && (hh = (numbersOfLines = document.getNumberOfLines(p.getOffset(), p.getLength())) * size.y / maxLines) < 4) {
                                hh = 4;
                            }
                            this.fAnnotationHeight = hh;
                            int startLine = textWidget.getLineAtOffset(widgetRegion.getOffset());
                            int yy = Math.min(startLine * size.y / maxLines, size.y - hh);
                            if (fill != null) {
                                gc.setBackground(fill);
                                gc.fillRectangle(2, yy, size.x - 4, hh);
                            }
                            if (stroke != null) {
                                gc.setForeground(stroke);
                                r.x = 2;
                                r.y = yy;
                                r.width = size.x - 4 - 1;
                                r.height = hh;
                                gc.setLineWidth(1);
                                gc.drawRectangle(r);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    ++i;
                }
                ++t;
            }
        }
    }

    public void update() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    OverviewRuler.this.redraw();
                    OverviewRuler.this.updateHeader();
                }
            });
        }
    }

    private void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    private int[] toLineNumbers(int y_coordinate) {
        int rulerLength = this.fCanvas.getSize().y;
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getContent().getLineCount();
        int writable = maxLines * textWidget.getLineHeight();
        if (rulerLength > writable) {
            rulerLength = writable;
        }
        if (y_coordinate >= writable) {
            return new int[]{-1, -1};
        }
        int[] lines = new int[2];
        int pixel = Math.max(y_coordinate - 1, 0);
        lines[0] = pixel * maxLines / rulerLength;
        pixel = Math.min(rulerLength, y_coordinate + 1);
        lines[1] = pixel * maxLines / rulerLength;
        if (this.fTextViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fTextViewer);
            lines[0] = extension.widgetlLine2ModelLine(lines[0]);
            lines[1] = extension.widgetlLine2ModelLine(lines[1]);
        } else {
            try {
                IRegion visible = this.fTextViewer.getVisibleRegion();
                int lineNumber = this.fTextViewer.getDocument().getLineOfOffset(visible.getOffset());
                lines[0] = lines[0] + lineNumber;
                lines[1] = lines[1] + lineNumber;
            }
            catch (BadLocationException badLocationException) {}
        }
        return lines;
    }

    private Position getAnnotationPosition(int[] lineNumbers) {
        if (lineNumbers[0] == -1) {
            return null;
        }
        Position found = null;
        try {
            IDocument d = this.fTextViewer.getDocument();
            IRegion line = d.getLineInformation(lineNumbers[0]);
            int start = line.getOffset();
            line = d.getLineInformation(lineNumbers[lineNumbers.length - 1]);
            int end = line.getOffset() + line.getLength();
            FilterIterator e = new FilterIterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = this.fModel.getPosition(a);
                if (start > p.getOffset() || p.getOffset() >= end || found != null && p.getOffset() >= found.getOffset()) continue;
                found = p;
            }
        }
        catch (BadLocationException badLocationException) {}
        return found;
    }

    private int findBestMatchingLineNumber(int[] lineNumbers) {
        if (lineNumbers == null || lineNumbers.length < 1) {
            return -1;
        }
        try {
            Position pos = this.getAnnotationPosition(lineNumbers);
            if (pos == null) {
                return -1;
            }
            return this.fTextViewer.getDocument().getLineOfOffset(pos.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private void handleMouseDown(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines);
            if (p != null) {
                this.fTextViewer.revealRange(p.getOffset(), p.getLength());
                this.fTextViewer.setSelectedRange(p.getOffset(), p.getLength());
            }
            this.fTextViewer.getTextWidget().setFocus();
        }
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(event.y);
    }

    private void handleMouseMove(MouseEvent event) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getAnnotationPosition(lines);
            Cursor cursor2 = cursor = p != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fAnnotationTypes.add(annotationType);
    }

    public void removeAnnotationType(Object annotationType) {
        this.fAnnotationTypes.remove(annotationType);
    }

    public void setAnnotationTypeLayer(Object annotationType, int layer) {
        if (layer >= 0) {
            this.fAnnotationTypes2Layers.put(new Integer(layer), annotationType);
        } else {
            Iterator e = this.fAnnotationTypes2Layers.keySet().iterator();
            while (e.hasNext()) {
                Object key = e.next();
                if (!annotationType.equals(this.fAnnotationTypes2Layers.get(key))) continue;
                this.fAnnotationTypes2Layers.remove(key);
                return;
            }
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fAnnotationTypes2Colors.put(annotationType, color);
        } else {
            this.fAnnotationTypes2Colors.remove(annotationType);
        }
    }

    private boolean skip(Object annotationType) {
        return !this.fAnnotationTypes.contains(annotationType);
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return OverviewRuler.greyLevel(rgb) > 128.0;
    }

    private Color getColor(Object annotationType, double scale) {
        Color base = (Color)this.fAnnotationTypes2Colors.get(annotationType);
        if (base == null) {
            return null;
        }
        RGB baseRGB = base.getRGB();
        RGB background = this.fCanvas.getBackground().getRGB();
        boolean darkBase = OverviewRuler.isDark(baseRGB);
        boolean darkBackground = OverviewRuler.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedTextColors.getColor(OverviewRuler.interpolate(baseRGB, background, scale));
    }

    private Color getStrokeColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary ? 0.5 : 0.2);
    }

    private Color getFillColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary ? 0.9 : 0.6);
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        int[] lineNumbers = this.toLineNumbers(y_coordinate);
        int bestLine = this.findBestMatchingLineNumber(lineNumbers);
        if (bestLine == -1 && lineNumbers.length > 0) {
            return lineNumbers[0];
        }
        return bestLine;
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public int getAnnotationHeight() {
        return this.fAnnotationHeight;
    }

    public boolean hasAnnotation(int y) {
        return this.findBestMatchingLineNumber(this.toLineNumbers(y)) != -1;
    }

    public Control getHeaderControl() {
        return this.fHeader;
    }

    public void addHeaderAnnotationType(Object annotationType) {
        this.fHeaderAnnotationTypes.add(annotationType);
    }

    public void removeHeaderAnnotationType(Object annotationType) {
        this.fHeaderAnnotationTypes.remove(annotationType);
    }

    private void updateHeader() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        ArrayList indices = new ArrayList(this.fAnnotationTypes2Layers.keySet());
        Collections.sort(indices);
        Object colorType = null;
        int i = indices.size() - 1;
        block0: while (i >= 0) {
            Object layer = indices.get(i);
            Object annotationType = this.fAnnotationTypes2Layers.get(layer);
            if (this.fHeaderAnnotationTypes.contains(annotationType)) {
                FilterIterator e = new FilterIterator(annotationType);
                while (e.hasNext()) {
                    if (e.next() == null) continue;
                    colorType = annotationType;
                    break block0;
                }
            }
            --i;
        }
        Color color = null;
        if (colorType != null) {
            color = (Color)this.fAnnotationTypes2Colors.get(colorType);
        }
        if (color == null) {
            if (this.fHeaderPainter != null) {
                this.fHeaderPainter.setColor(null);
            }
        } else {
            if (this.fHeaderPainter == null) {
                this.fHeaderPainter = new HeaderPainter();
                this.fHeader.addPaintListener((PaintListener)this.fHeaderPainter);
            }
            this.fHeaderPainter.setColor(color);
        }
        this.fHeader.redraw();
    }

    class InternalListener
    implements ITextListener,
    IAnnotationModelListener {
        InternalListener() {
        }

        public void textChanged(TextEvent e) {
            if (OverviewRuler.this.fTextViewer != null && e.getDocumentEvent() == null && e.getViewerRedrawState()) {
                OverviewRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel model) {
            OverviewRuler.this.update();
        }
    }

    class FilterIterator
    implements Iterator {
        private static final int IGNORE = 0;
        private static final int TEMPORARY = 1;
        private static final int PERSISTENT = 2;
        private Iterator fIterator;
        private Object fType;
        private Annotation fNext;
        private int fTemporary;

        public FilterIterator() {
            this(null, 0);
        }

        public FilterIterator(Object annotationType) {
            this(annotationType, 0);
        }

        public FilterIterator(Object annotationType, boolean temporary) {
            this(annotationType, temporary ? 1 : 2);
        }

        private FilterIterator(Object annotationType, int temporary) {
            this.fType = annotationType;
            this.fTemporary = temporary;
            if (OverviewRuler.this.fModel != null) {
                this.fIterator = OverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        private void skip() {
            while (this.fIterator.hasNext()) {
                Annotation next = (Annotation)this.fIterator.next();
                Object annotationType = OverviewRuler.this.fAnnotationAccess.getType(next);
                if (annotationType == null) continue;
                this.fNext = next;
                if (this.fType != null && this.fType != annotationType) continue;
                if (this.fTemporary == 0) {
                    return;
                }
                boolean temporary = OverviewRuler.this.fAnnotationAccess.isTemporary(this.fNext);
                if (this.fTemporary == 1 && temporary) {
                    return;
                }
                if (this.fTemporary != 2 || temporary) continue;
                return;
            }
            this.fNext = null;
        }

        public boolean hasNext() {
            return this.fNext != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object next() {
            Annotation annotation;
            try {
                annotation = this.fNext;
                Object var1_2 = null;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                if (OverviewRuler.this.fModel == null) throw throwable;
                this.skip();
                throw throwable;
            }
            if (OverviewRuler.this.fModel == null) return annotation;
            this.skip();
            return annotation;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeaderPainter
    implements PaintListener {
        private Color fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = OverviewRuler.this.fSharedTextColors.getColor(ViewForm.borderInsideRGB);
        }

        public void setColor(Color color) {
            this.fIndicatorColor = color;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = OverviewRuler.this.fHeader.getSize();
            if (this.fIndicatorColor != null) {
                e.gc.setBackground(this.fIndicatorColor);
                Rectangle r = new Rectangle(2, (s.y - 8) / 2, s.x - 4, 8);
                e.gc.fillRectangle(r);
                Display d = OverviewRuler.this.fHeader.getDisplay();
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, d.getSystemColor(18), d.getSystemColor(20));
                }
            }
            e.gc.setForeground(this.fSeparatorColor);
            e.gc.setLineWidth(1);
            e.gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
        }
    }
}

