/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class AnnotationPainter
implements IPainter,
PaintListener,
IAnnotationModelListener {
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    private boolean fIsSettingModel = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private IAnnotationAccess fAnnotationAccess;
    private List fDecorations = new ArrayList();
    private Map fColorTable = new HashMap();
    private Set fAnnotationTypes = new HashSet();

    public AnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access) {
        this.fSourceViewer = sourceViewer;
        this.fAnnotationAccess = access;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    private boolean hasDecorations() {
        return !this.fDecorations.isEmpty();
    }

    private void enablePainting() {
        if (!this.fIsPainting && this.hasDecorations()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    private void disablePainting(boolean redraw) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw && this.hasDecorations()) {
                this.handleDrawRequest(null);
            }
        }
    }

    private void setModel(IAnnotationModel model) {
        block4: {
            if (this.fModel == model) break block4;
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener(this);
            }
            this.fModel = model;
            if (this.fModel != null) {
                try {
                    this.fIsSettingModel = true;
                    this.fModel.addAnnotationModelListener(this);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.fIsSettingModel = false;
                    throw throwable;
                }
                Object var2_4 = null;
                this.fIsSettingModel = false;
            }
        }
    }

    private void catchupWithModel() {
        if (this.fDecorations != null) {
            this.fDecorations.clear();
            if (this.fModel != null) {
                Iterator e = this.fModel.getAnnotationIterator();
                while (e.hasNext()) {
                    Annotation annotation = (Annotation)e.next();
                    Object annotationType = this.fAnnotationAccess.getType(annotation);
                    if (annotationType == null) continue;
                    Color color = null;
                    if (this.fAnnotationTypes.contains(annotationType)) {
                        color = (Color)this.fColorTable.get(annotationType);
                    }
                    if (color == null) continue;
                    Decoration pp = new Decoration();
                    pp.fPosition = this.fModel.getPosition(annotation);
                    pp.fColor = color;
                    pp.fMultiLine = this.fAnnotationAccess.isMultiLine(annotation);
                    this.fDecorations.add(pp);
                }
            }
        }
    }

    private void updatePainting() {
        this.disablePainting(true);
        this.catchupWithModel();
        this.enablePainting();
    }

    public void modelChanged(IAnnotationModel model) {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            if (this.fIsSettingModel) {
                this.updatePainting();
            } else {
                Display d = this.fTextWidget.getDisplay();
                if (d != null) {
                    d.asyncExec(new Runnable(){

                        public void run() {
                            if (AnnotationPainter.this.fTextWidget != null && !AnnotationPainter.this.fTextWidget.isDisposed()) {
                                AnnotationPainter.this.updatePainting();
                            }
                        }
                    });
                }
            }
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fColorTable.put(annotationType, color);
        } else {
            this.fColorTable.remove(annotationType);
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fAnnotationTypes.add(annotationType);
    }

    public void removeAnnotationType(Object annotationType) {
        this.fAnnotationTypes.remove(annotationType);
    }

    public void removeAllAnnotationTypes() {
        this.fAnnotationTypes.clear();
    }

    public boolean isPaintingAnnotations() {
        return !this.fAnnotationTypes.isEmpty();
    }

    public void dispose() {
        if (this.fColorTable != null) {
            this.fColorTable.clear();
        }
        this.fColorTable = null;
        if (this.fAnnotationTypes != null) {
            this.fAnnotationTypes.clear();
        }
        this.fAnnotationTypes = null;
        this.fTextWidget = null;
        this.fSourceViewer = null;
        this.fAnnotationAccess = null;
        this.fModel = null;
        this.fDecorations = null;
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int top = this.fSourceViewer.getTopIndex();
            if (this.fTextWidget.getTopPixel() % this.fTextWidget.getLineHeight() != 0) {
                --top;
            }
            try {
                IDocument document = this.fSourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        if (this.fTextWidget == null) {
            return;
        }
        int vOffset = this.getInclusiveTopIndexStartOffset();
        int vLength = this.fSourceViewer.getBottomIndexEndOffset() + 1;
        Iterator e = this.fDecorations.iterator();
        while (e.hasNext()) {
            Decoration pp = (Decoration)e.next();
            Position p = pp.fPosition;
            if (!p.overlapsWith(vOffset, vLength)) continue;
            if (!pp.fMultiLine) {
                IRegion widgetRange = this.getWidgetRange(p);
                if (widgetRange == null) continue;
                this.draw(gc, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                continue;
            }
            IDocument document = this.fSourceViewer.getDocument();
            try {
                int startLine = document.getLineOfOffset(p.getOffset());
                int lastInclusive = Math.max(p.getOffset(), p.getOffset() + p.getLength() - 1);
                int endLine = document.getLineOfOffset(lastInclusive);
                int i = startLine;
                while (i <= endLine) {
                    IRegion widgetRange;
                    IRegion line = document.getLineInformation(i);
                    int paintStart = Math.max(line.getOffset(), p.getOffset());
                    int paintEnd = Math.min(line.getOffset() + line.getLength(), p.getOffset() + p.getLength());
                    if (paintEnd > paintStart && (widgetRange = this.getWidgetRange(new Position(paintStart, paintEnd - paintStart))) != null) {
                        this.draw(gc, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private IRegion getWidgetRange(Position p) {
        int length;
        if (this.fSourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fSourceViewer);
            return extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()));
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int offset = region.getOffset();
        if (p.overlapsWith(offset, length = region.getLength())) {
            int p1 = Math.max(offset, p.getOffset());
            int p2 = Math.min(offset + length, p.getOffset() + p.getLength());
            return new Region(p1 - offset, p2 - p1);
        }
        return null;
    }

    private int[] computePolyline(Point left, Point right, int height) {
        int peeks = (right.x - left.x) / 4;
        int leftX = left.x;
        int length = (2 * peeks + 1) * 2;
        if (length < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int bottom = left.y + height - 1;
        int top = bottom - 2;
        int i = 0;
        while (i < peeks) {
            int index = 4 * i;
            coordinates[index] = leftX + 4 * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left.x + 4 * peeks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    private void draw(GC gc, int offset, int length, Color color) {
        if (gc != null) {
            Point left = this.fTextWidget.getLocationAtOffset(offset);
            Point right = this.fTextWidget.getLocationAtOffset(offset + length);
            gc.setForeground(color);
            int[] polyline = this.computePolyline(left, right, gc.getFontMetrics().getHeight());
            gc.drawPolyline(polyline);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(redraw);
            this.setModel(null);
            this.catchupWithModel();
        }
    }

    public void paint(int reason) {
        if (this.fSourceViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            IAnnotationModel model = this.fSourceViewer.getAnnotationModel();
            if (model != null) {
                this.fIsActive = true;
                this.setModel(this.fSourceViewer.getAnnotationModel());
            }
        } else if (16 == reason || 8 == reason) {
            this.updatePainting();
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    private static class Decoration {
        Position fPosition;
        Color fColor;
        boolean fMultiLine;

        Decoration() {
        }
    }
}

