/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;

public class AnnotationModel
implements IAnnotationModel {
    protected Map fAnnotations = Collections.synchronizedMap(new HashMap(10));
    protected ArrayList fAnnotationModelListeners = new ArrayList(2);
    protected IDocument fDocument;
    private int fOpenConnections = 0;
    private IDocumentListener fDocumentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            AnnotationModel.this.fDocumentChanged = true;
        }
    };
    private boolean fDocumentChanged = true;

    public void addAnnotation(Annotation annotation, Position position) {
        this.addAnnotation(annotation, position, true);
    }

    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) {
        if (!this.fAnnotations.containsKey(annotation)) {
            this.fAnnotations.put(annotation, position);
            this.addPosition(this.fDocument, position);
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.fAnnotationModelListeners.contains(listener)) {
            this.fAnnotationModelListeners.add(listener);
            listener.modelChanged(this);
        }
    }

    protected void addPosition(IDocument document, Position position) {
        if (document != null) {
            try {
                document.addPosition(position);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void connect(IDocument document) {
        Assert.isTrue((this.fDocument == null || this.fDocument == document ? 1 : 0) != 0);
        if (this.fDocument == null) {
            this.fDocument = document;
            Iterator e = this.fAnnotations.values().iterator();
            while (e.hasNext()) {
                this.addPosition(this.fDocument, (Position)e.next());
            }
        }
        ++this.fOpenConnections;
        if (this.fOpenConnections == 1) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
            this.connected();
        }
    }

    protected void connected() {
    }

    protected void disconnected() {
    }

    public void disconnect(IDocument document) {
        Assert.isTrue((this.fDocument == document ? 1 : 0) != 0);
        --this.fOpenConnections;
        if (this.fOpenConnections == 0) {
            this.disconnected();
            this.fDocument.removeDocumentListener(this.fDocumentListener);
            if (this.fDocument != null) {
                Iterator e = this.fAnnotations.values().iterator();
                while (e.hasNext()) {
                    Position p = (Position)e.next();
                    this.fDocument.removePosition(p);
                }
                this.fDocument = null;
            }
        }
    }

    protected void fireModelChanged() {
        this.fireModelChanged(new AnnotationModelEvent(this));
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        ArrayList v = new ArrayList(this.fAnnotationModelListeners);
        Iterator e = ((AbstractList)v).iterator();
        while (e.hasNext()) {
            IAnnotationModelListener l = (IAnnotationModelListener)e.next();
            if (l instanceof IAnnotationModelListenerExtension) {
                ((IAnnotationModelListenerExtension)((Object)l)).modelChanged(event);
                continue;
            }
            l.modelChanged(this);
        }
    }

    protected void removeAnnotations(List annotations, boolean fireModelChanged, boolean modelInitiated) {
        if (annotations.size() > 0) {
            Iterator e = annotations.iterator();
            while (e.hasNext()) {
                this.removeAnnotation((Annotation)e.next(), false);
            }
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    protected void cleanup(boolean fireModelChanged) {
        if (this.fDocumentChanged) {
            this.fDocumentChanged = false;
            ArrayList<Annotation> deleted = new ArrayList<Annotation>();
            Iterator e = ((AbstractList)new ArrayList(this.fAnnotations.keySet())).iterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = (Position)this.fAnnotations.get(a);
                if (p != null && !p.isDeleted()) continue;
                deleted.add(a);
            }
            this.removeAnnotations(deleted, fireModelChanged, false);
        }
    }

    public Iterator getAnnotationIterator() {
        return this.getAnnotationIterator(true);
    }

    protected Iterator getAnnotationIterator(boolean cleanup) {
        if (cleanup) {
            this.cleanup(false);
        }
        Map map = this.fAnnotations;
        synchronized (map) {
            return ((AbstractList)new ArrayList(this.fAnnotations.keySet())).iterator();
        }
    }

    public Position getPosition(Annotation annotation) {
        return (Position)this.fAnnotations.get(annotation);
    }

    public void removeAllAnnotations() {
        this.removeAllAnnotations(true);
    }

    protected void removeAllAnnotations(boolean fireModelChanged) {
        if (this.fDocument != null) {
            Iterator e = this.fAnnotations.values().iterator();
            while (e.hasNext()) {
                Position p = (Position)e.next();
                this.fDocument.removePosition(p);
            }
        }
        this.fAnnotations.clear();
        if (fireModelChanged) {
            this.fireModelChanged();
        }
    }

    public void removeAnnotation(Annotation annotation) {
        this.removeAnnotation(annotation, true);
    }

    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        if (this.fAnnotations.containsKey(annotation)) {
            if (this.fDocument != null) {
                Position p = (Position)this.fAnnotations.get(annotation);
                this.fDocument.removePosition(p);
            }
            this.fAnnotations.remove(annotation);
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        ((AbstractCollection)this.fAnnotationModelListeners).remove(listener);
    }
}

