/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class AnnotationBarHoverManager
extends AbstractHoverInformationControlManager {
    private ISourceViewer fSourceViewer;
    private IVerticalRulerInfo fVerticalRulerInfo;
    private IAnnotationHover fAnnotationHover;

    public AnnotationBarHoverManager(ISourceViewer sourceViewer, IVerticalRuler ruler, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        this(ruler, sourceViewer, annotationHover, creator);
    }

    public AnnotationBarHoverManager(IVerticalRulerInfo rulerInfo, ISourceViewer sourceViewer, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        super(creator);
        Assert.isNotNull((Object)sourceViewer);
        Assert.isNotNull((Object)annotationHover);
        this.fSourceViewer = sourceViewer;
        this.fVerticalRulerInfo = rulerInfo;
        this.fAnnotationHover = annotationHover;
        this.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
        this.setMargins(5, 0);
    }

    protected void computeInformation() {
        Point location = this.getHoverEventLocation();
        int line = this.fVerticalRulerInfo.toDocumentLineNumber(location.y);
        this.setInformation(this.fAnnotationHover.getHoverInfo(this.fSourceViewer, line), this.computeArea(line));
    }

    private int getWidgetLineNumber(int line) throws BadLocationException {
        if (this.fSourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fSourceViewer);
            return extension.modelLine2WidgetLine(line);
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int firstLine = this.fSourceViewer.getDocument().getLineOfOffset(region.getOffset());
        return line - firstLine;
    }

    private Rectangle computeArea(int line) {
        try {
            StyledText text = this.fSourceViewer.getTextWidget();
            int lineHeight = text.getLineHeight();
            int y = this.getWidgetLineNumber(line) * lineHeight - text.getTopPixel();
            Point size = this.fVerticalRulerInfo.getControl().getSize();
            return new Rectangle(0, y, size.x, lineHeight);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected IAnnotationHover getAnnotationHover() {
        return this.fAnnotationHover;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fVerticalRulerInfo;
    }
}

