/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class Reconciler
extends AbstractReconciler {
    private Map fStrategies;

    public void setReconcilingStrategy(IReconcilingStrategy strategy, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap();
        }
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
            if (strategy instanceof IReconcilingStrategyExtension && this.getProgressMonitor() == null) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)strategy);
                extension.setProgressMonitor(this.getProgressMonitor());
            }
        }
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return (IReconcilingStrategy)this.fStrategies.get(contentType);
    }

    protected void process(DirtyRegion dirtyRegion) {
        DirtyRegion region = dirtyRegion;
        if (region == null) {
            region = new Region(0, this.getDocument().getLength());
        }
        TypedRegion[] regions = null;
        try {
            regions = this.getDocument().computePartitioning(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            regions = new TypedRegion[]{};
        }
        int i = 0;
        while (i < regions.length) {
            TypedRegion r = regions[i];
            IReconcilingStrategy s = this.getReconcilingStrategy(r.getType());
            if (s != null) {
                if (dirtyRegion != null) {
                    s.reconcile(dirtyRegion, (IRegion)r);
                } else {
                    s.reconcile((IRegion)r);
                }
            }
            ++i;
        }
    }

    protected void reconcilerDocumentChanged(IDocument document) {
        if (this.fStrategies != null) {
            Iterator e = this.fStrategies.values().iterator();
            while (e.hasNext()) {
                IReconcilingStrategy strategy = (IReconcilingStrategy)e.next();
                strategy.setDocument(document);
            }
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        if (this.fStrategies != null) {
            Iterator e = this.fStrategies.values().iterator();
            while (e.hasNext()) {
                IReconcilingStrategy strategy = (IReconcilingStrategy)e.next();
                if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)strategy);
                extension.setProgressMonitor(monitor);
            }
        }
    }

    protected void initialProcess() {
        Region region = new Region(0, this.getDocument().getLength());
        TypedRegion[] regions = null;
        try {
            regions = this.getDocument().computePartitioning(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            regions = new TypedRegion[]{};
        }
        int i = 0;
        while (i < regions.length) {
            TypedRegion r = regions[i];
            IReconcilingStrategy s = this.getReconcilingStrategy(r.getType());
            if (s instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension e = (IReconcilingStrategyExtension)((Object)s);
                e.initialReconcile();
            }
            ++i;
        }
    }
}

