/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.information;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class InformationPresenter
extends AbstractInformationControlManager
implements IInformationPresenter,
IWidgetTokenKeeper {
    private ITextViewer fTextViewer;
    private Map fProviders;
    private int fOffset = -1;

    public InformationPresenter(IInformationControlCreator creator) {
        super(creator);
        this.setCloser(new Closer());
        this.takesFocusWhenVisible(true);
    }

    public void setInformationProvider(IInformationProvider provider, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fProviders == null) {
            this.fProviders = new HashMap();
        }
        if (provider == null) {
            this.fProviders.remove(contentType);
        } else {
            this.fProviders.put(contentType, provider);
        }
    }

    public IInformationProvider getInformationProvider(String contentType) {
        if (this.fProviders == null) {
            return null;
        }
        return (IInformationProvider)this.fProviders.get(contentType);
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    protected void computeInformation() {
        int offset;
        int n = offset = this.fOffset < 0 ? this.fTextViewer.getSelectedRange().x : this.fOffset;
        if (offset == -1) {
            return;
        }
        this.fOffset = -1;
        IInformationProvider provider = null;
        try {
            IDocument document = this.fTextViewer.getDocument();
            String type = document.getContentType(offset);
            provider = this.getInformationProvider(type);
        }
        catch (BadLocationException badLocationException) {}
        if (provider == null) {
            return;
        }
        IRegion subject = provider.getSubject(this.fTextViewer, offset);
        if (subject == null) {
            return;
        }
        if (provider instanceof IInformationProviderExtension) {
            IInformationProviderExtension extension = (IInformationProviderExtension)((Object)provider);
            this.setInformation(extension.getInformation2(this.fTextViewer, subject), this.computeArea(subject));
        } else {
            this.setInformation(provider.getInformation(this.fTextViewer, subject), this.computeArea(subject));
        }
    }

    private Rectangle computeArea(IRegion region) {
        IRegion widgetRegion = this.modelRange2WidgetRange(region);
        int start = widgetRegion.getOffset();
        int end = widgetRegion.getOffset() + widgetRegion.getLength();
        StyledText styledText = this.fTextViewer.getTextWidget();
        Point upperLeft = styledText.getLocationAtOffset(start);
        Point lowerRight = new Point(upperLeft.x, upperLeft.y);
        int i = start + 1;
        while (i < end) {
            Point p = styledText.getLocationAtOffset(i);
            if (upperLeft.x > p.x) {
                upperLeft.x = p.x;
            }
            if (upperLeft.y > p.y) {
                upperLeft.y = p.y;
            }
            if (lowerRight.x < p.x) {
                lowerRight.x = p.x;
            }
            if (lowerRight.y < p.y) {
                lowerRight.y = p.y;
            }
            ++i;
        }
        GC gc = new GC((Drawable)styledText);
        lowerRight.x += gc.getFontMetrics().getAverageCharWidth();
        lowerRight.y += styledText.getLineHeight();
        gc.dispose();
        int width = lowerRight.x - upperLeft.x;
        int height = lowerRight.y - upperLeft.y;
        return new Rectangle(upperLeft.x, upperLeft.y, width, height);
    }

    private IRegion modelRange2WidgetRange(IRegion region) {
        if (this.fTextViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fTextViewer);
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = this.fTextViewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }

    public void install(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.install((Control)this.fTextViewer.getTextWidget());
    }

    public void uninstall() {
        this.dispose();
    }

    protected void showInformationControl(Rectangle subjectArea) {
        IWidgetTokenOwner owner;
        if (this.fTextViewer instanceof IWidgetTokenOwner && (owner = (IWidgetTokenOwner)((Object)this.fTextViewer)).requestWidgetToken(this)) {
            super.showInformationControl(subjectArea);
        }
    }

    protected void hideInformationControl() {
        block3: {
            try {
                super.hideInformationControl();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (this.fTextViewer instanceof IWidgetTokenOwner) {
                    IWidgetTokenOwner owner = (IWidgetTokenOwner)((Object)this.fTextViewer);
                    owner.releaseWidgetToken(this);
                }
                throw throwable;
            }
            Object var1_3 = null;
            if (!(this.fTextViewer instanceof IWidgetTokenOwner)) break block3;
            IWidgetTokenOwner owner = (IWidgetTokenOwner)((Object)this.fTextViewer);
            owner.releaseWidgetToken(this);
        }
    }

    protected void handleInformationControlDisposed() {
        block3: {
            try {
                super.handleInformationControlDisposed();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (this.fTextViewer instanceof IWidgetTokenOwner) {
                    IWidgetTokenOwner owner = (IWidgetTokenOwner)((Object)this.fTextViewer);
                    owner.releaseWidgetToken(this);
                }
                throw throwable;
            }
            Object var1_3 = null;
            if (!(this.fTextViewer instanceof IWidgetTokenOwner)) break block3;
            IWidgetTokenOwner owner = (IWidgetTokenOwner)((Object)this.fTextViewer);
            owner.releaseWidgetToken(this);
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        return false;
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    FocusListener,
    IViewportListener,
    KeyListener {
        private Control fSubjectControl;
        private IInformationControl fInformationControl;
        private boolean fIsActive = false;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
            this.fInformationControl = control;
        }

        public void start(Rectangle informationArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addFocusListener((FocusListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            if (this.fInformationControl != null) {
                this.fInformationControl.addFocusListener(this);
            }
            InformationPresenter.this.fTextViewer.addViewportListener(this);
        }

        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            InformationPresenter.this.fTextViewer.removeViewportListener(this);
            if (this.fInformationControl != null) {
                this.fInformationControl.removeFocusListener(this);
            }
            InformationPresenter.this.hideInformationControl();
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeFocusListener((FocusListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
        }

        public void controlResized(ControlEvent e) {
            this.stop();
        }

        public void controlMoved(ControlEvent e) {
            this.stop();
        }

        public void mouseDown(MouseEvent e) {
            this.stop();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.stop();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(this){
                private final /* synthetic */ Closer this$1;
                {
                    this.this$1 = closer;
                }

                public void run() {
                    if (Closer.access$0(this.this$1) == null || !Closer.access$0(this.this$1).isFocusControl()) {
                        this.this$1.stop();
                    }
                }
            });
        }

        public void viewportChanged(int topIndex) {
            this.stop();
        }

        public void keyPressed(KeyEvent e) {
            this.stop();
        }

        public void keyReleased(KeyEvent e) {
        }

        static /* synthetic */ IInformationControl access$0(Closer closer) {
            return closer.fInformationControl;
        }
    }
}

