/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class TextPresentation {
    private StyleRange fDefaultRange;
    private ArrayList fRanges;
    private IRegion fResultWindow;

    public static void applyTextPresentation(TextPresentation presentation, StyledText text) {
        StyleRange[] ranges = new StyleRange[presentation.getDenumerableRanges()];
        int i = 0;
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            ranges[i++] = (StyleRange)e.next();
        }
        text.setStyleRanges(ranges);
    }

    public TextPresentation() {
        this.fRanges = new ArrayList(50);
    }

    public TextPresentation(int sizeHint) {
        Assert.isTrue((sizeHint > 0 ? 1 : 0) != 0);
        this.fRanges = new ArrayList(sizeHint);
    }

    public void setResultWindow(IRegion resultWindow) {
        this.fResultWindow = resultWindow;
    }

    public void setDefaultStyleRange(StyleRange range) {
        this.fDefaultRange = range;
    }

    public StyleRange getDefaultStyleRange() {
        return this.createWindowRelativeRange(this.fResultWindow, this.fDefaultRange);
    }

    public void addStyleRange(StyleRange range) {
        this.checkConsistency(range);
        this.fRanges.add(range);
    }

    private void checkConsistency(StyleRange range) {
        if (range == null) {
            throw new IllegalArgumentException();
        }
        if (this.fDefaultRange != null) {
            int defaultEnd;
            int end;
            if (range.start < this.fDefaultRange.start) {
                range.start = this.fDefaultRange.start;
            }
            if ((end = range.start + range.length) > (defaultEnd = this.fDefaultRange.start + this.fDefaultRange.length)) {
                range.length -= defaultEnd - end;
            }
        }
    }

    private int getFirstIndexInWindow(IRegion window) {
        int i = 0;
        if (window != null) {
            int start = window.getOffset();
            while (i < this.fRanges.size()) {
                StyleRange r = (StyleRange)this.fRanges.get(i++);
                if (r.start + r.length <= start) continue;
                --i;
                break;
            }
        }
        return i;
    }

    private int getFirstIndexAfterWindow(IRegion window) {
        int i = this.fRanges.size();
        if (window != null) {
            int end = window.getOffset() + window.getLength();
            while (i > 0) {
                StyleRange r = (StyleRange)this.fRanges.get(--i);
                if (r.start >= end) continue;
                ++i;
                break;
            }
        }
        return i;
    }

    private StyleRange createWindowRelativeRange(IRegion window, StyleRange range) {
        int windowEnd;
        int rangeEnd;
        if (window == null || range == null) {
            return range;
        }
        int start = range.start - window.getOffset();
        if (start < 0) {
            start = 0;
        }
        int end = (rangeEnd = range.start + range.length) > (windowEnd = window.getOffset() + window.getLength()) ? windowEnd : rangeEnd;
        StyleRange newRange = (StyleRange)range.clone();
        newRange.start = start;
        newRange.length = (end -= window.getOffset()) - start;
        return newRange;
    }

    public Iterator getNonDefaultStyleRangeIterator() {
        return new FilterIterator(this.fDefaultRange != null);
    }

    public Iterator getAllStyleRangeIterator() {
        return new FilterIterator(false);
    }

    public boolean isEmpty() {
        return this.fDefaultRange == null && this.getDenumerableRanges() == 0;
    }

    public int getDenumerableRanges() {
        int size = this.getFirstIndexAfterWindow(this.fResultWindow) - this.getFirstIndexInWindow(this.fResultWindow);
        return size < 0 ? 0 : size;
    }

    public StyleRange getFirstStyleRange() {
        try {
            StyleRange range = (StyleRange)this.fRanges.get(this.getFirstIndexInWindow(this.fResultWindow));
            return this.createWindowRelativeRange(this.fResultWindow, range);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public StyleRange getLastStyleRange() {
        try {
            StyleRange range = (StyleRange)this.fRanges.get(this.getFirstIndexAfterWindow(this.fResultWindow) - 1);
            return this.createWindowRelativeRange(this.fResultWindow, range);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public IRegion getCoverage() {
        if (this.fDefaultRange != null) {
            StyleRange range = this.getDefaultStyleRange();
            return new Region(range.start, range.length);
        }
        StyleRange first = this.getFirstStyleRange();
        StyleRange last = this.getLastStyleRange();
        if (first == null || last == null) {
            return null;
        }
        return new Region(first.start, last.start - first.start + last.length);
    }

    public void clear() {
        this.fDefaultRange = null;
        this.fResultWindow = null;
        this.fRanges.clear();
    }

    class FilterIterator
    implements Iterator {
        protected int fIndex;
        protected int fLength;
        protected boolean fSkipDefaults;
        protected IRegion fWindow;

        protected FilterIterator(boolean skipDefaults) {
            this.fSkipDefaults = skipDefaults;
            this.fWindow = TextPresentation.this.fResultWindow;
            this.fIndex = TextPresentation.this.getFirstIndexInWindow(this.fWindow);
            this.fLength = TextPresentation.this.getFirstIndexAfterWindow(this.fWindow);
            if (this.fSkipDefaults) {
                this.computeIndex();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object next() {
            try {
                StyleRange styleRange;
                try {
                    StyleRange r = (StyleRange)TextPresentation.this.fRanges.get(this.fIndex++);
                    styleRange = TextPresentation.this.createWindowRelativeRange(this.fWindow, r);
                    Object var2_3 = null;
                    if (!this.fSkipDefaults) return styleRange;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
                this.computeIndex();
                return styleRange;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (!this.fSkipDefaults) throw throwable;
                this.computeIndex();
                throw throwable;
            }
        }

        public boolean hasNext() {
            return this.fIndex < this.fLength;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected boolean skip(Object o) {
            StyleRange r = (StyleRange)o;
            return r.similarTo(TextPresentation.this.fDefaultRange);
        }

        protected void computeIndex() {
            while (this.fIndex < this.fLength && this.skip(TextPresentation.this.fRanges.get(this.fIndex))) {
                ++this.fIndex;
            }
        }
    }
}

