/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class DefaultUndoManager
implements IUndoManager {
    private StringBuffer fTextBuffer = new StringBuffer();
    private StringBuffer fPreservedTextBuffer = new StringBuffer();
    private PretendedUndoManagerState fPretendedState = new PretendedUndoManagerState();
    private ITextListener fTextListener;
    private KeyAndMouseListener fKeyAndMouseListener;
    private boolean fInserting = false;
    private boolean fDeleting = false;
    private boolean fOverwriting = false;
    private boolean fFoldingIntoCompoundChange = false;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private List fCommandStack;
    private TextCommand fCurrent;
    private TextCommand fPreviousDelete;
    private int fCommandCounter = -1;

    public DefaultUndoManager(int undoLevel) {
        this.setMaximalUndoLevel(undoLevel);
    }

    public void beginCompoundChange() {
        this.fFoldingIntoCompoundChange = true;
        this.commit();
    }

    public void endCompoundChange() {
        this.fFoldingIntoCompoundChange = false;
        this.commit();
    }

    private void addListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            text.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            text.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(true);
        }
    }

    private void removeListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && this.fKeyAndMouseListener != null) {
            text.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
            text.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(false);
        }
    }

    private void listenToTextChanges(boolean listen) {
        if (listen && this.fTextListener == null) {
            this.fTextListener = new TextListener();
            this.fTextViewer.addTextListener(this.fTextListener);
        } else if (!listen && this.fTextListener != null) {
            this.fTextViewer.removeTextListener(this.fTextListener);
            this.fTextListener = null;
        }
    }

    private void commit() {
        this.fInserting = false;
        this.fDeleting = false;
        this.fOverwriting = false;
        this.fPreviousDelete.reinitialize();
        this.fCurrent.commit();
    }

    private void internalRedo() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            ++this.fCommandCounter;
            TextCommand cmd = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            this.listenToTextChanges(false);
            cmd.redo(text);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private void internalUndo() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            TextCommand cmd = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            --this.fCommandCounter;
            this.listenToTextChanges(false);
            cmd.undo(text);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private boolean isWhitespaceText(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
        int index = TextUtilities.startsWith((String[])delimiters, (String)text);
        if (index > -1) {
            int length = text.length();
            int i = delimiters[index].length();
            while (i < length) {
                char c = text.charAt(i);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private PretendedUndoManagerState pretendCommit() {
        if (this.fCurrent.fStart < 0) {
            this.fPretendedState.stackSize = this.fCommandStack.size();
            this.fPretendedState.cmdCounter = this.fCommandCounter;
        } else {
            int sz = Math.max(this.fCommandCounter, 0) + 1;
            if (sz > this.fUndoLevel) {
                sz -= this.fUndoLevel;
            }
            this.fPretendedState.stackSize = sz;
            this.fPretendedState.cmdCounter = sz - 1;
        }
        return this.fPretendedState;
    }

    private void processTextEvent(TextEvent e) {
        int start = e.getOffset();
        int end = e.getOffset() + e.getLength();
        String newText = e.getText();
        String oldText = e.getReplacedText();
        if (newText == null) {
            newText = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        int length = newText.length();
        int diff = end - start;
        if (diff < 0) {
            int tmp = end;
            end = start;
            start = tmp;
            diff = -diff;
        }
        if (start == end) {
            if (length == 1 || this.isWhitespaceText(newText)) {
                if (!this.fInserting || start != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.commit();
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = start;
                }
                if (length > 0) {
                    this.fTextBuffer.append(newText);
                }
            } else if (length > 0) {
                this.commit();
                this.fCurrent.fStart = this.fCurrent.fEnd = start;
                this.fTextBuffer.append(newText);
                this.commit();
            }
        } else if (length == 0) {
            length = oldText.length();
            String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
            if (length == 1 || TextUtilities.equals((String[])delimiters, (String)oldText) > -1) {
                if (this.fPreviousDelete.fStart == start && this.fPreviousDelete.fEnd == end) {
                    if (this.fCurrent.fStart == end && this.fCurrent.fEnd == start) {
                        this.fCurrent.fStart = start;
                        this.fCurrent.fEnd = end;
                    }
                    this.fPreservedTextBuffer.append(oldText);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == end) {
                    this.fPreservedTextBuffer.insert(0, oldText);
                    this.fCurrent.fStart = start;
                } else {
                    this.commit();
                    this.fDeleting = true;
                    this.fPreservedTextBuffer.append(oldText);
                    this.fCurrent.fStart = start;
                    this.fCurrent.fEnd = end;
                }
                this.fPreviousDelete.set(start, end);
            } else if (length > 0) {
                this.commit();
                this.fCurrent.fStart = start;
                this.fCurrent.fEnd = end;
                this.fPreservedTextBuffer.append(oldText);
            }
        } else {
            if (length == 1) {
                length = oldText.length();
                String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
                if (length == 1 || TextUtilities.equals((String[])delimiters, (String)oldText) > -1) {
                    if (!this.fOverwriting || start != this.fCurrent.fStart + this.fTextBuffer.length()) {
                        this.commit();
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = start;
                    }
                    this.fCurrent.fEnd = end;
                    this.fTextBuffer.append(newText);
                    this.fPreservedTextBuffer.append(oldText);
                    return;
                }
            }
            this.commit();
            this.fCurrent.fStart = start;
            this.fCurrent.fEnd = end;
            this.fTextBuffer.append(newText);
            this.fPreservedTextBuffer.append(oldText);
        }
    }

    public void setMaximalUndoLevel(int undoLevel) {
        this.fUndoLevel = undoLevel;
    }

    public void connect(ITextViewer textViewer) {
        if (this.fTextViewer == null) {
            this.fTextViewer = textViewer;
            this.fCommandStack = new ArrayList();
            this.fCurrent = new TextCommand();
            this.fPreviousDelete = new TextCommand();
            this.addListeners();
        }
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fCurrent = null;
            if (this.fCommandStack != null) {
                this.fCommandStack.clear();
                this.fCommandStack = null;
            }
            this.fTextBuffer = null;
            this.fPreservedTextBuffer = null;
            this.fTextViewer = null;
        }
    }

    public void reset() {
        if (this.fCommandStack != null) {
            this.fCommandStack.clear();
        }
        this.fCommandCounter = -1;
        if (this.fCurrent != null) {
            this.fCurrent.reinitialize();
        }
        this.fFoldingIntoCompoundChange = false;
        this.fInserting = false;
        this.fDeleting = false;
        this.fOverwriting = false;
        this.fTextBuffer.setLength(0);
        this.fPreservedTextBuffer.setLength(0);
    }

    public boolean redoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState s = this.pretendCommit();
            return s.cmdCounter + 1 >= 0 && s.cmdCounter + 1 < s.stackSize;
        }
        return false;
    }

    public boolean undoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState s = this.pretendCommit();
            return s.cmdCounter >= 0 && s.cmdCounter < s.stackSize;
        }
        return false;
    }

    public void redo() {
        if (this.redoable()) {
            this.commit();
            this.internalRedo();
        }
    }

    public void undo() {
        if (this.undoable()) {
            this.fFoldingIntoCompoundChange = false;
            this.commit();
            this.internalUndo();
        }
    }

    class TextCommand {
        protected int fStart = -1;
        protected int fEnd = -1;
        protected String fText;
        protected String fPreservedText;

        TextCommand() {
        }

        protected void reinitialize() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
        }

        protected void set(int start, int end) {
            this.fStart = start;
            this.fEnd = end;
            this.fText = null;
            this.fPreservedText = null;
        }

        protected void undoTextChange(StyledText text) {
            text.replaceTextRange(this.fStart, this.fText.length(), this.fPreservedText);
        }

        protected void undo(StyledText text) {
            this.undoTextChange(text);
            IRegion modelRange = this.widgetRange2ModelRange(this.fStart, this.fPreservedText == null ? 0 : this.fPreservedText.length());
            DefaultUndoManager.this.fTextViewer.setSelectedRange(modelRange.getOffset(), modelRange.getLength());
            DefaultUndoManager.this.fTextViewer.revealRange(modelRange.getOffset(), modelRange.getLength());
        }

        protected void redoTextChange(StyledText text) {
            text.replaceTextRange(this.fStart, this.fEnd - this.fStart, this.fText);
        }

        protected void redo(StyledText text) {
            this.redoTextChange(text);
            IRegion modelRange = this.widgetRange2ModelRange(this.fStart, this.fText == null ? 0 : this.fText.length());
            DefaultUndoManager.this.fTextViewer.setSelectedRange(modelRange.getOffset(), modelRange.getLength());
            DefaultUndoManager.this.fTextViewer.revealRange(modelRange.getOffset(), modelRange.getLength());
        }

        protected IRegion widgetRange2ModelRange(int offset, int length) {
            if (DefaultUndoManager.this.fTextViewer instanceof ITextViewerExtension3) {
                ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)DefaultUndoManager.this.fTextViewer);
                return extension.widgetRange2ModelRange((IRegion)new Region(offset, length));
            }
            IRegion visible = DefaultUndoManager.this.fTextViewer.getVisibleRegion();
            return new Region(offset + visible.getOffset(), length);
        }

        protected void updateCommandStack() {
            int length = DefaultUndoManager.this.fCommandStack.size();
            int i = DefaultUndoManager.this.fCommandCounter + 1;
            while (i < length) {
                DefaultUndoManager.this.fCommandStack.remove(DefaultUndoManager.this.fCommandCounter + 1);
                ++i;
            }
            DefaultUndoManager.this.fCommandStack.add(this);
            while (DefaultUndoManager.this.fCommandStack.size() > DefaultUndoManager.this.fUndoLevel) {
                DefaultUndoManager.this.fCommandStack.remove(0);
            }
            DefaultUndoManager.this.fCommandCounter = DefaultUndoManager.this.fCommandStack.size() - 1;
        }

        protected TextCommand createCurrent() {
            return DefaultUndoManager.this.fFoldingIntoCompoundChange ? new CompoundTextCommand() : new TextCommand();
        }

        protected void commit() {
            if (this.fStart < 0) {
                this.reinitialize();
            } else {
                this.fText = DefaultUndoManager.this.fTextBuffer.toString();
                DefaultUndoManager.this.fTextBuffer.setLength(0);
                this.fPreservedText = DefaultUndoManager.this.fPreservedTextBuffer.toString();
                DefaultUndoManager.this.fPreservedTextBuffer.setLength(0);
                this.updateCommandStack();
            }
            DefaultUndoManager.this.fCurrent = this.createCurrent();
        }
    }

    class CompoundTextCommand
    extends TextCommand {
        private List fCommands = new ArrayList();

        CompoundTextCommand() {
        }

        protected void add(TextCommand command) {
            this.fCommands.add(command);
        }

        protected void undo(StyledText text) {
            block7: {
                ITextViewerExtension extension = null;
                if (DefaultUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                    extension = (ITextViewerExtension)((Object)DefaultUndoManager.this.fTextViewer);
                }
                if (extension != null) {
                    extension.setRedraw(false);
                }
                try {
                    int size = this.fCommands.size();
                    if (size > 0) {
                        TextCommand c;
                        int i = size - 1;
                        while (i > 0) {
                            c = (TextCommand)this.fCommands.get(i);
                            c.undoTextChange(text);
                            --i;
                        }
                        c = (TextCommand)this.fCommands.get(0);
                        c.undo(text);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (extension != null) {
                        extension.setRedraw(true);
                    }
                    throw throwable;
                }
                Object var6_8 = null;
                if (extension == null) break block7;
                extension.setRedraw(true);
            }
        }

        protected void redo(StyledText text) {
            block7: {
                ITextViewerExtension extension = null;
                if (DefaultUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                    extension = (ITextViewerExtension)((Object)DefaultUndoManager.this.fTextViewer);
                }
                if (extension != null) {
                    extension.setRedraw(false);
                }
                try {
                    int size = this.fCommands.size();
                    if (size > 0) {
                        TextCommand c;
                        int i = 0;
                        while (i < size - 1) {
                            c = (TextCommand)this.fCommands.get(i);
                            c.redoTextChange(text);
                            ++i;
                        }
                        c = (TextCommand)this.fCommands.get(size - 1);
                        c.redo(text);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (extension != null) {
                        extension.setRedraw(true);
                    }
                    throw throwable;
                }
                Object var6_8 = null;
                if (extension == null) break block7;
                extension.setRedraw(true);
            }
        }

        protected void updateCommandStack() {
            TextCommand c = new TextCommand();
            c.fStart = this.fStart;
            c.fEnd = this.fEnd;
            c.fText = this.fText;
            c.fPreservedText = this.fPreservedText;
            this.add(c);
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
            }
        }

        protected TextCommand createCurrent() {
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                return new TextCommand();
            }
            this.reinitialize();
            return this;
        }

        protected void commit() {
            if (this.fStart < 0 && this.fCommands.size() > 0 && !DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
                DefaultUndoManager.this.fCurrent = this.createCurrent();
                return;
            }
            super.commit();
        }
    }

    class PretendedUndoManagerState {
        protected int cmdCounter = -1;
        protected int stackSize = -1;

        PretendedUndoManagerState() {
        }
    }

    class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                DefaultUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    DefaultUndoManager.this.commit();
                }
            }
        }
    }

    class TextListener
    implements ITextListener {
        TextListener() {
        }

        public void textChanged(TextEvent e) {
            if (e.getDocumentEvent() != null) {
                DefaultUndoManager.this.processTextEvent(e);
            }
        }
    }
}

