/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractInformationControlManager {
    private static final Anchor[] ANCHORS = new Anchor[]{new Anchor(), new Anchor(), new Anchor(), new Anchor()};
    public static final Anchor ANCHOR_TOP = ANCHORS[0];
    public static final Anchor ANCHOR_BOTTOM = ANCHORS[1];
    public static final Anchor ANCHOR_LEFT = ANCHORS[2];
    public static final Anchor ANCHOR_RIGHT = ANCHORS[3];
    public static final Anchor ANCHOR_GLOBAL = new Anchor();
    private Control fSubjectControl;
    private Rectangle fSubjectArea;
    private Object fInformation;
    private boolean fTakesFocusWhenVisible = false;
    private IInformationControl fInformationControl;
    private IInformationControlCreator fInformationControlCreator;
    private IInformationControlCloser fInformationControlCloser;
    private boolean fDisposed = false;
    private boolean fEnabled = false;
    private Point fSizeConstraints;
    private int fMarginY = 5;
    private int fMarginX = 5;
    private int fWidthConstraint = 60;
    private int fHeightConstraint = 6;
    private boolean fEnforceAsMinimalSize = false;
    private boolean fEnforceAsMaximalSize = false;
    private Anchor fAnchor = ANCHOR_BOTTOM;
    private Anchor[] fFallbackAnchors = ANCHORS;

    protected AbstractInformationControlManager(IInformationControlCreator creator) {
        Assert.isNotNull((Object)creator);
        this.fInformationControlCreator = creator;
    }

    protected abstract void computeInformation();

    protected final void setInformation(String information, Rectangle subjectArea) {
        this.fInformation = information;
        this.fSubjectArea = subjectArea;
        this.presentInformation();
    }

    protected final void setInformation(Object information, Rectangle subjectArea) {
        this.fInformation = information;
        this.fSubjectArea = subjectArea;
        this.presentInformation();
    }

    protected void setCloser(IInformationControlCloser closer) {
        this.fInformationControlCloser = closer;
    }

    public void setMargins(int xMargin, int yMargin) {
        this.fMarginX = xMargin;
        this.fMarginY = yMargin;
    }

    public void setSizeConstraints(int widthInChar, int heightInChar, boolean enforceAsMinimalSize, boolean enforceAsMaximalSize) {
        this.fSizeConstraints = null;
        this.fWidthConstraint = widthInChar;
        this.fHeightConstraint = heightInChar;
        this.fEnforceAsMinimalSize = enforceAsMinimalSize;
        this.fEnforceAsMaximalSize = enforceAsMaximalSize;
    }

    public void setAnchor(Anchor anchor) {
        this.fAnchor = anchor;
    }

    public void setFallbackAnchors(Anchor[] fallbackAnchors) {
        this.fFallbackAnchors = fallbackAnchors;
    }

    public void takesFocusWhenVisible(boolean takesFocus) {
        this.fTakesFocusWhenVisible = takesFocus;
    }

    protected void handleSubjectControlDisposed() {
        this.disposeInformationControl();
    }

    public void install(Control subjectControl) {
        this.fSubjectControl = subjectControl;
        if (this.fSubjectControl != null) {
            this.fSubjectControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractInformationControlManager.this.handleSubjectControlDisposed();
                }
            });
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setSubjectControl(subjectControl);
        }
        this.setEnabled(true);
    }

    protected Control getSubjectControl() {
        return this.fSubjectControl;
    }

    protected Rectangle getSubjectArea() {
        return this.fSubjectArea;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    protected boolean isEnabled() {
        return this.fEnabled;
    }

    protected Point computeSizeConstraints(Control subjectControl, IInformationControl informationControl) {
        if (this.fSizeConstraints == null) {
            if (subjectControl == null) {
                return null;
            }
            GC gc = new GC((Drawable)subjectControl);
            gc.setFont(subjectControl.getFont());
            int width = gc.getFontMetrics().getAverageCharWidth();
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            this.fSizeConstraints = new Point(this.fWidthConstraint * width, this.fHeightConstraint * height);
        }
        return this.fSizeConstraints;
    }

    protected void handleInformationControlDisposed() {
        this.fInformationControl = null;
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setInformationControl(null);
            this.fInformationControlCloser.stop();
        }
    }

    protected IInformationControl getInformationControl() {
        if (this.fInformationControl == null && !this.fDisposed) {
            this.fInformationControl = this.fInformationControlCreator.createInformationControl(this.fSubjectControl.getShell());
            this.fInformationControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractInformationControlManager.this.handleInformationControlDisposed();
                }
            });
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.setInformationControl(this.fInformationControl);
            }
        }
        return this.fInformationControl;
    }

    protected Point computeLocation(Rectangle subjectArea, Point controlSize, Anchor anchor) {
        if (ANCHOR_GLOBAL == anchor) {
            Point subjectControlSize = this.fSubjectControl.getSize();
            Point location = new Point(subjectControlSize.x / 2, subjectControlSize.y / 2);
            location.x -= controlSize.x / 2;
            location.y -= controlSize.y / 2;
            return this.fSubjectControl.toDisplay(location);
        }
        int xShift = 0;
        int yShift = 0;
        if (ANCHOR_BOTTOM == anchor) {
            xShift = this.fMarginX;
            yShift = subjectArea.height + this.fMarginY;
        } else if (ANCHOR_RIGHT == anchor) {
            xShift = this.fMarginX + subjectArea.width;
            yShift = this.fMarginY;
        } else if (ANCHOR_TOP == anchor) {
            xShift = this.fMarginX;
            yShift = -controlSize.y - this.fMarginY;
        } else if (ANCHOR_LEFT == anchor) {
            xShift = -controlSize.x - this.fMarginX;
            yShift = this.fMarginY;
        }
        return this.fSubjectControl.toDisplay(new Point(subjectArea.x + xShift, subjectArea.y + yShift));
    }

    protected boolean updateLocation(Point location, Point size, Rectangle displayArea, Anchor anchor) {
        int displayLowerRightX = displayArea.x + displayArea.width;
        int displayLowerRightY = displayArea.y + displayArea.height;
        int lowerRightX = location.x + size.x;
        int lowerRightY = location.y + size.y;
        if (ANCHOR_BOTTOM == anchor || ANCHOR_TOP == anchor) {
            if (ANCHOR_BOTTOM == anchor ? lowerRightY > displayLowerRightY : location.y < displayArea.y) {
                return false;
            }
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            return location.x >= 0 && location.y >= 0;
        }
        if (ANCHOR_RIGHT == anchor || ANCHOR_LEFT == anchor) {
            if (ANCHOR_RIGHT == anchor ? lowerRightX > displayLowerRightX : location.x < displayArea.x) {
                return false;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= 0 && location.y >= 0;
        }
        if (ANCHOR_GLOBAL == anchor) {
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= 0 && location.y >= 0;
        }
        return false;
    }

    protected Anchor getNextFallbackAnchor(Anchor anchor) {
        if (anchor == null || this.fFallbackAnchors == null) {
            return null;
        }
        int i = 0;
        while (i < this.fFallbackAnchors.length) {
            if (this.fFallbackAnchors[i] == anchor) {
                return this.fFallbackAnchors[i + 1 == this.fFallbackAnchors.length ? 0 : i + 1];
            }
            ++i;
        }
        return null;
    }

    protected Point computeInformationControlLocation(Rectangle subjectArea, Point controlSize) {
        Point upperLeft;
        Rectangle displayBounds = this.fSubjectControl.getDisplay().getClientArea();
        Anchor testAnchor = this.fAnchor;
        while (!this.updateLocation(upperLeft = this.computeLocation(subjectArea, controlSize, testAnchor), controlSize, displayBounds, testAnchor) && (testAnchor = this.getNextFallbackAnchor(testAnchor)) != this.fAnchor && testAnchor != null) {
        }
        return upperLeft;
    }

    public void showInformation() {
        if (this.fEnabled) {
            this.doShowInformation();
        }
    }

    protected void doShowInformation() {
        this.fSubjectArea = null;
        this.fInformation = null;
        this.computeInformation();
    }

    protected void presentInformation() {
        boolean hasContents = false;
        if (this.fInformation instanceof String) {
            hasContents = ((String)this.fInformation).trim().length() > 0;
        } else {
            boolean bl = hasContents = this.fInformation != null;
        }
        if (this.fSubjectArea != null && hasContents) {
            this.internalShowInformationControl(this.fSubjectArea, this.fInformation);
        } else {
            this.hideInformationControl();
        }
    }

    private void internalShowInformationControl(Rectangle subjectArea, Object information) {
        IInformationControl informationControl = this.getInformationControl();
        if (informationControl != null) {
            IInformationControlExtension extension;
            Point sizeConstraints = this.computeSizeConstraints(this.fSubjectControl, informationControl);
            informationControl.setSizeConstraints(sizeConstraints.x, sizeConstraints.y);
            if (informationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)((Object)informationControl)).setInput(information);
            } else {
                informationControl.setInformation(information.toString());
            }
            if (informationControl instanceof IInformationControlExtension && !(extension = (IInformationControlExtension)((Object)informationControl)).hasContents()) {
                return;
            }
            Point size = informationControl.computeSizeHint();
            if (this.fEnforceAsMinimalSize) {
                if (size.x < sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y < sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            if (this.fEnforceAsMaximalSize) {
                if (size.x > sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y > sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            informationControl.setSize(size.x, size.y);
            Point location = this.computeInformationControlLocation(subjectArea, size);
            informationControl.setLocation(location);
            this.showInformationControl(subjectArea);
        }
    }

    protected void hideInformationControl() {
        if (this.fInformationControl != null) {
            this.fInformationControl.setVisible(false);
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.stop();
            }
        }
    }

    protected void showInformationControl(Rectangle subjectArea) {
        this.fInformationControl.setVisible(true);
        if (this.fTakesFocusWhenVisible) {
            this.fInformationControl.setFocus();
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.start(subjectArea);
        }
    }

    public void disposeInformationControl() {
        if (this.fInformationControl != null) {
            this.fInformationControl.dispose();
            this.handleInformationControlDisposed();
        }
    }

    public void dispose() {
        if (!this.fDisposed) {
            this.fDisposed = true;
            this.setEnabled(false);
            this.disposeInformationControl();
            this.fInformationControlCreator = null;
            this.fInformationControlCloser = null;
        }
    }

    public static interface IInformationControlCloser {
        public void setSubjectControl(Control var1);

        public void setInformationControl(IInformationControl var1);

        public void start(Rectangle var1);

        public void stop();
    }

    public static final class Anchor {
        private Anchor() {
        }
    }
}

