/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractHoverInformationControlManager
extends AbstractInformationControlManager {
    private MouseTracker fMouseTracker = new MouseTracker();
    private Point fHoverEventLocation = new Point(-1, -1);
    private int fHoverEventStateMask = 0;

    protected AbstractHoverInformationControlManager(IInformationControlCreator creator) {
        super(creator);
        this.setCloser(new Closer());
    }

    protected void presentInformation() {
        if (this.fMouseTracker == null) {
            super.presentInformation();
            return;
        }
        Rectangle area = this.getSubjectArea();
        if (area != null) {
            this.fMouseTracker.setSubjectArea(area);
        }
        if (this.fMouseTracker.isMouseLost()) {
            this.fMouseTracker.computationCompleted();
            this.fMouseTracker.deactivate();
        } else {
            this.fMouseTracker.computationCompleted();
            super.presentInformation();
        }
    }

    public void setEnabled(boolean enabled) {
        boolean was = this.isEnabled();
        super.setEnabled(enabled);
        boolean is = this.isEnabled();
        if (was != is && this.fMouseTracker != null) {
            if (is) {
                this.fMouseTracker.start(this.getSubjectControl());
            } else {
                this.fMouseTracker.stop();
            }
        }
    }

    public void dispose() {
        if (this.fMouseTracker != null) {
            this.fMouseTracker.stop();
            this.fMouseTracker.fSubjectControl = null;
            this.fMouseTracker = null;
        }
        super.dispose();
    }

    protected Point getHoverEventLocation() {
        return this.fHoverEventLocation;
    }

    protected int getHoverEventStateMask() {
        return this.fHoverEventStateMask;
    }

    class Closer
    extends MouseTrackAdapter
    implements AbstractInformationControlManager.IInformationControlCloser,
    MouseListener,
    MouseMoveListener,
    ControlListener,
    KeyListener {
        private Control fSubjectControl;
        private IInformationControl fInformationControl;
        private Rectangle fSubjectArea;
        private boolean fIsActive = false;

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
            this.fInformationControl = control;
        }

        public void start(Rectangle subjectArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            this.fSubjectArea = subjectArea;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.addMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
        }

        public void stop() {
            this.stop(false);
        }

        protected void stop(boolean delayRestart) {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            AbstractHoverInformationControlManager.this.hideInformationControl();
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.removeMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
        }

        public void mouseMove(MouseEvent event) {
            if (!this.fSubjectArea.contains(event.x, event.y)) {
                this.stop();
            }
        }

        public void mouseUp(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            this.stop();
        }

        public void mouseDoubleClick(MouseEvent event) {
            this.stop();
        }

        public void mouseExit(MouseEvent event) {
            this.stop();
        }

        public void controlResized(ControlEvent event) {
            this.stop();
        }

        public void controlMoved(ControlEvent event) {
            this.stop();
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            this.stop(true);
        }
    }

    class MouseTracker
    extends ShellAdapter
    implements MouseTrackListener,
    MouseMoveListener {
        private static final int EPSILON = 3;
        private Rectangle fHoverArea;
        private Rectangle fSubjectArea;
        private Control fSubjectControl;
        private boolean fIsInRestartMode = false;
        private boolean fIsComputing = false;
        private boolean fMouseLostWhileComputing = false;
        private boolean fShellDeactivatedWhileComputing = false;

        public void setSubjectArea(Rectangle subjectArea) {
            Assert.isNotNull((Object)subjectArea);
            this.fSubjectArea = subjectArea;
        }

        public void start(Control subjectControl) {
            this.fSubjectControl = subjectControl;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseTrackListener((MouseTrackListener)this);
            }
            this.fIsInRestartMode = false;
            this.fIsComputing = false;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
        }

        public void stop() {
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().removeShellListener((ShellListener)this);
            }
        }

        public void mouseHover(MouseEvent event) {
            if (this.fIsComputing || this.fIsInRestartMode) {
                return;
            }
            this.fIsInRestartMode = true;
            this.fIsComputing = true;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
            AbstractHoverInformationControlManager.this.fHoverEventStateMask = event.stateMask;
            AbstractHoverInformationControlManager.this.fHoverEventLocation = new Point(event.x, event.y);
            this.fHoverArea = new Rectangle(event.x - 3, event.y - 3, 6, 6);
            if (this.fHoverArea.x < 0) {
                this.fHoverArea.x = 0;
            }
            if (this.fHoverArea.y < 0) {
                this.fHoverArea.y = 0;
            }
            this.setSubjectArea(this.fHoverArea);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().addShellListener((ShellListener)this);
            }
            AbstractHoverInformationControlManager.this.doShowInformation();
        }

        protected void deactivate() {
            if (this.fIsComputing) {
                return;
            }
            this.fIsInRestartMode = false;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().removeShellListener((ShellListener)this);
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            this.fMouseLostWhileComputing = true;
            this.deactivate();
        }

        public void mouseMove(MouseEvent event) {
            if (!this.fSubjectArea.contains(event.x, event.y)) {
                this.deactivate();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            this.fShellDeactivatedWhileComputing = true;
            this.deactivate();
        }

        public void shellIconified(ShellEvent e) {
            this.fShellDeactivatedWhileComputing = true;
            this.deactivate();
        }

        public void computationCompleted() {
            this.fIsComputing = false;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
        }

        public boolean isMouseLost() {
            if (this.fMouseLostWhileComputing || this.fShellDeactivatedWhileComputing) {
                return true;
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                Display display = this.fSubjectControl.getDisplay();
                Point p = display.getCursorLocation();
                if (!this.fSubjectArea.contains(p = this.fSubjectControl.toControl(p)) && !this.fHoverArea.contains(p)) {
                    return true;
                }
            }
            return false;
        }
    }
}

