/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import java.security.spec.AlgorithmParameterSpec;

public class SharedInfoParameterSpec
implements AlgorithmParameterSpec {
    private byte[][] a = null;

    public SharedInfoParameterSpec(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        this.a = new byte[byArray.length][];
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != null) {
                this.a[n] = new byte[byArray[n].length];
                System.arraycopy(byArray[n], 0, this.a[n], 0, byArray[n].length);
            }
            ++n;
        }
    }

    public SharedInfoParameterSpec(byte[][] byArray, int[] nArray, int[] nArray2) {
        if (byArray == null || nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        if (byArray.length != nArray.length || nArray.length != nArray2.length) {
            throw new IllegalArgumentException("different length arguments");
        }
        this.a = new byte[byArray.length][];
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != null) {
                if (nArray[n] + nArray2[n] > byArray[n].length) {
                    throw new IllegalArgumentException("wrong length arguments.");
                }
                this.a[n] = new byte[byArray[n].length];
                System.arraycopy(byArray[n], nArray[n], this.a[n], 0, nArray2[n]);
            }
            ++n;
        }
    }

    public byte[][] getSharedInfo() {
        byte[][] byArray = new byte[this.a.length][];
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n] != null) {
                byArray[n] = new byte[this.a[n].length];
                System.arraycopy(this.a[n], 0, byArray[n], 0, byArray[n].length);
            }
            ++n;
        }
        return byArray;
    }

    public byte[] getSharedInfo(int n) {
        if (n < 0 || n > this.a.length) {
            throw new IllegalArgumentException("index incorrect.");
        }
        if (this.a[n] == null) {
            return null;
        }
        byte[] byArray = new byte[this.a[n].length];
        System.arraycopy(this.a[n], 0, byArray, 0, byArray.length);
        return byArray;
    }
}

