/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.Mod;
import com.certicom.ecc.ModFactory;
import com.certicom.ecc.UnsupportedModException;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;
import java.util.Random;

public final class IDLCKeyGen
extends CryptoTransform {
    private ModFactory ag = null;
    private Mod ae = null;
    private int af = 0;

    public IDLCKeyGen() {
        super("IDLCKeyGen");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n, objectArray, random);
        if (n != 5 || random == null || objectArray == null || objectArray.length != 3) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        byte[] byArray = (byte[])objectArray[0];
        byte[] byArray2 = (byte[])objectArray[1];
        byte[] byArray3 = (byte[])objectArray[2];
        this.a(byArray, byArray2, byArray3);
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            this.ae = ModFactory.do(byArray).a(byArray3);
            this.ag = ModFactory.do(byArray2);
            this.af = byArray2.length;
        }
        catch (UnsupportedModException unsupportedModException) {
            System.out.println(Conversion.OS2Hex(byArray, 8));
            System.out.println(Conversion.OS2Hex(byArray2, 8));
            unsupportedModException.printStackTrace();
            throw new IllegalStateException("cannot do cryptography.");
        }
    }

    public int outputSize(int n, boolean bl) {
        return 0;
    }

    public void reset() {
        super.reset();
        this.ag = null;
        this.ae = null;
        this.af = 0;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.rnd == null || this.ae == null || this.ag == null) {
            throw new IllegalStateException("no rnd or parameters");
        }
        byte[] byArray2 = new byte[2 * this.af];
        this.rnd.nextBytes(byArray2);
        byArray2 = this.ag.a(byArray2).int();
        Mod mod = this.ae.a(new BigInteger(1, byArray2));
        byte[] byArray3 = mod.int();
        return new Object[]{byArray2, byArray3};
    }
}

