/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.util.Random;

public final class HMAC
extends CryptoTransform {
    private CryptoTransform aj;
    private byte[] ai;
    private byte[] ak;
    private boolean ah;

    public HMAC() {
        super("HMAC");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        try {
            super.init(n, objectArray, random);
            this.aj = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[0]);
            this.aj.init(5, null, random);
            int n2 = this.aj.inputSize();
            byte[] byArray = (byte[])objectArray[1];
            if (byArray.length > n2) {
                byArray = this.aj.transform(byArray, 0, byArray.length, true);
                this.aj.init(5, null, random);
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.ai = new byte[n2];
            this.ak = new byte[n2];
            int n3 = 0;
            while (n3 < this.ai.length) {
                this.ai[n3] = (byte)(0x36 ^ byArray2[n3]);
                this.ak[n3] = (byte)(0x5C ^ byArray2[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            this.reset();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode");
        }
        return this.aj.outputSize(n, bl);
    }

    public void reset() {
        super.reset();
        this.aj = null;
        this.ai = null;
        this.ak = null;
        this.ah = false;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode");
        }
        if (!this.ah) {
            this.aj.transform(this.ai, 0, this.ai.length, false);
            this.ah = true;
        }
        if (byArray != null) {
            this.aj.transform(byArray, n, n2, false);
        }
        if (bl) {
            byte[] byArray3 = this.aj.transform(null, 0, 0, true);
            this.aj.init(5, null, this.rnd);
            this.aj.transform(this.ak, 0, this.ak.length, false);
            int n4 = this.aj.transform(byArray3, 0, byArray3.length, byArray2, n3, true);
            this.aj.reset();
            this.aj.init(5, null, this.rnd);
            this.ah = false;
            return n4;
        }
        return 0;
    }
}

