/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ExportLevel;
import com.certicom.ecc.system.SystemConfig;
import java.util.Random;

public abstract class ECTransform
extends CryptoTransform {
    protected int h;
    protected int f;
    protected int g;

    protected ECTransform(String string) {
        super(string);
        SystemConfig systemConfig = SystemConfig.getConfig();
        this.h = systemConfig.getFormat();
        this.f = systemConfig.getConformance();
        this.g = systemConfig.getPtCompression();
    }

    private static int a(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        if (n == byArray.length) {
            return 0;
        }
        int n2 = (byArray.length - n - 1) * 8;
        int n3 = 7;
        do {
            if ((byArray[n] >>> n3 & 1) != 1) continue;
            n2 += n3 + 1;
            break;
        } while (--n3 >= 0);
        return n2;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        super.init(n, objectArray, random);
        ECParams eCParams = null;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof ECKey) {
                eCParams = ((ECKey)objectArray[n2]).getECParams();
            } else if (objectArray[n2] instanceof ECParams) {
                eCParams = (ECParams)objectArray[n2];
            }
            if (eCParams != null) break;
            ++n2;
        }
        if (eCParams != null) {
            int n3 = eCParams.getSize();
            int n4 = ECTransform.a(eCParams.getPointOrder());
            String string = this.getAlgorithm();
            if (!ExportLevel.isValid(string, n3) || !ExportLevel.isValid(string, n4)) {
                throw new IllegalArgumentException("Export restriction: curve too large.");
            }
        }
    }
}

