/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import java.util.Random;

public final class ECKeyFactory
extends ECTransform {
    private ECParams P;
    private boolean Q;
    private static final Class R;
    private static final Class S;

    static {
        try {
            R = Class.forName("com.certicom.ecc.interfaces.ECPublicKey");
            S = Class.forName("com.certicom.ecc.interfaces.ECPrivateKey");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }

    public ECKeyFactory() {
        super("ECKeyFactory");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n, objectArray, random);
        if (n == 5 && objectArray != null && objectArray.length == 2) {
            bl = true;
            if (objectArray[0].equals(R)) {
                this.Q = true;
            } else if (!objectArray[0].equals(S)) {
                bl = false;
            }
            if (objectArray[1] instanceof ECParams) {
                this.P = (ECParams)objectArray[1];
            } else {
                bl = false;
            }
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
    }

    public boolean isIncremental() {
        return false;
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        return 0;
    }

    public void reset() {
        super.reset();
        this.P = null;
        this.Q = false;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (this.Q) {
            return new ECPublicKeySpec(this.h, this.g, this.P, byArray, n, n2);
        }
        return new ECPrivateKeySpec(this.h, this.P, byArray, n, n2);
    }
}

