/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.KeyAgreement;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import java.math.BigInteger;
import java.util.Random;

public final class ECDH
extends KeyAgreement {
    public ECDH() {
        super("ECDH");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n != 6 && n != 7 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        ECPrivateKey eCPrivateKey = (ECPrivateKey)objectArray[0];
        ECPublicKey eCPublicKey = (ECPublicKey)objectArray[1];
        if (objectArray.length >= 3 && objectArray[2] != null) {
            this.F = ((SharedInfoParameterSpec)objectArray[2]).getSharedInfo(0);
        }
        super.init(n, objectArray, random);
        ECParams eCParams = eCPrivateKey.getECParams();
        try {
            ECFactory eCFactory = ECFactory.a(eCParams);
            ECA eCA = eCFactory.a(eCPublicKey.getX(), eCPublicKey.getY());
            eCA = this.a(eCA, eCPrivateKey.getExp(), eCParams);
            if (eCA.equals(eCA.int())) {
                this.reset();
                throw new IllegalArgumentException("keys are invalid.");
            }
            this.G = eCA.a().int();
        }
        catch (Exception exception) {
            this.reset();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    private ECA a(ECA eCA, byte[] byArray, ECParams eCParams) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (this.f == 32) {
            return eCA.a(bigInteger.multiply(BigInteger.valueOf(eCParams.getCofactor())).mod(new BigInteger(1, eCParams.getPointOrder())));
        }
        return eCA.a(bigInteger.mod(new BigInteger(1, eCParams.getPointOrder())));
    }
}

