/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECException;
import com.certicom.ecc.Mod;
import com.certicom.ecc.ModFactory;
import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DSA
extends CryptoTransform {
    private ModFactory aD = null;
    private ModFactory aC = null;
    private CryptoTransform aB;
    private int aG;
    private byte[] aF;
    private byte[][] aE = new byte[4][];
    private CryptoCodec aA;
    private int aH;
    private int az;

    public DSA() {
        super("DSA");
        this.aG = SystemConfig.getConfig().getHashType();
        this.aH = SystemConfig.getConfig().getFormat();
        this.az = SystemConfig.getConfig().getConformance();
        this.aB = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "SHA-1");
        this.aA = CryptoCodec.getInstance("DSA", this.aH);
    }

    private static int for(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        if (n == byArray.length) {
            return 0;
        }
        int n2 = (byArray.length - n - 1) * 8;
        int n3 = 7;
        do {
            if ((byArray[n] >>> n3 & 1) != 1) continue;
            n2 += n3 + 1;
            break;
        } while (--n3 >= 0);
        return n2;
    }

    private byte[] char() {
        if (this.aG == 17) {
            this.aF = this.aB.transform(null, 0, 0, true);
        }
        return this.aF;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n, objectArray, random);
        if (objectArray != null && (n == 1 && random != null || n == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        this.aB.init(5, null, random);
        this.aE[0] = (byte[])objectArray[0];
        this.aE[1] = (byte[])objectArray[1];
        this.aE[2] = (byte[])objectArray[2];
        this.aE[3] = (byte[])objectArray[3];
        try {
            this.aD = ModFactory.do(this.aE[0]);
            this.aC = ModFactory.do(this.aE[1]);
        }
        catch (ECException eCException) {
            eCException.printStackTrace();
            throw new IllegalStateException("cannot calculate signature.");
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        if (this.aH == 10) {
            return 40;
        }
        if (this.aH == 11) {
            return 49;
        }
        return 0;
    }

    public void reset() {
        int n;
        super.reset();
        this.aB.reset();
        if (this.aF != null) {
            n = 0;
            while (n < this.aF.length) {
                this.aF[n++] = 0;
            }
            this.aF = null;
        }
        n = 0;
        while (n < this.aE.length) {
            if (this.aE[n] != null) {
                this.aE[n] = null;
            }
            ++n;
        }
        this.aD = null;
        this.aC = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.aG == 18) {
                this.aF = new byte[n2];
                System.arraycopy(byArray, n, this.aF, 0, n2);
            } else {
                this.aB.transform(byArray, n, n2, false);
            }
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        Mod mod = this.aC.a(this.char());
        CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "DSAKEYGEN");
        cryptoTransform.init(5, new Object[]{this.aE[0], this.aE[1], this.aE[2]}, this.rnd);
        Object[] objectArray = (Object[])cryptoTransform.transformToObject(null, 0, 0, true);
        Mod mod2 = this.aC.a((byte[])objectArray[0]);
        Mod mod3 = this.aD.a((byte[])objectArray[1]);
        Mod mod4 = this.aC.a(mod3.int());
        Mod mod5 = this.aC.a(this.aE[3]);
        Mod mod6 = mod2.for().a(mod5.a(mod4).if(mod));
        byte[] byArray3 = mod4.int();
        byte[] byArray4 = mod6.int();
        this.aA.init(1, null);
        this.aA.codecToObject(byArray3, 0, byArray3.length, false);
        Object[] objectArray2 = this.aA.codecToObject(byArray4, 0, byArray4.length, true);
        byte[] byArray5 = (byte[])objectArray2[1];
        if (byArray2.length - n3 < byArray5.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray5, 0, byArray2, n3, byArray5.length);
        return byArray5.length;
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        if (this.mode != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        this.aA.init(2, null);
        Object[] objectArray = this.aA.codecToObject(byArray, n, byArray.length, true);
        byte[] byArray2 = (byte[])objectArray[1];
        byte[] byArray3 = (byte[])objectArray[2];
        Mod mod = this.aC.a(this.char());
        Mod mod2 = this.aC.a(byArray2);
        Mod mod3 = this.aC.a(byArray3);
        Mod mod4 = mod3.for();
        Mod mod5 = mod.a(mod4);
        Mod mod6 = mod2.a(mod4);
        Mod mod7 = this.aD.a(this.aE[2]).a(mod5.if()).a(this.aD.a(this.aE[3]).a(mod6.if()));
        Mod mod8 = this.aC.a(mod7.int());
        return mod8.equals(mod2);
    }
}

