/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RSAPrivateKey
implements RSAKey {
    protected BigInteger for;
    protected BigInteger do;
    protected BigInteger if;
    protected BigInteger a;
    protected BigInteger int;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1 || bigInteger4.signum() == -1 || bigInteger5.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.for = bigInteger;
        this.do = bigInteger2;
        this.if = bigInteger3;
        this.a = bigInteger4;
        this.int = bigInteger5;
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.for = Conversion.OS2IP(byArray);
        this.do = Conversion.OS2IP(byArray2);
        this.if = Conversion.OS2IP(byArray3);
        this.a = Conversion.OS2IP(byArray4);
        this.int = Conversion.OS2IP(byArray5);
    }

    public BigInteger dP() {
        return this.if;
    }

    public BigInteger dQ() {
        return this.a;
    }

    public BigInteger p() {
        return this.for;
    }

    public BigInteger q() {
        return this.do;
    }

    public BigInteger qInv() {
        return this.int;
    }

    public String toString() {
        return "[ p = " + this.for.toString(16) + " q = " + this.do.toString(16) + " dP = " + this.if.toString(16) + " dQ = " + this.a.toString(16) + " qInv = " + this.int.toString(16) + " ]";
    }
}

