/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSADP;
import com.certicom.ecc.rsa.RSAEP;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.rsa.outputSizeSelectable;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RSA
extends CryptoTransform {
    private RSAPrimitive try;
    private CryptoTransform case;
    private int char;
    private byte[] byte;

    public RSA() {
        super("RSA");
    }

    private byte[] do(byte[] byArray, int n) {
        BigInteger bigInteger = Conversion.OS2IP(byArray);
        BigInteger bigInteger2 = this.try.calc(bigInteger);
        return Conversion.I2OSP(bigInteger2, n);
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n, objectArray, random);
        if (objectArray != null && objectArray.length >= 2) {
            String string = (String)objectArray[1];
            if (this.case == null || !this.case.getAlgorithm().equals(string)) {
                this.case = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[1]);
            }
            Object[] objectArray2 = null;
            if (objectArray.length >= 3) {
                objectArray2 = (Object[])objectArray[2];
            }
            this.case.init(5, objectArray2, random);
            if (n == 4 || n == 1) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)objectArray[0];
                if (!(this.try instanceof RSADP)) {
                    this.try = new RSADP(rSAPrivateKey);
                } else {
                    this.try.setKey(rSAPrivateKey);
                }
                this.char = (rSAPrivateKey.p().multiply(rSAPrivateKey.q()).bitLength() + 7) / 8;
                return;
            }
            if (n == 3 || n == 2) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)objectArray[0];
                if (!(this.try instanceof RSAEP)) {
                    this.try = new RSAEP(rSAPublicKey);
                } else {
                    this.try.setKey(rSAPublicKey);
                }
                this.char = (rSAPublicKey.n().bitLength() + 7) / 8;
                return;
            }
        }
        this.reset();
        throw new IllegalArgumentException("wrong params");
    }

    public int inputSize() {
        if ((this.mode == 3 || this.mode == 1 || this.mode == 2) && this.case instanceof outputSizeSelectable) {
            return ((outputSizeSelectable)((Object)this.case)).maxIn(this.char - 1);
        }
        if (this.mode == 4) {
            return this.char;
        }
        return 0;
    }

    public int outputSize(int n, boolean bl) {
        if (this.mode == 3 || this.mode == 1 && bl) {
            return this.char;
        }
        if (this.mode == 4) {
            return this.case.outputSize(this.char - 1, true);
        }
        if (this.mode == 2 || this.mode == 1 && !bl) {
            return 0;
        }
        throw new IllegalStateException("wrong mode");
    }

    public void reset() {
        super.reset();
        if (this.try != null) {
            this.try.reset();
        }
        if (this.case != null) {
            this.case.reset();
        }
        this.char = 0;
        this.byte = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode == 3 || this.mode == 4 || this.mode == 1 || this.mode == 2) {
            int n4;
            byte[] byArray3 = null;
            if (!(bl || this.mode != 3 && this.mode != 4)) {
                throw new IllegalArgumentException("ENC/DEC not incremental");
            }
            if (this.mode != 4) {
                if (bl) {
                    byArray3 = new byte[this.char - 1];
                }
                try {
                    this.case.transform(byArray, n, n2, byArray3, 0, bl);
                    if (this.mode == 2 && bl) {
                        this.byte = byArray3;
                        return 0;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.mode != 2) {
                        throw illegalArgumentException;
                    }
                    return 0;
                }
                if (!bl) {
                    return 0;
                }
                n4 = this.char;
            } else {
                byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
                n4 = this.char - 1;
            }
            byArray3 = this.do(byArray3, n4);
            if (this.mode == 4) {
                byArray3 = this.case.transform(byArray3, 0, byArray3.length, true);
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            return byArray3.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        if (this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (n2 != this.char || this.byte == null) {
            return false;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.do(byArray2, this.char - 1);
        if (this.byte.length != byArray3.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.byte.length && this.byte[n3] == byArray3[n3]) {
            ++n3;
        }
        return n3 == this.byte.length;
    }
}

