/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.outputSizeSelectable;
import com.certicom.ecc.scheme.CryptoTransform;
import java.util.Random;

public final class PKCS1_5Enc
extends CryptoTransform
implements outputSizeSelectable {
    public PKCS1_5Enc() {
        super("EME-PKCS1-v1_5-Encode");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n, objectArray, random);
        if (n != 5) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
    }

    public boolean isIncremental() {
        return false;
    }

    public int maxIn(int n) {
        return n - 10;
    }

    public int outputSize(int n, boolean bl) {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode.");
        }
        return n + 10;
    }

    public void reset() {
        super.reset();
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 5 || !bl) {
            throw new IllegalStateException("wrong mode or not done");
        }
        if (!bl) {
            throw new IllegalArgumentException("not done");
        }
        int n4 = byArray2.length - n3;
        if (n2 > n4 - 10) {
            throw new IllegalArgumentException("msg too long.");
        }
        byArray2[n3++] = 2;
        int n5 = n4 - n2 - 2;
        while (n5 > 0) {
            do {
                byArray2[n3] = (byte)this.rnd.nextInt();
            } while (byArray2[n3] == 0);
            --n5;
            ++n3;
        }
        byArray2[n3++] = 0;
        System.arraycopy(byArray, n, byArray2, n3, n2);
        return n4;
    }
}

