/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    private static String className = "XmlUtil";
    private static Location log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$XmlUtil == null ? (class$com$sap$tc$graphics$igs$XmlUtil = XmlUtil.class$("com.sap.tc.graphics.igs.XmlUtil")) : class$com$sap$tc$graphics$igs$XmlUtil).getName());
    private static Class thisClass = class$com$sap$tc$graphics$igs$XmlUtil == null ? (class$com$sap$tc$graphics$igs$XmlUtil = XmlUtil.class$("com.sap.tc.graphics.igs.XmlUtil")) : class$com$sap$tc$graphics$igs$XmlUtil;
    private boolean finest = log.beLogged(100);
    private static final String QUOTE = "&quot;";
    private static final String AMPERSAND = "&amp;";
    private static final String APOSTROPHE = "&apos;";
    private static final String LESSERTHAN = "&lt;";
    private static final String GREATERTHAN = "&gt;";
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$XmlUtil;

    public static Document createDocument() throws GraphicsException {
        DocumentBuilder builder = null;
        ClassLoader cl = null;
        try {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(thisClass.getClassLoader());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                String message = "fatal: Failed to create Documentbuilder: " + Util.extractCallstack(e);
                log.debugT("createDocument", message);
                throw new GraphicsException(message);
            }
            Object var5_4 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
        return builder.newDocument();
    }

    public static Document initRoot(String rootString, String versionString) throws GraphicsException {
        Document document = null;
        try {
            document = XmlUtil.createDocument();
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: XmlUtil.createDocument() failed";
            log.debugT("initRoot", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        Element root = document.createElement(rootString);
        if (root == null) {
            String errorMessage = "fatal: creating of root element failed";
            log.debugT("initRoot", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        document.appendChild(root);
        root.setAttribute("version", versionString);
        return document;
    }

    private static void whiteSpace(int level, StringBuffer buffer) {
        buffer.append('\n');
        int i = 0;
        while (i < level) {
            buffer.append("  ");
            ++i;
        }
    }

    public static String escape(String text) {
        if (text == null || text.length() < 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append(QUOTE);
                    break;
                }
                case '&': {
                    if (text.indexOf(QUOTE, i) == i || text.indexOf(AMPERSAND) == i || text.indexOf(APOSTROPHE) == i || text.indexOf(LESSERTHAN) == i || text.indexOf(GREATERTHAN) == i) {
                        sb.append(c);
                        break;
                    }
                    sb.append(AMPERSAND);
                    break;
                }
                case '\'': {
                    sb.append(APOSTROPHE);
                    break;
                }
                case '<': {
                    sb.append(LESSERTHAN);
                    break;
                }
                case '>': {
                    sb.append(GREATERTHAN);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static void serializeElement(Element element, int level, StringBuffer buffer) {
        if (element == null) {
            return;
        }
        XmlUtil.whiteSpace(level, buffer);
        buffer.append("<" + element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                buffer.append(" " + attribute.getNodeName() + "=\"" + XmlUtil.escape(attribute.getNodeValue()) + "\"");
                ++i;
            }
        }
        buffer.append(">");
        int bufferLength = buffer.length();
        Node child = element.getFirstChild();
        while (child != null) {
            XmlUtil.serializeNode(child, level + 1, buffer);
            child = child.getNextSibling();
        }
        if (buffer.length() == bufferLength) {
            buffer.insert(bufferLength - 1, '/');
        } else {
            if (buffer.charAt(bufferLength) == '\n') {
                XmlUtil.whiteSpace(level, buffer);
            }
            buffer.append("</" + element.getTagName() + ">");
        }
    }

    private static void serializeNode(Node node, int level, StringBuffer buffer) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                buffer.append(XmlUtil.escape(node.getNodeValue()));
                return;
            }
            case 1: {
                XmlUtil.serializeElement((Element)node, level, buffer);
                return;
            }
            case 5: 
            case 7: 
            case 8: {
                return;
            }
            case 9: 
            case 11: {
                buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                Node child = node.getFirstChild();
                while (child != null) {
                    XmlUtil.serializeNode(child, level, buffer);
                    child = child.getNextSibling();
                }
                return;
            }
        }
    }

    public static String serialize(Document dom) {
        StringBuffer buffer = new StringBuffer(128);
        XmlUtil.serializeNode(dom, 0, buffer);
        return buffer.toString();
    }

    public static synchronized List extractCuIDs(String dataXml) {
        if (dataXml == null) {
            return null;
        }
        class DataXMLParser
        extends DefaultHandler {
            private List result;
            private SeriesCustomizing currentSeries;

            DataXMLParser() {
                this.result = new ArrayList<E>();
            }

            public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attributes) throws SAXException {
                String elementName = "".equals(simpleName) ? qualifiedName : simpleName;
                boolean isSeries = "Series".equals(elementName);
                boolean isPoint = "Point".equals(elementName);
                String cuID = null;
                if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        if ("customizing".equals(attributes.getLocalName(i))) {
                            cuID = attributes.getValue(i);
                        }
                        ++i;
                    }
                }
                if (isSeries) {
                    this.currentSeries = new SeriesCustomizing();
                    this.currentSeries.seriesCuID = cuID;
                    this.currentSeries.pointIDs = new ArrayList<E>();
                    this.result.add(this.currentSeries);
                } else if (isPoint) {
                    this.currentSeries.pointIDs.add(cuID);
                }
            }
        }
        DataXMLParser parser = null;
        ClassLoader cl = null;
        try {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(thisClass.getClassLoader());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                parser = new DataXMLParser();
                factory.newSAXParser().parse((InputStream)new ByteArrayInputStream(dataXml.getBytes()), (DefaultHandler)parser);
            }
            catch (Exception e) {
                log.debugT("extractCuIDs", "fatal: " + Util.extractCallstack(e));
                Object var5_6 = null;
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            Object var5_5 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
        return parser == null ? null : parser.result;
    }

    static Node appendNode(Node parent, String name, String value) throws GraphicsException {
        if (name == null || "".equals(name)) {
            String message = "fatal: could not append node (empty name)";
            log.debugT("appendNode", message);
            throw new GraphicsException(message);
        }
        if (parent == null) {
            String message = "fatal: could not append node (parent == null), NodeName=" + name;
            log.debugT("appendNode", message);
            throw new GraphicsException(message);
        }
        Document document = parent.getOwnerDocument();
        if (document == null) {
            String message = "fatal: could not append node (parent document == null), NodeName=" + name;
            log.debugT("appendNode", message);
            throw new GraphicsException(message);
        }
        Element element = document.createElement(name);
        if (element == null) {
            String message = "fatal: could not create element " + name;
            log.debugT("appendNode", message);
            throw new GraphicsException(message);
        }
        parent.appendChild(element);
        if (value != null) {
            Text valueNode = document.createTextNode(value);
            if (valueNode == null) {
                String message = "fatal: could not create valueNode " + value + " NodeName=" + name;
                log.debugT("appendNode", message);
                throw new GraphicsException(message);
            }
            element.appendChild(valueNode);
        }
        return element;
    }

    static Node appendNode(Node parent, String name) throws GraphicsException {
        return XmlUtil.appendNode(parent, name, null);
    }

    static String extractGisErrors(Document dom) {
        if (dom == null) {
            return null;
        }
        String retVal = null;
        NodeList resultErrorList = dom.getElementsByTagName("ERROR");
        if (resultErrorList != null && resultErrorList.getLength() != 0) {
            retVal = "";
            Node errorNode = resultErrorList.item(0);
            NamedNodeMap errorAttributes = errorNode.getAttributes();
            if (errorAttributes != null) {
                if (errorAttributes.getNamedItem("code") != null) {
                    retVal = retVal + "error code: " + errorAttributes.getNamedItem("code").getNodeValue() + " ";
                }
                if (errorAttributes.getNamedItem("server") != null) {
                    retVal = retVal + "server: " + errorAttributes.getNamedItem("server").getNodeValue() + " ";
                }
                if (errorAttributes.getNamedItem("service") != null) {
                    retVal = retVal + "service: " + errorAttributes.getNamedItem("service").getNodeValue() + " ";
                }
                if (errorNode.hasChildNodes()) {
                    String message = "";
                    NodeList textNodes = errorNode.getChildNodes();
                    int i = 0;
                    while (i < textNodes.getLength()) {
                        if (textNodes.item(i).getNodeType() == 3) {
                            message = message + textNodes.item(i).getNodeValue();
                        }
                        ++i;
                    }
                    if (!"".equals(message)) {
                        retVal = retVal + "message: " + message;
                    }
                }
            }
        }
        return "".equals(retVal) ? null : retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SeriesCustomizing {
        public String seriesCuID;
        public List pointIDs;
    }
}

