/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.CallIgs;
import com.sap.tc.graphics.igs.GeoBorder;
import com.sap.tc.graphics.igs.GeoObject;
import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IgsImageComponent;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeoViewer
extends IgsImageComponent {
    private static final String REQUEST_NAME = "SgxRequest";
    private static final String RESPONSE_NAME = "SgxResponse";
    private static Location log;
    private static String className;
    private GeoBorder border;
    private int width;
    private int height;
    private String resultErrors;
    private String imageMap;
    private HashSet ids;
    private ArrayList geoObjects;
    private String backgroundColor;
    private String transparentColor;
    private String format;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoViewer;

    public GeoViewer() {
        this.finest = log.beLogged(100);
        this.ids = new HashSet();
        this.geoObjects = new ArrayList();
        this.interpreterName = "SAPGISXML";
        this.lastCall = 0L;
        this.mustCallIgs = true;
        this.caller = new CallIgs();
    }

    public void addObject(GeoObject object) throws GraphicsException {
        String id = object.getId();
        if (id == null) {
            throw new GraphicsException("id of geoObject is null");
        }
        if (this.ids.contains(id)) {
            throw new GraphicsException("entry already exists");
        }
        this.geoObjects.add(object);
        this.ids.add(id);
    }

    public void removeObject(String id) {
        this.ids.remove(id);
        Iterator it = ((AbstractList)this.geoObjects).iterator();
        while (it.hasNext()) {
            if (!((GeoObject)it.next()).getId().equals(id)) continue;
            it.remove();
        }
    }

    public void clearObjects() {
        this.ids.clear();
        this.geoObjects.clear();
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = Util.colorToString(backgroundColor);
    }

    public void setTransparentColor(String transparentColor) {
        this.transparentColor = transparentColor;
    }

    public void setTransparentColor(Color transparentColor) {
        this.transparentColor = Util.colorToString(transparentColor);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void zoomToBorder(GeoBorder border) {
        this.mustCallIgs = true;
        this.border = border;
    }

    public void zoom(double factor) {
        this.mustCallIgs = true;
        if (this.border == null) {
            return;
        }
        double longitude = (this.border.getRight() + this.border.getLeft()) / 2.0;
        double lattitude = (this.border.getTop() + this.border.getBottom()) / 2.0;
        double width = (this.border.getRight() - this.border.getLeft()) * factor;
        double height = (this.border.getTop() - this.border.getBottom()) * factor;
        this.border.setBorder((longitude - width) / 2.0, (lattitude + height) / 2.0, (longitude + width) / 2.0, (lattitude - height) / 2.0);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int width, int height) {
        if (height != 0 && this.height != 0 && width == 0) {
            this.width = this.width * height / this.height;
            this.height = height;
        } else if (width != 0 && this.width != 0 && height == 0) {
            this.height = this.height * width / this.width;
            this.width = width;
        } else {
            this.width = width;
            this.height = height;
        }
    }

    public void move(int x, int y) {
        if (this.border == null) {
            return;
        }
        this.mustCallIgs = true;
        double longOff = x == -1 ? 0.0 : (this.border.getRight() - this.border.getLeft()) * (double)x / 100.0;
        double latOff = y == -1 ? 0.0 : (this.border.getTop() - this.border.getBottom()) * (double)y / 100.0;
        this.border.moveBorder(longOff, latOff);
    }

    public void moveToPosition(GeoPosition position) {
        this.mustCallIgs = true;
        if (this.border == null) {
            this.border = new GeoBorder(position.getLongitude() - 10.0, position.getLatitude() + 10.0, position.getLongitude() + 10.0, position.getLatitude() - 10.0);
        } else {
            double width = this.border.getRight() - this.border.getLeft();
            double height = this.border.getTop() - this.border.getBottom();
            this.border = new GeoBorder(position.getLongitude() - width / 2.0, position.getLatitude() + height / 2.0, position.getLongitude() + width / 2.0, position.getLatitude() - height / 2.0);
        }
    }

    public GeoBorder getBorder() {
        this.callIgsIfNecessary();
        return this.border;
    }

    public String getImageMap() {
        return this.imageMap;
    }

    private String createXml() throws GraphicsException {
        Document dom = XmlUtil.initRoot("SAPGISXML", "1.0");
        Node requestNode = XmlUtil.appendNode(dom.getDocumentElement(), "REQUEST");
        Node imageNode = XmlUtil.appendNode(requestNode, "GET_IMAGE");
        Node propNode = XmlUtil.appendNode(imageNode, "PROPERTIES");
        if (this.border != null) {
            Element envelopeNode = (Element)XmlUtil.appendNode(propNode, "ENVELOPE");
            envelopeNode.setAttribute("minx", String.valueOf(Math.min(this.border.getLeft(), this.border.getRight())));
            envelopeNode.setAttribute("maxx", String.valueOf(Math.max(this.border.getLeft(), this.border.getRight())));
            envelopeNode.setAttribute("miny", String.valueOf(Math.min(this.border.getBottom(), this.border.getTop())));
            envelopeNode.setAttribute("maxy", String.valueOf(Math.max(this.border.getBottom(), this.border.getTop())));
            if (this.width > 0 && this.height > 0) {
                Element sizeNode = (Element)XmlUtil.appendNode(propNode, "IMAGESIZE");
                sizeNode.setAttribute("width", String.valueOf(this.width));
                sizeNode.setAttribute("height", String.valueOf(this.height));
            }
            if (this.format != null) {
                Element formatNode = (Element)XmlUtil.appendNode(propNode, "IMAGEFORMAT");
                formatNode.setAttribute("type", this.format);
            }
            if (this.backgroundColor != null || this.transparentColor != null) {
                Element backgroundNode = (Element)XmlUtil.appendNode(propNode, "BACKGROUND");
                if (this.backgroundColor != null) {
                    backgroundNode.setAttribute("color", this.backgroundColor);
                }
                if (this.transparentColor != null) {
                    backgroundNode.setAttribute("transcolor", this.transparentColor);
                }
            }
            if (!this.geoObjects.isEmpty()) {
                Element objectsNode = (Element)XmlUtil.appendNode(imageNode, "OBJECTS");
                Iterator it = ((AbstractList)this.geoObjects).iterator();
                while (it.hasNext()) {
                    ((GeoObject)it.next()).addToDom(dom, objectsNode);
                }
            }
        }
        return XmlUtil.serialize(dom);
    }

    public void clearAll() {
        super.clearAll();
        this.backgroundColor = null;
        this.transparentColor = null;
        this.format = null;
        this.clearObjects();
        this.border = null;
    }

    protected void clearResults() {
        super.clearResults();
        this.resultErrors = null;
        this.imageMap = null;
    }

    protected boolean addParameters() {
        String request = null;
        try {
            request = this.createXml();
        }
        catch (GraphicsException e) {
            return false;
        }
        this.caller.addParameter(REQUEST_NAME, request);
        return true;
    }

    private void extractImage(Document dom) {
        NodeList resultAddresses = dom.getElementsByTagName("IMAGE");
        if (resultAddresses == null || resultAddresses.getLength() == 0) {
            return;
        }
        Node imageNode = resultAddresses.item(0);
        NodeList imageChildren = imageNode.getChildNodes();
        int i = 0;
        while (i < imageChildren.getLength()) {
            NamedNodeMap childAttributes;
            Node child = imageChildren.item(i);
            if ("OUTPUT".equals(child.getNodeName())) {
                childAttributes = child.getAttributes();
                if (childAttributes != null && childAttributes.getNamedItem("url") != null) {
                    this.imageUrl = childAttributes.getNamedItem("url").getNodeValue();
                    if (this.finest) {
                        log.debugT("extractImage", "imageUrl: " + this.imageUrl);
                    }
                }
            } else if ("ENVELOPE".equals(child.getNodeName()) && (childAttributes = child.getAttributes()) != null) {
                String left = childAttributes.getNamedItem("minx").getNodeValue();
                String top = childAttributes.getNamedItem("maxy").getNodeValue();
                String right = childAttributes.getNamedItem("maxx").getNodeValue();
                String bottom = childAttributes.getNamedItem("miny").getNodeValue();
                if (left != null && top != null && right != null && bottom != null) {
                    try {
                        double l = Double.valueOf(left);
                        double t = Double.valueOf(top);
                        double r = Double.valueOf(right);
                        double b = Double.valueOf(bottom);
                        this.border = new GeoBorder(l, t, r, b);
                        if (this.finest) {
                            log.debugT("extractImage", "border: " + this.border);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debugT("extractImage", "fatal: wrong format of result border: " + Util.extractCallstack(e));
                    }
                }
            }
            ++i;
        }
    }

    private void extractImageMap(Document dom) {
        NodeList resultAddresses = dom.getElementsByTagName("IMAGEMAP");
        if (resultAddresses == null || resultAddresses.getLength() == 0) {
            return;
        }
        Node imageMapNode = resultAddresses.item(0);
        NodeList textNodes = imageMapNode.getChildNodes();
        this.imageMap = "";
        int i = 0;
        while (i < textNodes.getLength()) {
            if (textNodes.item(i).getNodeType() == 3) {
                this.imageMap = this.imageMap + textNodes.item(i).getNodeValue();
            }
            ++i;
        }
        if ("".equals(this.imageMap)) {
            this.imageMap = null;
        }
        if (this.finest) {
            log.debugT("extractImageMap", "imageMap: " + this.imageMap);
        }
    }

    protected void extractResults() {
        String methodName = "extractResults";
        String result = this.caller.getResult(RESPONSE_NAME);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.debugT(methodName, "fatal: ParserConfiguration error: " + Util.extractCallstack(e));
            return;
        }
        Document dom = null;
        try {
            dom = builder.parse(this.igsUrl.toString() + result);
            if (this.finest) {
                log.debugT(methodName, "result: " + XmlUtil.serialize(dom));
            }
        }
        catch (IOException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        catch (SAXException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        this.resultErrors = XmlUtil.extractGisErrors(dom);
        if (this.finest) {
            log.debugT(methodName, "result errors: " + this.resultErrors);
        }
        this.extractImage(dom);
        this.extractImageMap(dom);
    }

    public String getErrors() {
        String retVal = "";
        if (this.igsError != null) {
            retVal = retVal + "igs error: " + this.igsError + " ";
        }
        if (this.resultErrors != null) {
            retVal = retVal + "gis processing returned error: " + this.resultErrors;
        }
        return "".equals(retVal) ? null : retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoViewer";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoViewer == null ? (class$com$sap$tc$graphics$igs$GeoViewer = GeoViewer.class$("com.sap.tc.graphics.igs.GeoViewer")) : class$com$sap$tc$graphics$igs$GeoViewer).getName());
    }
}

