/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoBorder;
import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IgsComponent;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeoRouter
extends IgsComponent {
    public static final double NO_VALUE = Double.MAX_VALUE;
    private static final String PARAM_NAME = "SgxRequest";
    private static final String INTERPRETER_NAME = "SAPGISXML";
    private static final String DESCRIPTION_SEPARATOR = ", ";
    private static Location log;
    private static String className;
    private ArrayList stops;
    private HashMap properties;
    private List parts;
    private List routePath;
    private GeoBorder routeBorder;
    private double routeDistance;
    private double routeDuration;
    private String routeDescription;
    private String resultErrors;
    private Document dom;
    private String language;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoCoder;

    public GeoRouter() {
        this.finest = log.beLogged(100);
        this.stops = new ArrayList();
        this.properties = new HashMap();
        this.interpreterName = INTERPRETER_NAME;
        this.parts = new ArrayList();
        this.routePath = new ArrayList();
    }

    public String getErrors() {
        return this.resultErrors;
    }

    public boolean execute() {
        this.callIgsIfNecessary();
        return !this.parts.isEmpty();
    }

    private String createXml() throws GraphicsException {
        Set keys;
        Document dom = XmlUtil.initRoot(INTERPRETER_NAME, "1.0");
        Node requestNode = XmlUtil.appendNode(dom.getDocumentElement(), "REQUEST");
        Element routeNode = (Element)XmlUtil.appendNode(requestNode, "GET_ROUTE");
        if (this.language != null) {
            routeNode.setAttribute("language", this.language);
        }
        Node stopsNode = XmlUtil.appendNode(routeNode, "STOPS");
        if (!this.stops.isEmpty()) {
            Iterator it = ((AbstractList)this.stops).iterator();
            while (it.hasNext()) {
                Stop stop = (Stop)it.next();
                Element stopNode = (Element)XmlUtil.appendNode(stopsNode, "STOP");
                if (stop.id != null) {
                    stopNode.setAttribute("id", stop.id);
                }
                if (stop.description != null) {
                    stopNode.setAttribute("description", stop.description);
                }
                if (stop.position == null) {
                    throw new GraphicsException("encountered stop with null position: " + stop);
                }
                Element pointNode = (Element)XmlUtil.appendNode(stopNode, "POINT");
                String coords = String.valueOf(stop.position.getLongitude()) + DESCRIPTION_SEPARATOR + String.valueOf(stop.position.getLatitude());
                XmlUtil.appendNode(pointNode, "COORDS", coords);
            }
        }
        if (!this.properties.isEmpty() && (keys = this.properties.keySet()) != null) {
            Node propertyNode = XmlUtil.appendNode(routeNode, "PROPERTIES");
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.properties.get(key);
                Element element = (Element)XmlUtil.appendNode(propertyNode, key, value);
            }
        }
        return XmlUtil.serialize(dom);
    }

    private GeoBorder extractEnvelope(Node envelopeNode) {
        String methodName = "extractEnvelope";
        NamedNodeMap attributes = envelopeNode.getAttributes();
        if (attributes == null) {
            log.debugT(methodName, "fatal: ENVELOPE node has no attributes");
            return null;
        }
        Node envelopeAttribute = attributes.getNamedItem("minx");
        if (envelopeAttribute == null) {
            return null;
        }
        String left = envelopeAttribute.getNodeValue();
        envelopeAttribute = attributes.getNamedItem("maxy");
        if (envelopeAttribute == null) {
            return null;
        }
        String top = envelopeAttribute.getNodeValue();
        envelopeAttribute = attributes.getNamedItem("maxx");
        if (envelopeAttribute == null) {
            return null;
        }
        String right = envelopeAttribute.getNodeValue();
        envelopeAttribute = attributes.getNamedItem("miny");
        if (envelopeAttribute == null) {
            return null;
        }
        String bottom = envelopeAttribute.getNodeValue();
        if (left == null || top == null || right == null || bottom == null) {
            return null;
        }
        try {
            double l = Double.valueOf(left);
            double t = Double.valueOf(top);
            double r = Double.valueOf(right);
            double b = Double.valueOf(bottom);
            return new GeoBorder(l, t, r, b);
        }
        catch (NumberFormatException e) {
            log.debugT(methodName, "fatal: wrong format of result border: " + Util.extractCallstack(e));
            return null;
        }
    }

    private double extractDoubleAttribute(NamedNodeMap attributes, String attributeName) {
        String methodName = "extractDistance";
        if (attributes == null) {
            log.debugT(methodName, "fatal: node has no attributes");
            return Double.MAX_VALUE;
        }
        Node attribute = attributes.getNamedItem(attributeName);
        if (attribute == null) {
            log.infoT(methodName, "node has no attribute \"" + attributeName + "\"");
        } else {
            String attributeString = attribute.getNodeValue();
            try {
                return Double.valueOf(attributeString);
            }
            catch (NumberFormatException e) {
                log.infoT(methodName, attributeName + "attribute is not valid: " + attributeString);
            }
        }
        return Double.MAX_VALUE;
    }

    private List stringToPathList(String s) {
        LinkedList<GeoPosition> retVal = new LinkedList<GeoPosition>();
        StringTokenizer tokens = new StringTokenizer(s, ";");
        while (tokens.hasMoreTokens()) {
            String coords = tokens.nextToken();
            double x = Double.valueOf(coords.substring(0, coords.indexOf(44)));
            double y = Double.valueOf(coords.substring(coords.indexOf(44) + 1));
            retVal.add(new GeoPosition(x, y));
        }
        return retVal;
    }

    private Node extractRouteNode() {
        NodeList routeChildren;
        String methodName = "extractRouteNode";
        if (this.dom == null) {
            log.debugT(methodName, "fatal: dom is null");
            return null;
        }
        NodeList routeNodes = this.dom.getElementsByTagName("ROUTE");
        if (routeNodes == null || routeNodes.getLength() == 0) {
            log.debugT(methodName, "fatal: no nodes \"ROUTE\" in response");
            return null;
        }
        Node routeNode = null;
        int i = 0;
        while (i < routeNodes.getLength()) {
            if (routeNodes.item(i).getNodeType() == 1) {
                routeNode = routeNodes.item(i);
                break;
            }
            ++i;
        }
        if (routeNode == null) {
            log.debugT(methodName, "fatal: no nodes \"ROUTE\" in response");
        }
        if ((routeChildren = routeNode.getChildNodes()) == null || routeChildren.getLength() == 0) {
            log.debugT(methodName, "fatal: no \"ENVELOPE\" under \"ROUTE\" node in response");
            return null;
        }
        return routeNode;
    }

    private void extractRouteBorder(Node routeNode) {
        String methodName = "extractRouteBorder";
        NodeList routeChildren = routeNode.getChildNodes();
        int i = 0;
        while (i < routeChildren.getLength()) {
            Node envelopeNode = routeChildren.item(i);
            if (envelopeNode.getNodeType() == 1 && "ENVELOPE".equals(envelopeNode.getNodeName())) {
                this.routeBorder = this.extractEnvelope(envelopeNode);
                break;
            }
            ++i;
        }
    }

    private void extractRouteInfo(Node routeNode) {
        String methodName = "extractRouteInfo";
        Node totalsNode = null;
        NodeList routeChildren = routeNode.getChildNodes();
        int i = 0;
        while (i < routeChildren.getLength()) {
            Node node = routeChildren.item(i);
            if ("TOTALS".equals(node.getNodeName()) && node.getNodeType() == 1) {
                totalsNode = node;
                break;
            }
            ++i;
        }
        if (totalsNode == null) {
            log.debugT(methodName, "fatal: no nodes \"TOTALS\" in response");
            return;
        }
        NamedNodeMap totalsAttributes = totalsNode.getAttributes();
        this.routeDistance = this.extractDoubleAttribute(totalsAttributes, "distance");
        if (this.routeDistance == Double.MAX_VALUE) {
            log.infoT(methodName, "node TOTALS has no valid attribute \"distance\"");
        }
        this.routeDuration = this.extractDoubleAttribute(totalsAttributes, "time");
        if (this.routeDuration == Double.MAX_VALUE) {
            log.infoT(methodName, "node TOTALS has no valid attribute \"time\"");
        }
        this.routeDescription = "";
        NodeList descriptionNodes = totalsNode.getChildNodes();
        if (descriptionNodes != null) {
            int i2 = 0;
            while (i2 < descriptionNodes.getLength()) {
                NodeList textNodes;
                Node node = descriptionNodes.item(i2);
                if ("DESCRIPTION".equals(node.getNodeName()) && node.getNodeType() == 1 && (textNodes = node.getChildNodes()) != null) {
                    int j = 0;
                    while (j < textNodes.getLength()) {
                        if (textNodes.item(j).getNodeType() == 3) {
                            this.routeDescription = this.routeDescription + textNodes.item(j).getNodeValue();
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        if ("".equals(this.routeDescription)) {
            this.routeDescription = null;
        }
    }

    private List extractSegments(Node partNode) {
        String methodName = "extractSegments";
        if (partNode == null) {
            return null;
        }
        NodeList partChildren = partNode.getChildNodes();
        if (partChildren == null || partChildren.getLength() == 0) {
            return null;
        }
        ArrayList<Segment> retVal = new ArrayList<Segment>();
        int i = 0;
        while (i < partChildren.getLength()) {
            NodeList segmentChildren;
            Node segmentNode = partChildren.item(i);
            if (segmentNode.getNodeType() == 1 && "SEGMENT".equals(segmentNode.getNodeName()) && (segmentChildren = segmentNode.getChildNodes()) != null && segmentChildren.getLength() != 0) {
                NamedNodeMap segmentAttributes = segmentNode.getAttributes();
                double distance = this.extractDoubleAttribute(segmentAttributes, "distance");
                double duration = this.extractDoubleAttribute(segmentAttributes, "time");
                GeoBorder border = null;
                String description = "";
                List path = null;
                int j = 0;
                while (j < segmentChildren.getLength()) {
                    block26: {
                        Node segmentChild = segmentChildren.item(j);
                        if (segmentChild.getNodeType() == 1) {
                            String localName = segmentChild.getNodeName();
                            if ("ENVELOPE".equals(localName)) {
                                border = this.extractEnvelope(segmentChild);
                            } else if ("DESCRIPTION".equals(localName)) {
                                NodeList textNodes = segmentChild.getChildNodes();
                                if (textNodes != null) {
                                    int k = 0;
                                    while (k < textNodes.getLength()) {
                                        if (textNodes.item(k).getNodeType() == 3) {
                                            description = description + textNodes.item(k).getNodeValue();
                                        }
                                        ++k;
                                    }
                                }
                            } else if ("POLYLINE".equals(localName)) {
                                NodeList polylineChildren = segmentChild.getChildNodes();
                                if (polylineChildren != null) {
                                    int k = 0;
                                    while (k < polylineChildren.getLength()) {
                                        NodeList pathChildren;
                                        Node pathNode = polylineChildren.item(k);
                                        if (pathNode.getNodeType() == 1 && "PATH".equals(pathNode.getNodeName()) && (pathChildren = pathNode.getChildNodes()) != null) {
                                            int l = 0;
                                            while (l < pathChildren.getLength()) {
                                                Node coordsNode = pathChildren.item(l);
                                                if (coordsNode.getNodeType() == 1 && "COORDS".equals(coordsNode.getNodeName())) {
                                                    NodeList textNodes = coordsNode.getChildNodes();
                                                    if (textNodes != null && textNodes.getLength() > 0) {
                                                        path = this.stringToPathList(textNodes.item(0).getNodeValue());
                                                    }
                                                    break block26;
                                                }
                                                ++l;
                                            }
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                            } else if ("PATH".equals(localName)) {
                                NamedNodeMap pathAttributes = segmentChild.getAttributes();
                                if (pathAttributes == null) {
                                    log.debugT(methodName, "fatal: path node has no attributes");
                                } else {
                                    Node attribute = pathAttributes.getNamedItem("coords");
                                    if (attribute == null) {
                                        log.infoT(methodName, "path node has no attribute \"coords\"");
                                    } else {
                                        path = this.stringToPathList(attribute.getNodeValue());
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
                retVal.add(new Segment(border, description, distance, duration, path));
            }
            ++i;
        }
        return retVal.isEmpty() ? null : retVal;
    }

    private void extractParts(Node routeNode) {
        String methodName = "extractParts";
        NodeList routeChildren = routeNode.getChildNodes();
        Node partsNode = null;
        int i = 0;
        while (i < routeChildren.getLength()) {
            Node routeChild = routeChildren.item(i);
            if (routeChild.getNodeType() == 1 && "PARTS".equals(routeChild.getNodeName()) && routeChild.getNodeType() == 1) {
                partsNode = routeChild;
                break;
            }
            ++i;
        }
        if (partsNode == null) {
            log.debugT(methodName, "fatal: no \"PARTS\" under \"ROUTE\" node in response");
            return;
        }
        NodeList partsChildren = partsNode.getChildNodes();
        if (partsChildren == null || partsChildren.getLength() == 0) {
            log.debugT(methodName, "fatal: no \"PART\" under \"PARTS\" node in response");
            return;
        }
        int i2 = 0;
        while (i2 < partsChildren.getLength()) {
            List segments;
            NodeList partChildren;
            Node partsChild = partsChildren.item(i2);
            if ("PART".equals(partsChild.getNodeName()) && partsChild.getNodeType() == 1 && (partChildren = partsChild.getChildNodes()) != null && partsChildren.getLength() != 0 && (segments = this.extractSegments(partsChild)) != null) {
                this.parts.add(new Part(segments));
            }
            ++i2;
        }
        Iterator it = this.parts.iterator();
        while (it.hasNext()) {
            Part part = (Part)it.next();
            this.routePath.addAll(part.path);
        }
    }

    protected void extractResults() {
        Node route;
        String methodName = "extractResults";
        String result = this.caller.getResult("SgxResponse");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.debugT(methodName, "fatal: ParserConfiguration error: " + Util.extractCallstack(e));
            return;
        }
        this.dom = null;
        try {
            this.dom = builder.parse(this.igsUrl.toString() + result);
            if (this.finest) {
                log.debugT(methodName, "result: " + XmlUtil.serialize(this.dom));
            }
        }
        catch (IOException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        catch (SAXException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        if (this.dom == null) {
            log.debugT(methodName, "fatal: DOM is null");
            return;
        }
        this.resultErrors = XmlUtil.extractGisErrors(this.dom);
        if (this.finest) {
            log.debugT(methodName, "resultErrors: " + this.resultErrors);
        }
        if ((route = this.extractRouteNode()) != null) {
            this.extractRouteBorder(route);
            this.extractRouteInfo(route);
            this.extractParts(route);
        }
    }

    protected boolean addParameters() {
        String request = null;
        try {
            request = this.createXml();
        }
        catch (GraphicsException e) {
            return false;
        }
        this.caller.addParameter(PARAM_NAME, request);
        return true;
    }

    public void clearAll() {
        this.stops.clear();
        this.properties.clear();
        this.language = null;
        super.clearAll();
    }

    protected void clearResults() {
        this.dom = null;
        this.routeBorder = null;
        this.routeDistance = Double.MAX_VALUE;
        this.routeDuration = Double.MAX_VALUE;
        this.routeDescription = null;
        this.resultErrors = null;
        this.parts.clear();
        this.routePath.clear();
    }

    public void addStop(String id, String description, GeoPosition position) {
        this.addStop(new Stop(id, description, position));
    }

    public void addStop(Stop stop) {
        this.stops.add(stop);
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuickest() {
        this.addProperty("ROUTETYPE", "QUICKEST");
    }

    public void setShortest() {
        this.addProperty("ROUTETYPE", "SHORTEST");
    }

    public int getPartCount() {
        this.callIgsIfNecessary();
        return this.parts.size();
    }

    public GeoBorder getPartBorder(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return null;
        }
        return part.border;
    }

    public double getPartDistance(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return Double.MAX_VALUE;
        }
        return part.distance;
    }

    public double getPartDuration(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return Double.MAX_VALUE;
        }
        return part.duration;
    }

    public String getPartDescription(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return null;
        }
        return part.description;
    }

    public List getPartPath(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return null;
        }
        return part.path;
    }

    public int getSegmentCount(int partIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return 0;
        }
        if (part.segments == null) {
            return 0;
        }
        return part.segments.size();
    }

    public double getSegmentDistance(int partIndex, int segmentIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return Double.MAX_VALUE;
        }
        if (part.segments == null) {
            return Double.MAX_VALUE;
        }
        Segment segment = (Segment)part.segments.get(segmentIndex);
        if (segment == null) {
            return Double.MAX_VALUE;
        }
        return segment.distance;
    }

    public double getSegmentDuration(int partIndex, int segmentIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return Double.MAX_VALUE;
        }
        if (part.segments == null) {
            return Double.MAX_VALUE;
        }
        Segment segment = (Segment)part.segments.get(segmentIndex);
        if (segment == null) {
            return Double.MAX_VALUE;
        }
        return segment.duration;
    }

    public String getSegmentDescription(int partIndex, int segmentIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return null;
        }
        if (part.segments == null) {
            return null;
        }
        Segment segment = (Segment)part.segments.get(segmentIndex);
        if (segment == null) {
            return null;
        }
        return segment.description;
    }

    public List getSegmentPath(int partIndex, int segmentIndex) {
        this.callIgsIfNecessary();
        Part part = (Part)this.parts.get(partIndex);
        if (part == null) {
            return null;
        }
        if (part.segments == null) {
            return null;
        }
        Segment segment = (Segment)part.segments.get(segmentIndex);
        if (segment == null) {
            return null;
        }
        return segment.path;
    }

    public GeoBorder getRouteBorder() {
        this.callIgsIfNecessary();
        return this.routeBorder;
    }

    public double getRouteDistance() {
        this.callIgsIfNecessary();
        return this.routeDistance;
    }

    public double getRouteDuration() {
        this.callIgsIfNecessary();
        return this.routeDuration;
    }

    public String getRouteDescription() {
        this.callIgsIfNecessary();
        return this.routeDescription;
    }

    public List getRoutePath() {
        this.callIgsIfNecessary();
        return this.routePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoCoder";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoCoder == null ? (class$com$sap$tc$graphics$igs$GeoCoder = GeoRouter.class$("com.sap.tc.graphics.igs.GeoCoder")) : class$com$sap$tc$graphics$igs$GeoCoder).getName());
    }

    private class Segment {
        GeoBorder border;
        String description;
        double distance;
        double duration;
        List path;

        Segment(GeoBorder border, String description, double distance, double duration, List path) {
            this.border = border;
            this.description = description;
            this.distance = distance;
            this.duration = duration;
            this.path = path;
        }
    }

    private class Part {
        List segments;
        String description;
        double distance;
        double duration;
        List path;
        GeoBorder border;

        Part(List segments) {
            int descriptionLength;
            this.segments = segments;
            StringBuffer descriptionBuffer = new StringBuffer();
            this.description = null;
            this.path = new ArrayList();
            this.border = new GeoBorder();
            this.distance = 0.0;
            this.duration = 0.0;
            if (segments != null) {
                Iterator it = segments.iterator();
                while (it.hasNext()) {
                    Segment segment = (Segment)it.next();
                    if (segment.description != null && !"".equals(segment.description)) {
                        descriptionBuffer.append(segment.description);
                        descriptionBuffer.append(GeoRouter.DESCRIPTION_SEPARATOR);
                    }
                    if (segment.distance != Double.MAX_VALUE) {
                        this.distance += segment.distance;
                    }
                    if (segment.duration != Double.MAX_VALUE) {
                        this.duration += segment.duration;
                    }
                    if (segment.path != null) {
                        this.path.addAll(segment.path);
                    }
                    if (segment.border == null) continue;
                    this.border.unionBorder(segment.border);
                }
            }
            if ((descriptionLength = descriptionBuffer.length()) != 0) {
                descriptionBuffer.delete(descriptionLength - GeoRouter.DESCRIPTION_SEPARATOR.length(), descriptionLength);
                this.description = descriptionBuffer.toString();
            }
            if (this.distance == 0.0) {
                this.distance = Double.MAX_VALUE;
            }
            if (this.duration == 0.0) {
                this.duration = Double.MAX_VALUE;
            }
        }
    }

    public static class Stop {
        private String id;
        private String description;
        private GeoPosition position;

        public Stop(String id, String description, GeoPosition position) {
            this.id = id;
            this.description = description;
            this.position = position;
        }

        public String toString() {
            return "stop id:" + this.id + " description:" + this.description + " position:" + this.position;
        }
    }
}

