/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoObject;
import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoPolygon
extends GeoObject {
    private static Location log;
    private static String className;
    private List positions;
    private String borderColor;
    private int transparency;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoPolygon;

    public GeoPolygon(String id) {
        super(id);
        this.finest = log.beLogged(100);
        this.transparency = Integer.MAX_VALUE;
    }

    public GeoPolygon(String id, String label, String extension, String color, List positions, String borderColor, int transparency) {
        super(id);
        this.finest = log.beLogged(100);
        this.transparency = Integer.MAX_VALUE;
        this.label = label;
        this.extension = extension;
        this.color = color;
        this.positions = positions;
        this.borderColor = borderColor;
        this.setTransparency(transparency);
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = Util.colorToString(borderColor);
    }

    public void setPositions(List positions) {
        this.positions = positions;
    }

    public void setPositions(GeoPosition[] positions) {
        this.positions = Arrays.asList(positions);
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency < 0 ? 0 : (transparency > 100 ? 100 : transparency);
    }

    protected void addToDom(Document dom, Node node) {
        if (this.id == null || this.positions == null) {
            return;
        }
        try {
            Element elementNode = (Element)XmlUtil.appendNode(node, "OBJECT");
            elementNode.setAttribute("id", this.id);
            if (this.label != null && !"".equals(this.label)) {
                elementNode.setAttribute("label", this.id);
            }
            if (this.extension != null && !"".equals(this.extension)) {
                elementNode.setAttribute("extension", this.extension);
            }
            Element polygonNode = (Element)XmlUtil.appendNode(elementNode, "POLYGON");
            String coords = null;
            Iterator it = this.positions.iterator();
            while (it.hasNext()) {
                try {
                    GeoPosition position = (GeoPosition)it.next();
                    coords = coords == null ? "" : coords + ";";
                    coords = coords + String.valueOf(position.getLongitude()) + "," + String.valueOf(position.getLatitude());
                }
                catch (ClassCastException e) {
                    log.debugT("addToDom", "warning: polygon contains a position that is not a GeoPosition" + Util.extractCallstack(e));
                }
            }
            polygonNode.setAttribute("coords", coords);
            if (this.color != null && !"".equals(this.color)) {
                polygonNode.setAttribute("color", this.color);
            }
            if (this.borderColor != null && !"".equals(this.borderColor)) {
                polygonNode.setAttribute("bordercolor", this.borderColor);
            }
            if (this.transparency != Integer.MAX_VALUE) {
                polygonNode.setAttribute("width", String.valueOf(this.transparency));
            }
        }
        catch (GraphicsException e) {
            log.debugT("addToDom", "fatal: Could not add polygon to request xml");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoPolygon";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoPolygon == null ? (class$com$sap$tc$graphics$igs$GeoPolygon = GeoPolygon.class$("com.sap.tc.graphics.igs.GeoPolygon")) : class$com$sap$tc$graphics$igs$GeoPolygon).getName());
    }
}

