/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoObject;
import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoPoint
extends GeoObject {
    public static final int CIRCLE = 0;
    public static final int TRIANGLE = 1;
    public static final int SQUARE = 2;
    public static final int ELLIPSE = 3;
    public static final int IMAGE = 4;
    public static final Color TEXT_INVERTED = null;
    private GeoPosition position;
    private int size;
    private int style;
    private String image;
    private String textColor;
    private static Location log;
    private static String className;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoPoint;

    public GeoPoint(String id) {
        super(id);
        this.finest = log.beLogged(100);
        this.style = 0;
        this.size = Integer.MAX_VALUE;
    }

    public GeoPoint(String id, String label, String extension, String color, GeoPosition position, int size, int style) {
        super(id);
        this.finest = log.beLogged(100);
        this.style = 0;
        this.size = Integer.MAX_VALUE;
        this.label = label;
        this.extension = extension;
        this.color = color;
        this.position = position;
        this.size = size;
        this.style = style;
    }

    public GeoPoint(String id, String label, String extension, GeoPosition position, String image) {
        super(id);
        this.finest = log.beLogged(100);
        this.style = 0;
        this.size = Integer.MAX_VALUE;
        this.extension = extension;
        this.position = position;
        this.image = image;
        this.style = 4;
    }

    public void setPosition(GeoPosition position) {
        this.position = position;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setImage(String image) {
        this.image = image;
        this.style = 4;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor == null ? null : Util.colorToString(textColor);
    }

    protected void addToDom(Document dom, Node node) {
        if (this.id == null || this.position == null) {
            return;
        }
        try {
            boolean hasImage;
            Element elementNode = (Element)XmlUtil.appendNode(node, "OBJECT");
            elementNode.setAttribute("id", this.id);
            if (this.label != null && !"".equals(this.label)) {
                elementNode.setAttribute("label", this.label);
            }
            if (this.extension != null && !"".equals(this.extension)) {
                elementNode.setAttribute("extension", this.extension);
            }
            Element pointNode = (Element)XmlUtil.appendNode(elementNode, "POINT");
            String coords = String.valueOf(this.position.getLongitude()) + "," + String.valueOf(this.position.getLatitude());
            pointNode.setAttribute("coords", coords);
            boolean bl = hasImage = this.image != null && this.style == 4;
            if (this.color != null && !"".equals(this.color) && !hasImage) {
                pointNode.setAttribute("color", this.color);
            }
            if (this.textColor != null && !"".equals(this.textColor)) {
                pointNode.setAttribute("textColor", this.textColor);
            }
            if (this.style == 1) {
                pointNode.setAttribute("style", "triangle");
            } else if (this.style == 2) {
                pointNode.setAttribute("style", "square");
            } else if (this.style == 3) {
                pointNode.setAttribute("style", "ellipse");
            } else if (this.style == 0) {
                pointNode.setAttribute("style", "circle");
            } else if (this.style == 4) {
                pointNode.setAttribute("style", "image");
            }
            if (hasImage) {
                pointNode.setAttribute("image", this.image);
            }
            if (this.size != Integer.MAX_VALUE && !hasImage) {
                pointNode.setAttribute("size", String.valueOf(this.size));
            }
        }
        catch (GraphicsException e) {
            log.debugT("addToDom", "fatal: Could not add point to request xml");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoPoint";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoPoint == null ? (class$com$sap$tc$graphics$igs$GeoPoint = GeoPoint.class$("com.sap.tc.graphics.igs.GeoPoint")) : class$com$sap$tc$graphics$igs$GeoPoint).getName());
    }
}

