/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoObject;
import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoLine
extends GeoObject {
    private static Location log;
    private static String className;
    private List positions;
    private int width;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoLine;

    public GeoLine(String id) {
        super(id);
        this.finest = log.beLogged(100);
        this.width = Integer.MAX_VALUE;
    }

    public GeoLine(String id, String label, String extension, List positions, int width) {
        super(id);
        this.finest = log.beLogged(100);
        this.width = Integer.MAX_VALUE;
        this.label = label;
        this.extension = extension;
        this.positions = positions;
        this.width = width;
    }

    public void setPositions(List positions) {
        this.positions = positions;
    }

    public void setPositions(GeoPosition[] positions) {
        this.positions = Arrays.asList(positions);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected void addToDom(Document dom, Node node) {
        if (this.id == null || this.positions == null) {
            return;
        }
        try {
            Element elementNode = (Element)XmlUtil.appendNode(node, "OBJECT");
            elementNode.setAttribute("id", this.id);
            if (this.label != null && !"".equals(this.label)) {
                elementNode.setAttribute("label", this.id);
            }
            if (this.extension != null && !"".equals(this.extension)) {
                elementNode.setAttribute("extension", this.extension);
            }
            Element lineNode = (Element)XmlUtil.appendNode(elementNode, "LINE");
            String coords = null;
            Iterator it = this.positions.iterator();
            while (it.hasNext()) {
                try {
                    GeoPosition position = (GeoPosition)it.next();
                    coords = coords == null ? "" : coords + ";";
                    coords = coords + String.valueOf(position.getLongitude()) + "," + String.valueOf(position.getLatitude());
                }
                catch (ClassCastException e) {
                    log.debugT("addToDom", "warning: line contains a position that is not a GeoPosition" + Util.extractCallstack(e));
                }
            }
            lineNode.setAttribute("coords", coords);
            if (this.color != null && !"".equals(this.color)) {
                lineNode.setAttribute("color", this.color);
            }
            if (this.width != Integer.MAX_VALUE) {
                lineNode.setAttribute("width", String.valueOf(this.width));
            }
        }
        catch (GraphicsException e) {
            log.debugT("addToDom", "fatal: Could not add line to request xml");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoLine";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoLine == null ? (class$com$sap$tc$graphics$igs$GeoLine = GeoLine.class$("com.sap.tc.graphics.igs.GeoLine")) : class$com$sap$tc$graphics$igs$GeoLine).getName());
    }
}

