/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoPosition;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IgsComponent;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeoCoder
extends IgsComponent {
    private static Location log;
    private static String className;
    private static final String PARAM_NAME = "SgxRequest";
    private HashMap addressMap;
    private HashMap resultMap;
    private GeoPosition geoPosition;
    private int maxCandidates = -1;
    private int minScore = -1;
    private String resultErrors = null;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoCoder;

    public GeoCoder() {
        this.finest = log.beLogged(100);
        this.interpreterName = "SAPGISXML";
        this.addressMap = new HashMap();
        this.resultMap = new HashMap();
    }

    private void addAddressesToDom(Node node) throws GraphicsException {
        Node addressesNode = XmlUtil.appendNode(node, "ADDRESSES");
        Set set = this.addressMap.entrySet();
        if (set == null || set.isEmpty()) {
            String errorMessage = "fatal: GeoCoder does not have any addresses";
            log.debugT("addAddressesToDom", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String errorMessage;
            Map.Entry entry = i.next();
            String id = (String)entry.getKey();
            Address address = (Address)entry.getValue();
            if (id == null) {
                errorMessage = "fatal: null key for address";
                log.debugT("addAddressesToDom", errorMessage);
                throw new GraphicsException(errorMessage);
            }
            if (address == null) {
                errorMessage = "fatal: null address";
                log.debugT("addAddressesToDom", errorMessage);
                throw new GraphicsException(errorMessage);
            }
            Node addressNode = XmlUtil.appendNode(addressesNode, "ADDRESS");
            ((Element)addressNode).setAttribute("id", id);
            if (address.number != null && !"".equals(address.number)) {
                XmlUtil.appendNode(addressNode, "NUMBER", address.number);
            }
            if (address.street != null && !"".equals(address.street)) {
                XmlUtil.appendNode(addressNode, "STREET", address.street);
            }
            if (address.city != null && !"".equals(address.city)) {
                XmlUtil.appendNode(addressNode, "CITY", address.city);
            }
            if (address.region != null && !"".equals(address.region)) {
                XmlUtil.appendNode(addressNode, "REGION", address.region);
            }
            if (address.code != null && !"".equals(address.code)) {
                XmlUtil.appendNode(addressNode, "CODE", address.code);
            }
            if (address.country == null || "".equals(address.country)) continue;
            XmlUtil.appendNode(addressNode, "COUNTRY", address.country);
        }
    }

    private String createXml() throws GraphicsException {
        Document dom = XmlUtil.initRoot("SAPGISXML", "1.0");
        Node requestNode = XmlUtil.appendNode(dom.getDocumentElement(), "REQUEST");
        Node geoCodeNode = XmlUtil.appendNode(requestNode, "GET_GEOCODE");
        Node propertiesNode = XmlUtil.appendNode(geoCodeNode, "PROPERTIES");
        if (this.maxCandidates != -1) {
            XmlUtil.appendNode(propertiesNode, "MAXCANDIDATES", String.valueOf(this.maxCandidates));
        }
        if (this.minScore != -1) {
            XmlUtil.appendNode(propertiesNode, "MINSCORE", String.valueOf(this.minScore));
        }
        this.addAddressesToDom(geoCodeNode);
        return XmlUtil.serialize(dom);
    }

    protected void extractResults() {
        NodeList resultAddresses;
        String methodName = "extractResults";
        String result = this.caller.getResult("SgxResponse");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.debugT(methodName, "fatal: ParserConfiguration error: " + Util.extractCallstack(e));
            return;
        }
        Document dom = null;
        try {
            dom = builder.parse(this.igsUrl.toString() + result);
            if (this.finest) {
                log.debugT(methodName, "result: " + XmlUtil.serialize(dom));
            }
        }
        catch (IOException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        catch (SAXException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        if (dom == null) {
            log.debugT(methodName, "fatal: DOM is null");
            return;
        }
        this.resultErrors = XmlUtil.extractGisErrors(dom);
        if (this.finest) {
            log.debugT(methodName, "result errors: " + this.resultErrors);
        }
        if ((resultAddresses = dom.getElementsByTagName("RESULT_ADDRESS")) == null || resultAddresses.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < resultAddresses.getLength()) {
            Node resultAddressNode = resultAddresses.item(i);
            NamedNodeMap resultAddressAttributes = resultAddressNode.getAttributes();
            if (resultAddressAttributes != null && resultAddressAttributes.getNamedItem("id") != null) {
                NodeList geoAddresses;
                String id = resultAddressAttributes.getNamedItem("id").getNodeValue();
                Vector<ResultAddress> vector = (Vector<ResultAddress>)this.resultMap.get(id);
                if (vector == null) {
                    vector = new Vector<ResultAddress>();
                }
                if ((geoAddresses = resultAddressNode.getChildNodes()) != null && geoAddresses.getLength() != 0) {
                    int j = 0;
                    while (j < geoAddresses.getLength()) {
                        NodeList geoAddressChildren;
                        Node geoAddress = geoAddresses.item(j);
                        NamedNodeMap geoAddressAttributes = geoAddress.getAttributes();
                        String scoreString = null;
                        GeoPosition geoPosition = null;
                        String addressString = null;
                        Address address = null;
                        if (geoAddressAttributes != null) {
                            Node valueNode;
                            Node scoreNode = geoAddressAttributes.getNamedItem("score");
                            if (scoreNode != null) {
                                scoreString = scoreNode.getNodeValue();
                            }
                            if ((valueNode = geoAddressAttributes.getNamedItem("value")) != null) {
                                addressString = valueNode.getNodeValue();
                            }
                        }
                        if ((geoAddressChildren = geoAddress.getChildNodes()) == null) break;
                        int k = 0;
                        while (k < geoAddressChildren.getLength()) {
                            NodeList addressChildren;
                            Node child = geoAddressChildren.item(k);
                            if ("POINT".equals(child.getNodeName())) {
                                NamedNodeMap pointAttributes = child.getAttributes();
                                if (pointAttributes == null) break;
                                Node coordsNode = pointAttributes.getNamedItem("coords");
                                if (coordsNode != null) {
                                    double y;
                                    String coords = coordsNode.getNodeValue();
                                    double z = 0.0;
                                    double x = Double.valueOf(coords.substring(0, coords.indexOf(44)));
                                    if ((coords = coords.substring(coords.indexOf(44) + 1)).indexOf(44) != -1) {
                                        y = Double.valueOf(coords.substring(0, coords.indexOf(44)));
                                        z = Double.valueOf(coords.substring(coords.indexOf(44) + 1));
                                    } else {
                                        y = Double.valueOf(coords);
                                    }
                                    geoPosition = new GeoPosition(x, y, z);
                                }
                            } else if ("ADDRESS".equals(child.getNodeName()) && (addressChildren = child.getChildNodes()) != null) {
                                String number = null;
                                String street = null;
                                String city = null;
                                String region = null;
                                String code = null;
                                String country = null;
                                int l = 0;
                                while (l < addressChildren.getLength()) {
                                    Node addressItem = addressChildren.item(l);
                                    if (addressItem != null && addressItem.hasChildNodes()) {
                                        if ("NUMBER".equals(addressItem.getNodeName())) {
                                            number = addressItem.getFirstChild().getNodeValue();
                                        } else if ("STREET".equals(addressItem.getNodeName())) {
                                            street = addressItem.getFirstChild().getNodeValue();
                                        } else if ("CITY".equals(addressItem.getNodeName())) {
                                            city = addressItem.getFirstChild().getNodeValue();
                                        } else if ("REGION".equals(addressItem.getNodeName())) {
                                            region = addressItem.getFirstChild().getNodeValue();
                                        } else if ("CODE".equals(addressItem.getNodeName())) {
                                            code = addressItem.getFirstChild().getNodeValue();
                                        } else if ("COUNTRY".equals(addressItem.getNodeName())) {
                                            country = addressItem.getFirstChild().getNodeValue();
                                        }
                                    }
                                    ++l;
                                }
                                address = new Address(number, street, city, region, code, country);
                            }
                            ++k;
                        }
                        int score = 0;
                        if (scoreString != null) {
                            try {
                                score = Integer.parseInt(scoreString);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        ResultAddress ra = new ResultAddress(score, geoPosition, addressString, address);
                        if (this.finest) {
                            log.debugT(methodName, "extracted result address: " + ra);
                        }
                        vector.add(ra);
                        ++j;
                    }
                    this.resultMap.put(id, vector);
                }
            }
            ++i;
        }
    }

    protected boolean addParameters() {
        String request = null;
        try {
            request = this.createXml();
        }
        catch (GraphicsException e) {
            return false;
        }
        this.caller.addParameter(PARAM_NAME, request);
        return true;
    }

    protected void clearResults() {
        this.resultErrors = null;
        this.resultMap.clear();
    }

    public boolean execute() {
        this.callIgsIfNecessary();
        return !this.resultMap.isEmpty();
    }

    public void setMaxCandidates(int maxCandidates) {
        this.maxCandidates = maxCandidates;
    }

    public void setMinScore(int minScore) {
        if (minScore > 100) {
            minScore = 100;
        } else if (minScore < 0) {
            minScore = 0;
        }
        this.minScore = minScore;
    }

    public void addAddress(String id, Address address) throws GraphicsException {
        if (this.finest) {
            log.debugT("addAddress", "adding address, id: " + id + "address: " + address);
        }
        this.mustCallIgs = true;
        if (this.addressMap.containsKey(id)) {
            String errorMessage = "fatal: duplicate id for address:" + id;
            log.debugT("addAddress", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        this.addressMap.put(id, address);
    }

    public void clearAddresses() {
        this.mustCallIgs = true;
        this.addressMap.clear();
    }

    public void clearAll() {
        super.clearAll();
        this.mustCallIgs = true;
        this.minScore = -1;
        this.maxCandidates = -1;
        this.clearAddresses();
    }

    public Vector getResultAddresses(String id) {
        this.callIgsIfNecessary();
        return (Vector)this.resultMap.get(id);
    }

    public String getErrors() {
        String retVal = "";
        if (this.igsError != null) {
            retVal = retVal + "igs error: " + this.igsError + " ";
        }
        if (this.resultErrors != null) {
            retVal = retVal + "gis processing returned error: " + this.resultErrors;
        }
        return "".equals(retVal) ? null : retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "GeoCoder";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoCoder == null ? (class$com$sap$tc$graphics$igs$GeoCoder = GeoCoder.class$("com.sap.tc.graphics.igs.GeoCoder")) : class$com$sap$tc$graphics$igs$GeoCoder).getName());
    }

    public static class ResultAddress {
        private int score;
        private GeoPosition geoPosition;
        private String valueString;
        private Address address;

        public ResultAddress(int score, GeoPosition geoPosition, String valueString, Address address) {
            this.score = score;
            this.geoPosition = geoPosition;
            this.valueString = valueString;
            this.address = address;
        }

        public int getScore() {
            return this.score;
        }

        public GeoPosition getGeoPosition() {
            return this.geoPosition;
        }

        public String getValueString() {
            return this.valueString;
        }

        public Address getAddress() {
            return this.address;
        }

        public String toString() {
            return "score:" + this.score + " geoPosition:" + this.geoPosition + " valueString:" + this.valueString + " address:" + this.address;
        }
    }

    public static class Address {
        private String number;
        private String street;
        private String city;
        private String region;
        private String code;
        private String country;

        public Address(String number, String street, String city, String region, String code, String country) {
            this.number = number;
            this.street = street;
            this.city = city;
            this.region = region;
            this.code = code;
            this.country = country;
        }

        public String getNumber() {
            return this.number;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCode() {
            return this.code;
        }

        public String getCountry() {
            return this.country;
        }

        public String toString() {
            return "number:" + this.number + " street:" + this.street + " city:" + this.city + " region:" + this.region + " code:" + this.code + " country:" + this.country;
        }
    }
}

