/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GeoPosition;

public class GeoBorder {
    private double top;
    private double left;
    private double bottom;
    private double right;

    public GeoBorder() {
        this.right = 0.0;
        this.bottom = 0.0;
        this.left = 0.0;
        this.top = 0.0;
    }

    public GeoBorder(double left, double top, double right, double bottom) {
        this.top = top;
        this.left = left;
        this.right = right;
        this.bottom = bottom;
    }

    public GeoBorder(GeoPosition topLeft, GeoPosition bottomRight) {
        this.top = topLeft.getLatitude();
        this.left = topLeft.getLongitude();
        this.bottom = bottomRight.getLatitude();
        this.right = bottomRight.getLongitude();
    }

    public GeoBorder(GeoBorder srcBorder) {
        this.top = srcBorder.top;
        this.left = srcBorder.left;
        this.bottom = srcBorder.bottom;
        this.right = srcBorder.right;
    }

    public double getTop() {
        return this.top;
    }

    public double getLeft() {
        return this.left;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getRight() {
        return this.right;
    }

    public void setBorder(double left, double top, double right, double bottom) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public void moveBorder(double x, double y) {
        this.left += x;
        this.right += x;
        this.top += y;
        this.bottom += y;
    }

    public void setBorder(GeoPosition topLeft, GeoPosition bottomRight) {
        this.top = topLeft.getLatitude();
        this.left = topLeft.getLongitude();
        this.bottom = bottomRight.getLatitude();
        this.right = bottomRight.getLongitude();
    }

    public void setBorderEmpty() {
        this.right = 0.0;
        this.bottom = 0.0;
        this.left = 0.0;
        this.top = 0.0;
    }

    public double width() {
        return this.right - this.left;
    }

    public double height() {
        return this.top - this.bottom;
    }

    public GeoPosition topLeft() {
        return new GeoPosition(this.left, this.top);
    }

    public GeoPosition bottomRight() {
        return new GeoPosition(this.right, this.bottom);
    }

    public void normalizeBorder() {
        double swap;
        if (this.right < this.left) {
            swap = this.right;
            this.right = this.left;
            this.left = swap;
        }
        if (this.bottom > this.top) {
            swap = this.bottom;
            this.bottom = this.top;
            this.top = swap;
        }
    }

    public boolean isBorderEmpty() {
        return this.left == 0.0 && this.top == 0.0 && this.right == 0.0 && this.bottom == 0.0;
    }

    public boolean equals(GeoBorder border) {
        return this.left == border.left && this.top == border.top && this.right == border.right && this.bottom == border.bottom;
    }

    public boolean positionInBorder(GeoPosition pos) {
        return pos.getLatitude() <= this.top && pos.getLatitude() >= this.bottom && pos.getLongitude() >= this.left && pos.getLongitude() <= this.right;
    }

    public void unionBorder(GeoBorder border) {
        if (border.top > this.top) {
            this.top = border.top;
        }
        if (border.left < this.left) {
            this.left = border.left;
        }
        if (border.bottom < this.bottom) {
            this.bottom = border.bottom;
        }
        if (border.right > this.right) {
            this.right = border.right;
        }
    }

    public void intersectBorder(GeoBorder border) {
        if (border.top < this.top) {
            this.top = border.top;
        }
        if (border.left > this.left) {
            this.left = border.left;
        }
        if (border.bottom > this.bottom) {
            this.bottom = border.bottom;
        }
        if (border.right < this.right) {
            this.right = border.right;
        }
    }

    public boolean intersectBorder(GeoBorder border1, GeoBorder border2) {
        if ((border1.left <= border2.right && border1.left >= border2.left || border1.right <= border2.right && border1.right >= border2.left || border1.left >= border2.left && border1.right <= border2.right || border1.left <= border2.left && border1.right >= border2.right) && (border1.top >= border2.bottom && border1.top <= border2.top || border1.bottom >= border2.bottom && border1.bottom <= border2.top || border1.top <= border2.top && border1.bottom >= border2.bottom || border1.top >= border2.top && border1.bottom <= border2.bottom)) {
            this.left = border1.left >= border2.left ? border1.left : border2.left;
            this.top = border1.top <= border2.top ? border1.top : border2.top;
            this.right = border1.right <= border2.right ? border1.right : border2.right;
            this.bottom = border1.bottom >= border2.bottom ? border1.bottom : border2.bottom;
            return true;
        }
        this.bottom = 0.0;
        this.right = 0.0;
        this.top = 0.0;
        this.left = 0.0;
        return false;
    }

    public GeoPosition centerPosition() {
        return new GeoPosition((this.left + this.right) / 2.0, (this.bottom + this.top) / 2.0);
    }

    public String toString() {
        return "top:" + this.top + " left:" + this.left + " bottom:" + this.bottom + " right:" + this.right;
    }
}

