/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.CallIgs;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IgsComponent;
import com.sap.tc.graphics.igs.IgsImageComponent;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Converter
extends IgsComponent {
    public static final String DEFAULT_ID = "0";
    private static Location log;
    private static String className;
    private String resultErrors;
    private String sourceUrl;
    private int width;
    private int height;
    private InputFormat inputFormat;
    private OutputFormat outputFormat;
    private HashMap results;
    private ArrayList orderedKeys;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$GeoViewer;

    public Converter() {
        this.finest = log.beLogged(100);
        this.interpreterName = "IMGCONV";
        this.results = new HashMap();
        this.orderedKeys = new ArrayList();
    }

    public void clearAll() {
        super.clearAll();
        this.inputFormat = null;
        this.outputFormat = null;
        this.height = 0;
        this.width = 0;
        this.sourceUrl = null;
    }

    protected void clearResults() {
        this.igsError = null;
        this.resultErrors = null;
        this.results.clear();
        this.orderedKeys.clear();
    }

    private String createXml() throws GraphicsException {
        Document dom = XmlUtil.initRoot("IMAGE", "1.0");
        if (this.width != 0) {
            XmlUtil.appendNode(dom.getDocumentElement(), "WIDTH", String.valueOf(this.width));
        }
        if (this.height != 0) {
            XmlUtil.appendNode(dom.getDocumentElement(), "HEIGHT", String.valueOf(this.height));
        }
        if (this.inputFormat == null) {
            throw new GraphicsException("no input format specified");
        }
        XmlUtil.appendNode(dom.getDocumentElement(), "INPUT", this.inputFormat.format);
        if (this.outputFormat == null) {
            throw new GraphicsException("no output format specified");
        }
        XmlUtil.appendNode(dom.getDocumentElement(), "OUTPUT", this.outputFormat.format);
        if (this.sourceUrl == null) {
            throw new GraphicsException("no source url for image specified");
        }
        XmlUtil.appendNode(dom.getDocumentElement(), "GET_URL", this.sourceUrl);
        return XmlUtil.serialize(dom);
    }

    protected boolean addParameters() {
        String request = null;
        try {
            request = this.createXml();
        }
        catch (GraphicsException e) {
            log.debugT("addParameters", "fatal: failed to add parameters: " + Util.extractCallstack(e));
            return false;
        }
        this.caller.addParameter("META", request);
        return true;
    }

    private void extractImages(Document dom) {
        String methodName = "extractImages";
        NodeList imageNodeList = dom.getElementsByTagName("IMAGE");
        if (imageNodeList == null || imageNodeList.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < imageNodeList.getLength()) {
            Node imageNode = imageNodeList.item(i);
            NamedNodeMap imageNodeAttributes = imageNode.getAttributes();
            try {
                String id = imageNodeAttributes.getNamedItem("id").getNodeValue();
                String urlString = imageNodeAttributes.getNamedItem("url").getNodeValue();
                String type = imageNodeAttributes.getNamedItem("type").getNodeValue();
                OutputFormat format = OutputFormat.formatForString(type);
                ConvertResult result = new ConvertResult(urlString, format);
                this.results.put(id, result);
                this.orderedKeys.add(id);
            }
            catch (DOMException e) {
                log.debugT("extractImages", "warning: failed to extract attribute from node " + imageNode + " after imageConversion: " + Util.extractCallstack(e));
            }
            catch (NullPointerException e) {
                log.debugT("extractImages", "warning: failed to extract attribute from node " + imageNode + " after imageConversion: " + Util.extractCallstack(e));
            }
            catch (GraphicsException e) {
                log.debugT("extractImages", "warning: unsupported format returned after imageConversion: " + Util.extractCallstack(e));
            }
            ++i;
        }
    }

    protected void extractResults() {
        String methodName = "extractResults";
        String result = this.caller.getResult("META");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.debugT(methodName, "fatal: ParserConfiguration error: " + Util.extractCallstack(e));
            return;
        }
        Document dom = null;
        try {
            dom = builder.parse(this.igsUrl.toString() + result);
            if (this.finest) {
                log.debugT(methodName, "result: " + XmlUtil.serialize(dom));
            }
        }
        catch (IOException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        catch (SAXException e) {
            log.debugT(methodName, "fatal: Could not create DOM: " + Util.extractCallstack(e));
            return;
        }
        this.resultErrors = XmlUtil.extractGisErrors(dom);
        if (this.finest) {
            log.debugT(methodName, "result errors: " + this.resultErrors);
        }
        this.extractImages(dom);
    }

    public String getErrors() {
        String retVal = "";
        if (this.igsError != null) {
            retVal = retVal + "igs error: " + this.igsError + " ";
        }
        if (this.resultErrors != null) {
            retVal = retVal + "gis processing returned error: " + this.resultErrors;
        }
        return "".equals(retVal) ? null : retVal;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSourceUrlString(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public void setInputFormat(InputFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean execute() {
        this.callIgsIfNecessary();
        return !this.results.isEmpty();
    }

    public Image getImage(String id) {
        try {
            return IgsImageComponent.byteArrayToImage(this.getImageAsByteArray(id));
        }
        catch (GraphicsException e) {
            String errorMessage = e.getMessage();
            this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
            return null;
        }
    }

    public Image getImage() {
        return this.getImage(DEFAULT_ID);
    }

    private ConvertResult getResultForId(String id) throws GraphicsException {
        String methodName = "getResultForId";
        if (id == null) {
            String errorMessage = "fatal: id for image is null";
            log.debugT("getResultForId", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        this.callIgsIfNecessary();
        ConvertResult convertResult = (ConvertResult)this.results.get(id);
        if (convertResult == null) {
            String errorMessage = "fatal: could not find result for id: " + id + ", return error image instead";
            log.debugT("getResultForId", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        return convertResult;
    }

    public List getResultIds() throws GraphicsException {
        String methodName = "getResultIds";
        this.callIgsIfNecessary();
        if (this.orderedKeys.isEmpty()) {
            String errorMessage = "fatal: no results";
            log.debugT("getResultIds", errorMessage);
            throw new GraphicsException(errorMessage);
        }
        return this.orderedKeys;
    }

    public byte[] getImageAsByteArray(String id) {
        String methodName = "getImageAsByteArray";
        ConvertResult convertResult = null;
        try {
            convertResult = this.getResultForId(id);
        }
        catch (GraphicsException e) {
            log.debugT("getImageAsByteArray", "fatal: could not find result for id: " + id + ", return error image instead");
            try {
                return IgsImageComponent.getErrorImage();
            }
            catch (GraphicsException ex) {
                log.debugT("getImageAsByteArray", "fatal: could not retrieve error image");
                return null;
            }
        }
        if (convertResult.image != null) {
            return convertResult.image;
        }
        try {
            CallIgs.Result result = this.caller.getBytesFromIgsUrl(this.igsUrl, convertResult.imageUrl);
            if (result != null && result.getBytes() != null) {
                ConvertResult.access$402(convertResult, result.getBytes());
                return convertResult.image;
            }
            String errorMessage = "fatal: igs get image call returned null, igsUrl:" + this.igsUrl + " imageUrl: " + convertResult.imageUrl;
            log.debugT("getImageAsByteArray", errorMessage);
            return null;
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: retrieval of image from url failed: " + convertResult.imageUrl + " exception caught: " + Util.extractCallstack(e);
            this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
            log.debugT("getImageAsByteArray", errorMessage);
            log.debugT("getImageAsByteArray", "fatal: could not generate image, return error image instead");
            return null;
        }
    }

    public byte[] getImageAsByteArray() {
        return this.getImageAsByteArray(DEFAULT_ID);
    }

    public String getImageUrlString(String id) {
        try {
            ConvertResult convertResult = this.getResultForId(id);
            return convertResult.imageUrl;
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: could not retrieve imageUrlString for id: " + id + ", exception caught: " + Util.extractCallstack(e);
            log.debugT("getImageUrlString", errorMessage);
            return null;
        }
    }

    public String getImageUrlString() {
        return this.getImageUrlString(DEFAULT_ID);
    }

    public String getMimeType(String id) {
        String methodName = "getMimeType";
        try {
            ConvertResult convertResult = this.getResultForId(id);
            if (convertResult.outputFormat != null) {
                return convertResult.outputFormat.format;
            }
            log.debugT("getMimeType", "fatal: could not retrieve mime type for id: " + id);
            return null;
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: could not retrieve mime type for id: " + id + ", exception caught: " + Util.extractCallstack(e);
            log.debugT("getMimeType", errorMessage);
            return null;
        }
    }

    public String getMimeType() {
        return this.getMimeType(DEFAULT_ID);
    }

    public OutputFormat getOutputFormat(String id) {
        try {
            return this.getResultForId(id).outputFormat;
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: could not retrieve outputFormat for id: " + id + ", exception caught: " + Util.extractCallstack(e);
            log.debugT("getOutputFormat", errorMessage);
            return null;
        }
    }

    public OutputFormat getOutputFormat() {
        return this.getOutputFormat(DEFAULT_ID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "Converter";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$GeoViewer == null ? (class$com$sap$tc$graphics$igs$GeoViewer = Converter.class$("com.sap.tc.graphics.igs.GeoViewer")) : class$com$sap$tc$graphics$igs$GeoViewer).getName());
    }

    private final class ConvertResult {
        private byte[] image;
        private String imageUrl;
        private int imageType;
        private OutputFormat outputFormat;

        private ConvertResult(String imageUrl, OutputFormat outputFormat) {
            this.imageUrl = imageUrl;
            this.outputFormat = outputFormat;
        }

        static /* synthetic */ byte[] access$402(ConvertResult x0, byte[] x1) {
            x0.image = x1;
            return x1;
        }
    }

    public static final class OutputFormat {
        public static OutputFormat GIF = new OutputFormat("image/gif");
        public static OutputFormat BMP = new OutputFormat("image/x-ms-bmp");
        public static OutputFormat PNG = new OutputFormat("image/png");
        public static OutputFormat JPG = new OutputFormat("image/jpeg");
        private String format;

        private OutputFormat(String format) {
            this.format = format;
        }

        private static OutputFormat formatForString(String format) throws GraphicsException {
            if (format == null) {
                throw new GraphicsException("unsupported format: null");
            }
            if (OutputFormat.GIF.format.equalsIgnoreCase(format)) {
                return GIF;
            }
            if (OutputFormat.BMP.format.equalsIgnoreCase(format)) {
                return BMP;
            }
            if (OutputFormat.PNG.format.equalsIgnoreCase(format)) {
                return PNG;
            }
            if (OutputFormat.JPG.format.equalsIgnoreCase(format)) {
                return JPG;
            }
            throw new GraphicsException("unsupported format: " + format);
        }

        public String toString() {
            return this.format;
        }
    }

    public static final class InputFormat {
        public static InputFormat TIFF = new InputFormat("image/tiff");
        public static InputFormat GIF = new InputFormat("image/gif");
        public static InputFormat BMP = new InputFormat("image/x-ms-bmp");
        public static InputFormat PNG = new InputFormat("image/png");
        public static InputFormat JPG = new InputFormat("image/jpeg");
        private String format;

        private InputFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }
    }
}

