/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IChartCustomizing;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ChartCustomizing
implements IChartCustomizing {
    public static final String GLOBAL_SETTINGS_NODE_NAME = "GlobalSettings";
    public static final String DEFAULTS_NODE_NAME = "Defaults";
    public static final String ELEMENTS_NODE_NAME = "Elements";
    public static final String CHART_ELEMENTS_NODE_NAME = "ChartElements";
    public static final String TITLE_NODE_NAME = "Title";
    public static final String BACKGROUND_NODE_NAME = "Background";
    public static final String LEGEND_NODE_NAME = "Legend";
    public static final String PLOT_AREA_NODE_NAME = "PlotArea";
    public static final String TEXT_NODE_NAME = "Text";
    public static final String CAPTION_NODE_NAME = "Caption";
    public static final String SIZE_NODE_NAME = "Size";
    public static final String ALIGNMENT_NODE_NAME = "Alignment";
    public static final String WIDTH_NODE_NAME = "Width";
    public static final String HEIGHT_NODE_NAME = "Height";
    public static final String FORMAT_NODE_NAME = "FileType";
    public static final String DIMENSION_NODE_NAME = "Dimension";
    public static final String LANGUAGE_NODE_NAME = "Language";
    public static final String CHART_TYPE_NODE_NAME = "ChartType";
    public static final String FONT_FAMILY_NODE_NAME = "FontFamily";
    public static final String TRANSPARENT_COLOR_NODE_NAME = "TransparentColor";
    public static final String COLOR_NODE_NAME = "Color";
    public static final String POINT_NODE_NAME = "Point";
    private static Location log;
    private boolean finest = log.beLogged(100);
    private static String className;
    private String width;
    private String height;
    private String format;
    private String dimension;
    private String language;
    private String chartType;
    private String fontFamily;
    private String transparentColor;
    private String titleCaption = null;
    private String titleColor = null;
    private String titleSize = null;
    private String plotAreaColor = null;
    private String backgroundColor = null;
    private String legendPosition = null;
    private Vector cuStrings = new Vector();
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$ChartCustomizing;

    public void clearConvenienceTags() {
        this.transparentColor = null;
        this.fontFamily = null;
        this.chartType = null;
        this.language = null;
        this.dimension = null;
        this.format = null;
        this.height = null;
        this.width = null;
        this.legendPosition = null;
        this.backgroundColor = null;
        this.plotAreaColor = null;
        this.titleSize = null;
        this.titleColor = null;
        this.titleCaption = null;
    }

    public void clearCuStrings() {
        this.cuStrings.clear();
    }

    public void addCuString(String cuString) {
        if (cuString != null && !"".equals(cuString)) {
            this.cuStrings.add(cuString);
        }
    }

    public void setWidth(String width) {
        this.width = "".equals(width) ? null : width;
    }

    public void setHeight(String height) {
        this.height = "".equals(height) ? null : height;
    }

    public void setFormat(String format) {
        this.format = "".equals(format) ? null : format;
    }

    public void setDimension(String dimension) {
        this.dimension = "".equals(dimension) ? null : dimension;
    }

    public void setLanguage(String language) {
        this.language = "".equals(language) ? null : language;
    }

    public void setChartType(String chartType) {
        this.chartType = "".equals(chartType) ? null : chartType;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = "".equals(fontFamily) ? null : fontFamily;
    }

    public void setTransparentColor(String transparentColor) {
        this.transparentColor = "".equals(transparentColor) ? null : transparentColor;
    }

    public void setTitleCaption(String titleCaption) {
        this.titleCaption = titleCaption;
    }

    public void setTitleColor(String titleColor) {
        this.titleColor = "".equals(titleColor) ? null : titleColor;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = "".equals(titleSize) ? null : titleSize;
    }

    public void setPlotAreaColor(String plotAreaColor) {
        this.plotAreaColor = "".equals(plotAreaColor) ? null : plotAreaColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = "".equals(backgroundColor) ? null : backgroundColor;
    }

    public void setLegendPosition(String legendPosition) {
        this.legendPosition = "".equals(legendPosition) ? null : legendPosition;
    }

    private void createGlobalSettings(Document document) throws GraphicsException {
        String methodName = "createGlobalSettings";
        if (document == null) {
            log.debugT(methodName, "fatal: document == null");
            return;
        }
        if (this.width == null && this.height == null && this.format == null && this.dimension == null && this.language == null && this.chartType == null && this.fontFamily == null && this.transparentColor == null) {
            log.infoT(methodName, "no convenience tags set");
            return;
        }
        try {
            Node globalSettings = XmlUtil.appendNode(document.getDocumentElement(), GLOBAL_SETTINGS_NODE_NAME);
            if (this.chartType != null || this.fontFamily != null) {
                Node defaultsNode = XmlUtil.appendNode(globalSettings, DEFAULTS_NODE_NAME);
                if (this.chartType != null) {
                    XmlUtil.appendNode(defaultsNode, CHART_TYPE_NODE_NAME, this.chartType);
                }
                if (this.fontFamily != null) {
                    XmlUtil.appendNode(defaultsNode, FONT_FAMILY_NODE_NAME, this.fontFamily);
                }
            }
            if (this.width != null) {
                XmlUtil.appendNode(globalSettings, WIDTH_NODE_NAME, this.width);
            }
            if (this.height != null) {
                XmlUtil.appendNode(globalSettings, HEIGHT_NODE_NAME, this.height);
            }
            if (this.format != null) {
                XmlUtil.appendNode(globalSettings, FORMAT_NODE_NAME, this.format);
            }
            if (this.dimension != null) {
                XmlUtil.appendNode(globalSettings, DIMENSION_NODE_NAME, this.dimension);
            }
            if (this.language != null) {
                XmlUtil.appendNode(globalSettings, LANGUAGE_NODE_NAME, this.language);
            }
            if (this.transparentColor != null) {
                XmlUtil.appendNode(globalSettings, TRANSPARENT_COLOR_NODE_NAME, this.transparentColor);
            }
        }
        catch (GraphicsException e) {
            log.debugT(methodName, "fatal: appendNode failed");
            throw e;
        }
    }

    private void createElementSettings(Document document) throws GraphicsException {
        String methodName = "createElementSettings";
        if (document == null) {
            log.debugT(methodName, "fatal: document == null");
            return;
        }
        if (this.titleCaption == null && this.titleColor == null && this.titleSize == null && this.plotAreaColor == null && this.backgroundColor == null && this.legendPosition == null) {
            log.infoT(methodName, "no convenience tags set");
            return;
        }
        try {
            Node elementsNode = XmlUtil.appendNode(document.getDocumentElement(), ELEMENTS_NODE_NAME);
            Node chartElementsNode = XmlUtil.appendNode(elementsNode, CHART_ELEMENTS_NODE_NAME);
            if (this.titleColor != null || this.titleSize != null || this.titleCaption != null) {
                Node titleNode = XmlUtil.appendNode(chartElementsNode, TITLE_NODE_NAME);
                if (this.titleCaption != null) {
                    XmlUtil.appendNode(titleNode, CAPTION_NODE_NAME, this.titleCaption);
                }
                if (this.titleColor != null || this.titleSize != null) {
                    Node textNode = XmlUtil.appendNode(titleNode, TEXT_NODE_NAME);
                    if (this.titleColor != null) {
                        XmlUtil.appendNode(textNode, COLOR_NODE_NAME, this.titleColor);
                    }
                    if (this.titleSize != null) {
                        XmlUtil.appendNode(textNode, SIZE_NODE_NAME, this.titleSize);
                    }
                }
            }
            if (this.plotAreaColor != null) {
                Node plotAreaNode = XmlUtil.appendNode(chartElementsNode, PLOT_AREA_NODE_NAME);
                XmlUtil.appendNode(plotAreaNode, COLOR_NODE_NAME, this.plotAreaColor);
            }
            if (this.backgroundColor != null) {
                Node backgroundNode = XmlUtil.appendNode(chartElementsNode, BACKGROUND_NODE_NAME);
                XmlUtil.appendNode(backgroundNode, COLOR_NODE_NAME, this.backgroundColor);
            }
            if (this.legendPosition != null) {
                Node legendNode = XmlUtil.appendNode(chartElementsNode, LEGEND_NODE_NAME);
                XmlUtil.appendNode(legendNode, ALIGNMENT_NODE_NAME, this.legendPosition);
            }
        }
        catch (GraphicsException e) {
            log.debugT(methodName, "fatal: appendNode failed");
            throw e;
        }
    }

    public String createConvenienceString() {
        String methodName = "createConvenienceString";
        Document document = null;
        try {
            document = XmlUtil.initRoot("SAPChartCustomizing", "1.0");
        }
        catch (GraphicsException e) {
            log.debugT(methodName, "fatal: initXmlCustomizing() failed");
            return null;
        }
        try {
            this.createGlobalSettings(document);
        }
        catch (GraphicsException e) {
            log.debugT(methodName, "fatal: failed to create global settings");
            return null;
        }
        try {
            this.createElementSettings(document);
        }
        catch (GraphicsException e) {
            log.debugT(methodName, "fatal: failed to create element settings");
            return null;
        }
        String retVal = XmlUtil.serialize(document);
        if (this.finest) {
            log.debugT(methodName, "global and element settings: " + retVal);
        }
        return retVal;
    }

    public List getCuList() {
        Vector<String> v = new Vector<String>(this.cuStrings);
        v.add(this.createConvenienceString());
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "ChartCustomizing";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$ChartCustomizing == null ? (class$com$sap$tc$graphics$igs$ChartCustomizing = ChartCustomizing.class$("com.sap.tc.graphics.igs.ChartCustomizing")) : class$com$sap$tc$graphics$igs$ChartCustomizing).getName());
    }
}

