/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.CallIgs;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IChartCustomizing;
import com.sap.tc.graphics.igs.IChartData;
import com.sap.tc.graphics.igs.IgsImageComponent;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.List;

public class Chart
extends IgsImageComponent {
    private static final String IMAGE = "Picture";
    private static final String ERROR = "Errors";
    private static final String IMAGE_MAP = "ImageMap";
    private static final String DATA = "DATA";
    private static final String CUSTOM = "CUSTOM";
    private String errorUrl;
    protected String imageMapUrl;
    private String imageMapBytesError;
    private IChartData data;
    private IChartCustomizing custom;
    private static Location log;
    private static String className;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$Chart;

    public Chart() {
        this.finest = log.beLogged(100);
        this.interpreterName = "XMLCHART";
        this.imageType = -1;
    }

    public void clearAll() {
        super.clearAll();
        this.data = null;
        this.custom = null;
    }

    protected void clearResults() {
        super.clearResults();
        this.imageMapUrl = null;
        this.errorUrl = null;
    }

    protected boolean addParameters() {
        String dataXml;
        String string = dataXml = this.data != null ? this.data.getData() : null;
        if (dataXml == null) {
            String errorMessage = "fatal: Trying to call igs, but no data was set";
            this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
            log.debugT("addParameters", errorMessage);
            return false;
        }
        this.caller.addParameter(DATA, dataXml);
        if (this.custom != null) {
            List cuList = this.custom.getCuList();
            int i = 0;
            if (cuList != null) {
                Iterator it = cuList.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (s == null) continue;
                    this.caller.addParameter(CUSTOM + i, s);
                    ++i;
                }
            }
        }
        return true;
    }

    protected void extractResults() {
        this.imageUrl = this.caller.getResult(IMAGE);
        this.imageMapUrl = this.caller.getResult(IMAGE_MAP);
        this.errorUrl = this.caller.getResult(ERROR);
        if (this.finest) {
            log.debugT("extractResults", "imageUrl: " + this.imageUrl);
            log.debugT("extractResults", "imageMapUrl: " + this.imageMapUrl);
            log.debugT("extractResults", "errorUrl: " + this.errorUrl);
        }
        if (this.imageUrl == null) {
            log.debugT("extractResults", "fatal: IGS did not deliver an image.");
        }
    }

    public void setData(IChartData data) {
        this.mustCallIgs = true;
        this.data = data;
    }

    public void setCustomizing(IChartCustomizing custom) {
        this.mustCallIgs = true;
        this.custom = custom;
    }

    public String getErrorsUrlString() {
        this.callIgsIfNecessary();
        return this.errorUrl;
    }

    public String getErrors() {
        String methodName = "getErrors";
        this.callIgsIfNecessary();
        String retVal = this.igsError;
        if (this.errorUrl != null) {
            try {
                CallIgs.Result result = this.caller.getBytesFromIgsUrl(this.igsUrl, this.errorUrl);
                if (result != null) {
                    String string = retVal = retVal == null ? new String(result.getBytes()) : retVal + " " + new String(result.getBytes());
                    if (log.beLogged(100)) {
                        log.debugT(methodName, "imageMap: " + retVal);
                    }
                }
            }
            catch (GraphicsException e) {
                log.debugT(methodName, "fatal: retrieval of errors from url failed" + this.errorUrl);
            }
        }
        if (this.finest) {
            log.debugT(methodName, "errors: " + retVal);
        }
        return retVal;
    }

    public byte[] getErrorsAsByteArray() {
        String retVal = this.getErrors();
        return retVal == null ? null : retVal.getBytes();
    }

    public String getImageMapUrlString() {
        this.callIgsIfNecessary();
        if (this.finest) {
            log.debugT("getImageMapUrlString", "imageMapUrl: " + this.imageMapUrl);
        }
        return this.imageMapUrl;
    }

    public String getImageMap() {
        byte[] imageMapBytes = this.getImageMapAsByteArray();
        return imageMapBytes == null ? null : new String(imageMapBytes);
    }

    public byte[] getImageMapAsByteArray() {
        String methodName = "getImageMapAsByteArray";
        this.callIgsIfNecessary();
        if (this.imageMapUrl != null) {
            try {
                CallIgs.Result result = this.caller.getBytesFromIgsUrl(this.igsUrl, this.imageMapUrl);
                if (result != null) {
                    byte[] retVal = result.getBytes();
                    if (this.finest) {
                        log.debugT(methodName, "imageMap: " + new String(retVal));
                    }
                    return retVal;
                }
                String errorMessage = "fatal: igs get image map call returned null, igsUrl:" + this.igsUrl + " imageMapUrl: " + this.imageMapUrl;
                log.debugT(methodName, errorMessage);
            }
            catch (GraphicsException e) {
                this.imageMapBytesError = "fatal: retrieval of image map from url failed" + this.imageMapUrl;
                log.debugT(methodName, this.imageMapBytesError);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "Chart";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$Chart == null ? (class$com$sap$tc$graphics$igs$Chart = Chart.class$("com.sap.tc.graphics.igs.Chart")) : class$com$sap$tc$graphics$igs$Chart).getName());
    }
}

