/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

class CallIgs {
    private static Location log;
    private static String className;
    private static BitSet dontNeedEncoding;
    private static final int caseDiff = 32;
    private boolean finest = log.beLogged(100);
    private URL url;
    private String query;
    private String result;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$CallIgs;

    CallIgs() {
    }

    void setUrl(URL url) {
        this.url = url;
        if (this.finest) {
            log.debugT("setUrl", "igs url set: " + url);
        }
    }

    void setUrl(URL url, String s) {
        try {
            this.setUrl(new URL(url, s));
        }
        catch (MalformedURLException e) {
            String errorMessage = "error: Trying to set igs, with faulty values - url: " + url + "s: " + s + "message: " + Util.extractCallstack(e);
            log.debugT("setUrl", errorMessage);
            return;
        }
    }

    void addParameter(String name, String value) {
        if (this.finest) {
            log.debugT("addParameter", "Adding post parameter - name: " + name + " value: " + value);
        }
        if (name == null || value == null) {
            return;
        }
        this.query = this.query == null ? name + "=" + Util.encode(value) : this.query + "&" + name + "=" + Util.encode(value);
    }

    void clearParameters() {
        this.query = null;
    }

    void execute() throws GraphicsException {
        String methodName = "execute";
        this.result = null;
        if (this.url == null) {
            String errorMessage = "fatal: no url set";
            log.debugT(methodName, errorMessage);
            throw new GraphicsException(errorMessage);
        }
        if (log.beLogged(300)) {
            log.infoT(methodName, "used URL: " + this.url.toExternalForm());
        }
        if (this.query == null) {
            String errorMessage = "fatal: no post data";
            log.debugT(methodName, errorMessage);
            throw new GraphicsException(errorMessage);
        }
        if (log.beLogged(300)) {
            try {
                log.infoT(methodName, "Body of post to IGS non-encoded:\n" + Util.decode(this.query));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.finest) {
            log.debugT(methodName, "Body of post to IGS url-encoded:\n" + this.query);
        }
        byte[] bytes = null;
        try {
            bytes = this.query.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setAllowUserInteraction(false);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-length", Integer.toString(bytes.length));
            OutputStream postStream = connection.getOutputStream();
            postStream.write(bytes);
            postStream.close();
        }
        catch (IOException e) {
            String errorMessage = "fatal: Calling IGS (URL: " + this.url.toExternalForm() + ") failed. Error: " + Util.extractCallstack(e);
            log.debugT(methodName, errorMessage);
            throw new GraphicsException(errorMessage);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            String errorMessage = "fatal: getResponseCode failed. Error: " + Util.extractCallstack(e);
            log.debugT(methodName, errorMessage);
            throw new GraphicsException(errorMessage);
        }
        try {
            String errorMessage;
            this.result = "";
            InputStreamReader in = new InputStreamReader(connection.getInputStream());
            if (in != null) {
                BufferedReader resultReader = new BufferedReader(in);
                String line = null;
                while ((line = resultReader.readLine()) != null) {
                    this.result = this.result + line;
                }
            }
            in.close();
            connection.disconnect();
            if (responseCode != 200) {
                errorMessage = "fatal: HTTP error: " + responseCode + " result:" + this.result;
                log.debugT(methodName, errorMessage);
                throw new GraphicsException(errorMessage);
            }
            if (this.finest) {
                log.debugT(methodName, "Call to IGS successful, result:" + this.result);
            }
            if ("".equals(this.result)) {
                this.result = null;
                errorMessage = "fatal: IGS generated empty result.";
                log.debugT(methodName, errorMessage);
                throw new GraphicsException(errorMessage);
            }
        }
        catch (IOException e) {
            connection.disconnect();
            String errorMessage = "fatal: IOException caught while trying to read IGS result: " + Util.extractCallstack(e);
            log.debugT(methodName, errorMessage);
            throw new GraphicsException(errorMessage);
        }
    }

    String getResult(String name) {
        String methodName = "getResult";
        if (this.finest) {
            log.debugT(methodName, "trying to read result: name=" + name);
        }
        if (name == null) {
            return null;
        }
        if (this.result == null) {
            log.debugT(methodName, "fatal: result is null");
            return null;
        }
        int nameIndex = this.result.indexOf(name);
        if (nameIndex == -1) {
            log.infoT(methodName, "name \"" + name + "\" not found in result");
            return null;
        }
        int hrefIndex = this.result.indexOf("href", nameIndex);
        if (hrefIndex == -1) {
            log.debugT(methodName, "fatal: no href found after \"" + name + "\".");
            return null;
        }
        int beginIndex = this.result.indexOf(34, hrefIndex) + 1;
        int endIndex = this.result.indexOf(34, beginIndex);
        if (hrefIndex == -1) {
            log.debugT(methodName, "fatal: no \" found after href.");
            return null;
        }
        String retVal = this.result.substring(beginIndex, endIndex);
        if (this.finest) {
            log.debugT(methodName, "name: " + name + " retVal: " + retVal);
        }
        return retVal;
    }

    Result getBytesFromIgsUrl(URL igsUrl, String subString) throws GraphicsException {
        if (igsUrl == null || subString == null) {
            String errorMesssage = "fatal: invalid url (null)";
            log.debugT("getBytesFromIgsUrl", errorMesssage);
            throw new GraphicsException(errorMesssage);
        }
        URL url = null;
        try {
            url = new URL(igsUrl, subString);
        }
        catch (MalformedURLException e) {
            String errorMesssage = "fatal: invalid url - igsUrl:" + igsUrl + " subURL:" + subString;
            log.debugT("getBytesFromIgsUrl", errorMesssage);
            throw new GraphicsException(errorMesssage);
        }
        HttpURLConnection connection = null;
        try {
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                InputStream is = connection.getInputStream();
                byte[] buffer = Util.readCompleteStream(is);
                String mimeType = connection.getContentType();
                Result result = new Result(buffer, mimeType);
                Object var10_14 = null;
                if (connection != null) {
                    connection.disconnect();
                }
                return result;
            }
            catch (IOException e) {
                String errorMessage = "fatal: Can not read content of url from IGS - igsUrl:" + igsUrl + " subURL:" + subString + " message:" + Util.extractCallstack(e);
                log.debugT("getBytesFromIgsUrl", errorMessage);
                throw new GraphicsException(errorMessage);
            }
        }
        catch (Throwable throwable) {
            block8: {
                Object var10_15 = null;
                if (connection == null) break block8;
                connection.disconnect();
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "CallIgs";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$CallIgs == null ? (class$com$sap$tc$graphics$igs$CallIgs = CallIgs.class$("com.sap.tc.graphics.igs.CallIgs")) : class$com$sap$tc$graphics$igs$CallIgs).getName());
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    static class Result {
        private byte[] bytes;
        private String mimeType;

        Result(byte[] bytes, String mimeType) {
            this.bytes = bytes;
            this.mimeType = mimeType;
        }

        byte[] getBytes() {
            return this.bytes;
        }

        String getMimeType() {
            return this.mimeType;
        }
    }
}

