/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.util.viewset;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.ViewContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Caption;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.CellHAlign;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.CellVAlign;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Tab;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TabStrip;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TransparentContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewContainerUIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.component.viewset.Placeholder;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewArea;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewContainerAssignment;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.metamodel.webdynpro.component.viewset.Viewset;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetHierarchyNode;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.tc.logging.Location;
import java.util.HashMap;

public class ServiceViewSetGeneration {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$generation$util$viewset$ServiceViewSetGeneration == null ? (class$com$sap$ide$webdynpro$generation$util$viewset$ServiceViewSetGeneration = ServiceViewSetGeneration.class$("com.sap.ide.webdynpro.generation.util.viewset.ServiceViewSetGeneration")) : class$com$sap$ide$webdynpro$generation$util$viewset$ServiceViewSetGeneration).getName());
    public static final String GENPREFIX = "_";
    private static final String GRIDLAYOUT = "GridLayout";
    private static final String TLAYOUT = "TLayout";
    private static final String TLAYOUT90 = "TLayout90";
    private static final String TLAYOUT180 = "TLayout180";
    private static final String TLAYOUT270 = "TLayout270";
    private static final String TABSTRIP = "TabStrip";
    private static final String TOP = "Top";
    private static final String BOTTOM = "Bottom";
    private static final String LEFT = "Left";
    private static final String RIGHT = "Right";
    private static final String HSP = "HorizontalSashPosition";
    private static final String VSP = "VerticalSashPosition";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$generation$util$viewset$ServiceViewSetGeneration;

    protected ServiceViewSetGeneration() {
    }

    public static HashMap transferViewsetsToViews(Component component) {
        Window[] lWindows = component.getWindows();
        HashMap lMap = new HashMap();
        int i = 0;
        while (i < lWindows.length) {
            ServiceViewSetGeneration.transferViewsetsToViews(component, lWindows[i], lMap);
            ++i;
        }
        return lMap;
    }

    public static HashMap transferViewsetsToViews(Component component, Window window) {
        HashMap lMap = new HashMap();
        ViewsetHierarchyNode[] lNodes = window.getViewsetHierarchyRootNodes();
        int j = 0;
        while (j < lNodes.length) {
            ServiceViewSetGeneration.transferViewsetsToViews(component, lNodes[j], window.getName(), lMap);
            ++j;
        }
        return lMap;
    }

    private static HashMap transferViewsetsToViews(Component component, Window window, HashMap map) {
        ViewsetHierarchyNode[] lNodes = window.getViewsetHierarchyRootNodes();
        int j = 0;
        while (j < lNodes.length) {
            ServiceViewSetGeneration.transferViewsetsToViews(component, lNodes[j], window.getName(), map);
            ++j;
        }
        return map;
    }

    public static void cleanTemplateViewInstances(Component component) {
        Window[] lWindows = component.getWindows();
        int i = 0;
        while (i < lWindows.length) {
            ServiceViewSetGeneration.cleanTemplateViewInstances(component, lWindows[i]);
            ++i;
        }
    }

    public static void cleanTemplateViewInstances(Component component, Window window) {
        ViewsetHierarchyNode[] lNodes = window.getViewsetHierarchyRootNodes();
        int j = 0;
        while (j < lNodes.length) {
            ServiceViewSetGeneration.cleanTemplateViewInstances(component, lNodes[j], window.getName());
            ++j;
        }
    }

    private static void transferViewsetsToViews(Component component, ViewsetHierarchyNode node, String suffix, HashMap map) {
        block10: {
            block9: {
                if (!(node instanceof Viewset)) break block9;
                Viewset lViewset = (Viewset)node;
                View lView = ServiceViewSetGeneration.createTemplateViewInstance((ViewsetHierarchyNode)lViewset, component, map);
                if (lView == null) break block10;
                lViewset.setView((AbstractView)lView);
                Placeholder[] lViewAreas = lViewset.getViewAreas();
                int i = 0;
                while (i < lViewAreas.length) {
                    if (lViewAreas[i] instanceof ViewArea) {
                        ViewsetHierarchyNode[] lNodes;
                        ViewArea lViewArea = (ViewArea)lViewAreas[i];
                        ViewContainer lViewContainer = ServiceViewSetGeneration.findViewContainer(lView, lViewArea.getName());
                        if (lViewContainer != null) {
                            lViewArea.setViewContainer(lViewContainer);
                        }
                        if ((lNodes = lViewArea.getEmbeddedNodes()) != null) {
                            int j = 0;
                            while (j < lNodes.length) {
                                ServiceViewSetGeneration.transferViewsetsToViews(component, lNodes[j], suffix, map);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                break block10;
            }
            if (node instanceof ViewUsage) {
                ViewUsage lViewusage = (ViewUsage)node;
                Placeholder[] lViewAreas = lViewusage.getViewAreas();
                int i = 0;
                while (i < lViewAreas.length) {
                    ViewContainerAssignment lViewContainerAssignment;
                    ViewsetHierarchyNode[] lNodes;
                    if (lViewAreas[i] instanceof ViewContainerAssignment && (lNodes = (lViewContainerAssignment = (ViewContainerAssignment)lViewAreas[i]).getEmbeddedNodes()) != null) {
                        int j = 0;
                        while (j < lNodes.length) {
                            ServiceViewSetGeneration.transferViewsetsToViews(component, lNodes[j], suffix, map);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static void cleanTemplateViewInstances(Component component, ViewsetHierarchyNode node, String suffix) {
        block10: {
            block9: {
                if (!(node instanceof Viewset)) break block9;
                Viewset lViewset = (Viewset)node;
                if (lViewset.getView() != null && lViewset.getView().getName().indexOf(GENPREFIX) > -1) {
                    try {
                        component.getController(lViewset.getView().getName()).delete();
                        lViewset.getView().delete();
                    }
                    catch (DeleteException e) {
                        TRACE_LOCATION.catching((Throwable)e);
                        e.printStackTrace();
                    }
                }
                lViewset.setView(null);
                Placeholder[] lViewAreas = lViewset.getViewAreas();
                int i = 0;
                while (i < lViewAreas.length) {
                    if (lViewAreas[i] instanceof ViewArea) {
                        ViewArea lViewArea = (ViewArea)lViewAreas[i];
                        lViewArea.setViewContainer(null);
                        ViewsetHierarchyNode[] lNodes = lViewArea.getEmbeddedNodes();
                        int j = 0;
                        while (j < lNodes.length) {
                            ServiceViewSetGeneration.cleanTemplateViewInstances(component, lNodes[j], suffix);
                            ++j;
                        }
                    }
                    ++i;
                }
                break block10;
            }
            if (!(node instanceof ViewUsage)) break block10;
            ViewUsage lViewusage = (ViewUsage)node;
            Placeholder[] lViewAreas = lViewusage.getViewAreas();
            int i = 0;
            while (i < lViewAreas.length) {
                if (lViewAreas[i] instanceof ViewContainerAssignment) {
                    ViewContainerAssignment lViewContainerAssignment = (ViewContainerAssignment)lViewAreas[i];
                    ViewsetHierarchyNode[] lNodes = lViewContainerAssignment.getEmbeddedNodes();
                    int j = 0;
                    while (j < lNodes.length) {
                        ServiceViewSetGeneration.cleanTemplateViewInstances(component, lNodes[j], suffix);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static ViewContainer findViewContainer(View view, String name) {
        ViewContainer[] lViewContainers = view.getViewContainers();
        String lTempName = name;
        lTempName = lTempName.replace('[', '_');
        lTempName = lTempName.replace(']', '_');
        lTempName = lTempName.replace(',', '_');
        int i = 0;
        while (i < lViewContainers.length) {
            if (lViewContainers[i].getName().equals(lTempName)) {
                return lViewContainers[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < lViewContainers.length) {
            if (lViewContainers[i2].getName().equals(lTempName + "_cont")) {
                return lViewContainers[i2];
            }
            ++i2;
        }
        return null;
    }

    public static String getViewName(ViewsetHierarchyNode viewset) {
        Window window = (Window)viewset.getMDO();
        return GENPREFIX + viewset.getName() + GENPREFIX + window.getComponent().getName() + GENPREFIX + window.getName();
    }

    public static View createTemplateViewInstance(ViewsetHierarchyNode viewset, Component component, HashMap map) {
        View lView = null;
        try {
            lView = component.createView(ServiceViewSetGeneration.getViewName(viewset));
            map.put(lView, viewset);
            Controller lController = component.createController(ServiceViewSetGeneration.getViewName(viewset));
            lController.setType(ControllerTypeEnum.VIEW);
            lController.createContext();
            ContextValueNode context = lController.getContext();
            context.setSingleton(true);
            context.setSelection(CardinalityEnum._1_1);
            context.setCardinality(CardinalityEnum._1_1);
            lView.setViewController(lController);
            lView.createRootUIElementContainerAsTransparentContainer();
            if (viewset instanceof Viewset) {
                Viewset lViewset = (Viewset)viewset;
                String lType = lViewset.getViewsetDefinition().getName();
                if (lType.equals(GRIDLAYOUT)) {
                    ServiceViewSetGeneration.createGridLayout(lViewset, lView);
                } else if (lType.equals(TLAYOUT)) {
                    ServiceViewSetGeneration.createTLayout(lViewset, lView);
                } else if (lType.equals(TLAYOUT180)) {
                    ServiceViewSetGeneration.createTLayout180(lViewset, lView);
                } else if (lType.equals(TLAYOUT90)) {
                    ServiceViewSetGeneration.createTLayout90(lViewset, lView);
                } else if (lType.equals(TLAYOUT270)) {
                    ServiceViewSetGeneration.createTLayout270(lViewset, lView);
                } else if (lType.equals(TABSTRIP)) {
                    ServiceViewSetGeneration.createTabStrip(lViewset, lView);
                }
            }
        }
        catch (CreateException e) {
            TRACE_LOCATION.catching((Throwable)e);
            e.printStackTrace();
        }
        return lView;
    }

    private static void createTLayout(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.setHeight("100%");
                GridLayout grid = lContainer.createLayoutAsGridLayout();
                grid.setColCount(2);
                ViewContainerUIElement viewcontainertop = lContainer.createChildAsViewContainerUIElement(TOP);
                GridData lGridDataTop = viewcontainertop.createLayoutDataAsGridData();
                lGridDataTop.setHAlign(CellHAlign.LEFT);
                lGridDataTop.setVAlign(CellVAlign.TOP);
                lGridDataTop.setColSpan(2);
                lGridDataTop.setHeight(viewset.getViewsetProperty(HSP).getValue());
                ViewContainer viewconttop = view.createViewContainer(TOP);
                viewconttop.setViewContainerUIElement((ViewElement)viewcontainertop);
                ViewContainerUIElement viewcontainerleft = lContainer.createChildAsViewContainerUIElement(LEFT);
                ViewContainer viewcontleft = view.createViewContainer(LEFT);
                GridData lGridDataLeft = viewcontainerleft.createLayoutDataAsGridData();
                lGridDataLeft.setWidth(viewset.getViewsetProperty(VSP).getValue());
                lGridDataLeft.setHAlign(CellHAlign.LEFT);
                lGridDataLeft.setVAlign(CellVAlign.TOP);
                viewcontleft.setViewContainerUIElement((ViewElement)viewcontainerleft);
                ViewContainerUIElement viewcontainerright = lContainer.createChildAsViewContainerUIElement(RIGHT);
                ViewContainer viewcontright = view.createViewContainer(RIGHT);
                GridData lGridDataRight = viewcontainerright.createLayoutDataAsGridData();
                lGridDataRight.setHAlign(CellHAlign.LEFT);
                lGridDataRight.setVAlign(CellVAlign.TOP);
                viewcontright.setViewContainerUIElement((ViewElement)viewcontainerright);
            }
            catch (CreateException e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static void createTLayout180(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.setHeight("100%");
                GridLayout grid = lContainer.createLayoutAsGridLayout();
                grid.setColCount(2);
                ViewContainerUIElement viewcontainerleft = lContainer.createChildAsViewContainerUIElement(LEFT);
                ViewContainer viewcontleft = view.createViewContainer(LEFT);
                GridData lGridDataLeft = viewcontainerleft.createLayoutDataAsGridData();
                lGridDataLeft.setWidth(viewset.getViewsetProperty(VSP).getValue());
                lGridDataLeft.setHeight(viewset.getViewsetProperty(HSP).getValue());
                lGridDataLeft.setHAlign(CellHAlign.LEFT);
                lGridDataLeft.setVAlign(CellVAlign.TOP);
                viewcontleft.setViewContainerUIElement((ViewElement)viewcontainerleft);
                ViewContainerUIElement viewcontainerright = lContainer.createChildAsViewContainerUIElement(RIGHT);
                ViewContainer viewcontright = view.createViewContainer(RIGHT);
                GridData lGridDataRight = viewcontainerright.createLayoutDataAsGridData();
                lGridDataRight.setHeight(viewset.getViewsetProperty(HSP).getValue());
                lGridDataRight.setHAlign(CellHAlign.LEFT);
                lGridDataRight.setVAlign(CellVAlign.TOP);
                viewcontright.setViewContainerUIElement((ViewElement)viewcontainerright);
                ViewContainerUIElement viewcontainerbottom = lContainer.createChildAsViewContainerUIElement(BOTTOM);
                GridData lGridDataBottom = viewcontainerbottom.createLayoutDataAsGridData();
                lGridDataBottom.setColSpan(2);
                lGridDataBottom.setHAlign(CellHAlign.LEFT);
                lGridDataBottom.setVAlign(CellVAlign.TOP);
                ViewContainer viewcontbottom = view.createViewContainer(BOTTOM);
                viewcontbottom.setViewContainerUIElement((ViewElement)viewcontainerbottom);
            }
            catch (CreateException e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static void createTLayout90(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.setHeight("100%");
                GridLayout grid = lContainer.createLayoutAsGridLayout();
                grid.setColCount(2);
                ViewContainerUIElement viewcontainerleft = lContainer.createChildAsViewContainerUIElement(LEFT);
                ViewContainer viewcontleft = view.createViewContainer(LEFT);
                GridData lGridDataLeft = viewcontainerleft.createLayoutDataAsGridData();
                lGridDataLeft.setWidth(viewset.getViewsetProperty(VSP).getValue());
                lGridDataLeft.setHAlign(CellHAlign.LEFT);
                lGridDataLeft.setVAlign(CellVAlign.TOP);
                viewcontleft.setViewContainerUIElement((ViewElement)viewcontainerleft);
                TransparentContainer lTransparentContainer = lContainer.createChildAsTransparentContainer(view.getName() + "transparent");
                GridData lGridDataTrans = lTransparentContainer.createLayoutDataAsGridData();
                lGridDataTrans.setHAlign(CellHAlign.LEFT);
                lGridDataTrans.setVAlign(CellVAlign.TOP);
                GridLayout grid2 = lTransparentContainer.createLayoutAsGridLayout();
                grid2.setColCount(1);
                ViewContainerUIElement viewcontainerright = lTransparentContainer.createChildAsViewContainerUIElement(RIGHT);
                ViewContainer viewcontright = view.createViewContainer(RIGHT);
                GridData lGridDataRight = viewcontainerright.createLayoutDataAsGridData();
                lGridDataRight.setHeight(viewset.getViewsetProperty(HSP).getValue());
                lGridDataRight.setHAlign(CellHAlign.LEFT);
                lGridDataRight.setVAlign(CellVAlign.TOP);
                viewcontright.setViewContainerUIElement((ViewElement)viewcontainerright);
                ViewContainerUIElement viewcontainerbottom = lTransparentContainer.createChildAsViewContainerUIElement(BOTTOM);
                ViewContainer viewcontbottom = view.createViewContainer(BOTTOM);
                GridData lGridDataBottom = viewcontainerbottom.createLayoutDataAsGridData();
                lGridDataBottom.setHAlign(CellHAlign.LEFT);
                lGridDataBottom.setVAlign(CellVAlign.TOP);
                viewcontbottom.setViewContainerUIElement((ViewElement)viewcontainerbottom);
            }
            catch (CreateException e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static void createTLayout270(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.setHeight("100%");
                GridLayout grid = lContainer.createLayoutAsGridLayout();
                grid.setColCount(2);
                TransparentContainer lTransparentContainer = lContainer.createChildAsTransparentContainer(view.getName() + "transparent");
                GridData lGridDataTrans = lTransparentContainer.createLayoutDataAsGridData();
                lGridDataTrans.setHAlign(CellHAlign.LEFT);
                lGridDataTrans.setVAlign(CellVAlign.TOP);
                GridLayout grid2 = lTransparentContainer.createLayoutAsGridLayout();
                grid2.setColCount(1);
                ViewContainerUIElement viewcontainerleft = lTransparentContainer.createChildAsViewContainerUIElement(LEFT);
                ViewContainer viewcontleft = view.createViewContainer(LEFT);
                GridData lGridDataLeft = viewcontainerleft.createLayoutDataAsGridData();
                lGridDataLeft.setHeight(viewset.getViewsetProperty(HSP).getValue());
                lGridDataLeft.setWidth(viewset.getViewsetProperty(VSP).getValue());
                lGridDataLeft.setHAlign(CellHAlign.LEFT);
                lGridDataLeft.setVAlign(CellVAlign.TOP);
                viewcontleft.setViewContainerUIElement((ViewElement)viewcontainerleft);
                ViewContainerUIElement viewcontainerbottom = lTransparentContainer.createChildAsViewContainerUIElement(BOTTOM);
                ViewContainer viewcontbottom = view.createViewContainer(BOTTOM);
                GridData lGridDataBottom = viewcontainerbottom.createLayoutDataAsGridData();
                lGridDataBottom.setWidth(viewset.getViewsetProperty(VSP).getValue());
                lGridDataBottom.setHAlign(CellHAlign.LEFT);
                lGridDataBottom.setVAlign(CellVAlign.TOP);
                viewcontbottom.setViewContainerUIElement((ViewElement)viewcontainerbottom);
                ViewContainerUIElement viewcontainerright = lContainer.createChildAsViewContainerUIElement(RIGHT);
                ViewContainer viewcontright = view.createViewContainer(RIGHT);
                GridData lGridDataRight = viewcontainerright.createLayoutDataAsGridData();
                lGridDataRight.setHAlign(CellHAlign.LEFT);
                lGridDataRight.setVAlign(CellVAlign.TOP);
                viewcontright.setViewContainerUIElement((ViewElement)viewcontainerright);
            }
            catch (CreateException e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static void createGridLayout(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.setHeight("100%");
                GridLayout grid = lContainer.createLayoutAsGridLayout();
                int columns = Integer.parseInt(viewset.getViewsetProperty("columns").getValue());
                int rows = Integer.parseInt(viewset.getViewsetProperty("rows").getValue());
                grid.setColCount(columns);
                String lName = null;
                ViewContainerUIElement lViewcontainer = null;
                ViewContainer lViewcont = null;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        lName = "cell_" + (i + 1) + GENPREFIX + (j + 1) + GENPREFIX;
                        lViewcontainer = lContainer.createChildAsViewContainerUIElement(lName);
                        lViewcont = view.createViewContainer(lName);
                        lViewcont.setViewContainerUIElement((ViewElement)lViewcontainer);
                        lName = "cellHeight[" + (i + 1) + "," + (j + 1) + "]";
                        String lHeight = viewset.getViewsetProperty(lName).getValue();
                        lName = "cellWidth[" + (i + 1) + "," + (j + 1) + "]";
                        String lWidth = viewset.getViewsetProperty(lName).getValue();
                        GridData lGridData = lViewcontainer.createLayoutDataAsGridData();
                        if (lHeight != null && !lHeight.equals("") || lWidth != null && !lWidth.equals("")) {
                            if (lHeight != null && !lHeight.equals("")) {
                                lGridData.setHeight(lHeight);
                            }
                            if (lWidth != null && !lWidth.equals("")) {
                                lGridData.setWidth(lWidth);
                            }
                        }
                        lGridData.setHAlign(CellHAlign.LEFT);
                        lGridData.setVAlign(CellVAlign.TOP);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (CreateException ec) {
                TRACE_LOCATION.catching((Throwable)ec);
                ec.printStackTrace();
            }
            catch (NumberFormatException en) {
                TRACE_LOCATION.catching((Throwable)en);
                en.printStackTrace();
            }
        }
    }

    private static void createTabStrip(Viewset viewset, View view) {
        UIElementContainer lContainer = view.getRootUIElementContainer();
        if (lContainer != null) {
            try {
                lContainer.createLayoutAsFlowLayout();
                TabStrip tabstrip = lContainer.createChildAsTabStrip(view.getName() + "_tabstrip");
                int tabcount = Integer.parseInt(viewset.getViewsetProperty("tabCount").getValue());
                String lName = null;
                Tab lTab = null;
                ViewContainerUIElement lViewcontainer = null;
                ViewContainer lViewcont = null;
                int i = 0;
                while (i < tabcount) {
                    String[] lLanguages;
                    TranslatableText lText;
                    lName = "tab_" + (i + 1) + GENPREFIX;
                    lTab = tabstrip.createTab(lName);
                    lViewcontainer = lTab.createContentAsViewContainerUIElement(lName + "_cont");
                    lViewcont = view.createViewContainer(lName + "_cont");
                    lViewcont.setViewContainerUIElement((ViewElement)lViewcontainer);
                    Caption lCaption = lTab.createHeader(lName + "_header");
                    lName = "tabCaption[" + (i + 1) + "]";
                    if (viewset.getViewsetProperty(lName) != null && (lText = viewset.getViewsetProperty(lName).getTranslatedValueAsTranslatableText()) != null && (lLanguages = lText.getLanguages()) != null) {
                        int j = 0;
                        while (j < lLanguages.length) {
                            if ("".equals(lLanguages[j])) {
                                lCaption.setText(lText.getText());
                            } else {
                                lCaption.setText(lLanguages[j], lText.getText(lLanguages[j]));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (CreateException ec) {
                TRACE_LOCATION.catching((Throwable)ec);
                ec.printStackTrace();
            }
            catch (NumberFormatException en) {
                TRACE_LOCATION.catching((Throwable)en);
                en.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

